/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.AnnotatedContainingDeclaration;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiWildcardType;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UDeclaration;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UParameter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c1\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ0\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00070\u000f2\u0006\u0010\u0010\u001a\u00020\u00052\b\b\u0002\u0010\u0011\u001a\u00020\rJ\u001e\u0010\u0012\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fJ \u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u00182\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002J \u0010\u0019\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u001a\u001a\u00020\u001b2\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00070\u000fH\u0002\u00a8\u0006\u001c"}, d2={"Lcom/intellij/codeInspection/AnnotatedApiUsageUtil;", "", "<init>", "()V", "canAnnotationBeUsedInFile", "", "annotationFqn", "", "psiFile", "Lcom/intellij/psi/PsiFile;", "findAnnotatedContainingDeclaration", "Lcom/intellij/codeInspection/AnnotatedContainingDeclaration;", "target", "Lcom/intellij/psi/PsiModifierListOwner;", "annotationNames", "", "includeExternalAnnotations", "containingDeclaration", "findAnnotatedTypeUsedInDeclarationSignature", "declaration", "Lorg/jetbrains/uast/UDeclaration;", "annotations", "findAnnotatedTypeParameter", "typeParameterListOwner", "Lcom/intellij/psi/PsiTypeParameterListOwner;", "findAnnotatedTypePart", "psiType", "Lcom/intellij/psi/PsiType;", "intellij.jvm.analysis.impl"})
@ApiStatus.Internal
public final class AnnotatedApiUsageUtil {
    @NotNull
    public static final AnnotatedApiUsageUtil INSTANCE = new AnnotatedApiUsageUtil();

    private AnnotatedApiUsageUtil() {
    }

    public final boolean canAnnotationBeUsedInFile(@NotNull String annotationFqn, @NotNull PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)annotationFqn, (String)"annotationFqn");
        Intrinsics.checkNotNullParameter((Object)psiFile, (String)"psiFile");
        return JavaPsiFacade.getInstance((Project)psiFile.getProject()).findClass(annotationFqn, psiFile.getResolveScope()) != null;
    }

    @Nullable
    public final AnnotatedContainingDeclaration findAnnotatedContainingDeclaration(@NotNull PsiModifierListOwner target, @NotNull Collection<String> annotationNames, boolean includeExternalAnnotations, @NotNull PsiModifierListOwner containingDeclaration) {
        PsiClass containingClass;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(annotationNames, (String)"annotationNames");
        Intrinsics.checkNotNullParameter((Object)containingDeclaration, (String)"containingDeclaration");
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)containingDeclaration, annotationNames, (!includeExternalAnnotations ? 1 : 0) != 0);
        if (annotation != null) {
            return new AnnotatedContainingDeclaration(target, containingDeclaration, annotation);
        }
        if (containingDeclaration instanceof PsiMember && (containingClass = ((PsiMember)containingDeclaration).getContainingClass()) != null) {
            return this.findAnnotatedContainingDeclaration(target, annotationNames, includeExternalAnnotations, (PsiModifierListOwner)containingClass);
        }
        PsiFile psiFile = containingDeclaration.getContainingFile();
        Object object = psiFile instanceof PsiClassOwner ? (PsiClassOwner)psiFile : null;
        if (object == null || (object = object.getPackageName()) == null) {
            return null;
        }
        Object packageName = object;
        PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)containingDeclaration.getProject()).findPackage((String)packageName);
        if (psiPackage == null) {
            return null;
        }
        PsiPackage psiPackage2 = psiPackage;
        return this.findAnnotatedContainingDeclaration(target, annotationNames, includeExternalAnnotations, (PsiModifierListOwner)psiPackage2);
    }

    public static /* synthetic */ AnnotatedContainingDeclaration findAnnotatedContainingDeclaration$default(AnnotatedApiUsageUtil annotatedApiUsageUtil, PsiModifierListOwner psiModifierListOwner, Collection collection, boolean bl, PsiModifierListOwner psiModifierListOwner2, int n, Object object) {
        if ((n & 8) != 0) {
            psiModifierListOwner2 = psiModifierListOwner;
        }
        return annotatedApiUsageUtil.findAnnotatedContainingDeclaration(psiModifierListOwner, collection, bl, psiModifierListOwner2);
    }

    @Nullable
    public final AnnotatedContainingDeclaration findAnnotatedTypeUsedInDeclarationSignature(@NotNull UDeclaration declaration, @NotNull Collection<String> annotations) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter(annotations, (String)"annotations");
        UDeclaration uDeclaration = declaration;
        if (uDeclaration instanceof UClass) {
            return this.findAnnotatedTypeParameter((PsiTypeParameterListOwner)((UClass)declaration).getJavaPsi(), annotations);
        }
        if (uDeclaration instanceof UMethod) {
            for (UParameter uastParameter : ((UMethod)declaration).getUastParameters()) {
                PsiType psiType = uastParameter.getType().getDeepComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getDeepComponentType(...)");
                AnnotatedContainingDeclaration annotatedParamType = this.findAnnotatedTypePart(psiType, annotations);
                if (annotatedParamType == null) continue;
                return annotatedParamType;
            }
            PsiType returnType = ((UMethod)declaration).getReturnType();
            if (returnType != null) {
                PsiType psiType = returnType.getDeepComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getDeepComponentType(...)");
                AnnotatedContainingDeclaration annotatedReturnType = this.findAnnotatedTypePart(psiType, annotations);
                if (annotatedReturnType != null) {
                    return annotatedReturnType;
                }
            }
            return this.findAnnotatedTypeParameter((PsiTypeParameterListOwner)((UMethod)declaration).getJavaPsi(), annotations);
        }
        if (uDeclaration instanceof UField) {
            PsiType psiType = ((UField)declaration).getType().getDeepComponentType();
            Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getDeepComponentType(...)");
            return this.findAnnotatedTypePart(psiType, annotations);
        }
        return null;
    }

    private final AnnotatedContainingDeclaration findAnnotatedTypeParameter(PsiTypeParameterListOwner typeParameterListOwner, Collection<String> annotations) {
        for (PsiTypeParameter typeParameter : typeParameterListOwner.getTypeParameters()) {
            for (PsiClassType referencedType : typeParameter.getExtendsList().getReferencedTypes()) {
                PsiType psiType = referencedType.getDeepComponentType();
                Intrinsics.checkNotNullExpressionValue((Object)psiType, (String)"getDeepComponentType(...)");
                AnnotatedContainingDeclaration annotatedContainingDeclaration = this.findAnnotatedTypePart(psiType, annotations);
                if (annotatedContainingDeclaration == null) continue;
                return annotatedContainingDeclaration;
            }
        }
        return null;
    }

    private final AnnotatedContainingDeclaration findAnnotatedTypePart(PsiType psiType, Collection<String> annotations) {
        if (psiType instanceof PsiClassType) {
            AnnotatedContainingDeclaration containingDeclaration;
            PsiClass psiClass = ((PsiClassType)psiType).resolve();
            if (psiClass != null && (containingDeclaration = AnnotatedApiUsageUtil.findAnnotatedContainingDeclaration$default(this, (PsiModifierListOwner)psiClass, annotations, false, null, 8, null)) != null) {
                return containingDeclaration;
            }
            for (PsiType parameterType : ((PsiClassType)psiType).getParameters()) {
                Intrinsics.checkNotNull((Object)parameterType);
                AnnotatedContainingDeclaration parameterResult = this.findAnnotatedTypePart(parameterType, annotations);
                if (parameterResult == null) continue;
                return parameterResult;
            }
        }
        if (psiType instanceof PsiWildcardType) {
            PsiType psiType2 = ((PsiWildcardType)psiType).getExtendsBound();
            Intrinsics.checkNotNullExpressionValue((Object)psiType2, (String)"getExtendsBound(...)");
            AnnotatedContainingDeclaration annotatedContainingDeclaration = this.findAnnotatedTypePart(psiType2, annotations);
            if (annotatedContainingDeclaration == null) {
                PsiType psiType3 = ((PsiWildcardType)psiType).getSuperBound();
                Intrinsics.checkNotNullExpressionValue((Object)psiType3, (String)"getSuperBound(...)");
                annotatedContainingDeclaration = this.findAnnotatedTypePart(psiType3, annotations);
            }
            return annotatedContainingDeclaration;
        }
        return null;
    }
}

