/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant;

import com.google.common.collect.ImmutableList;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.UrlPrefix;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class DeepLinks {
    private final List<DeepLink> myDeepLinkList = Collections.synchronizedList(new ArrayList());

    public synchronized int addLink(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean alwaysAddToEnd) {
        DeepLink newDeepLink = new DeepLink(order, activityData, url, pathData);
        if (!alwaysAddToEnd) {
            for (int i = 0; i < this.myDeepLinkList.size(); ++i) {
                DeepLink deepLink = this.myDeepLinkList.get(i);
                if (!deepLink.getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                if (deepLink.getOrder().getIntValue() > newDeepLink.getOrder().getIntValue()) {
                    this.myDeepLinkList.add(i, newDeepLink);
                    return i;
                }
                if (i != this.myDeepLinkList.size() - 1 && this.myDeepLinkList.get(i + 1).getActivityData().getModuleName().equals(activityData.getModuleName())) continue;
                this.myDeepLinkList.add(i + 1, newDeepLink);
                return i + 1;
            }
        }
        this.myDeepLinkList.add(newDeepLink);
        return this.myDeepLinkList.size() - 1;
    }

    public synchronized void clear() {
        this.myDeepLinkList.clear();
    }

    public synchronized void removeLinkAt(int index) {
        this.myDeepLinkList.remove(index);
    }

    public synchronized int updateLink(@NotNull Order order, @NotNull UrlPrefix url, @NotNull PathData pathData, @NotNull ActivityData activityData, boolean supportOrder, int index) {
        if (index < 0 || index >= this.myDeepLinkList.size()) {
            throw new ArrayIndexOutOfBoundsException("index:" + index + "is invalid.");
        }
        DeepLink deepLink = this.myDeepLinkList.get(index);
        if (!activityData.getModuleName().equals(deepLink.getActivityData().getModuleName()) || supportOrder && deepLink.getOrder().getIntValue() != order.getIntValue()) {
            this.myDeepLinkList.remove(index);
            return this.addLink(order, url, pathData, activityData, supportOrder);
        }
        deepLink.myUrlPrefix = url;
        deepLink.myPathData = pathData;
        deepLink.myActivityData = activityData;
        return index;
    }

    @NotNull
    public final synchronized ImmutableList<DeepLink> getDeepLinkList() {
        return ImmutableList.copyOf(this.myDeepLinkList);
    }

    public synchronized void addDeepLinks(@NotNull List<DeepLink> deepLinkList) {
        this.myDeepLinkList.addAll(deepLinkList);
    }

    public static class DeepLink {
        private UrlPrefix myUrlPrefix;
        private ActivityData myActivityData;
        private PathData myPathData;
        private final Order myOrder;

        public DeepLink(@NotNull Order order, @NotNull ActivityData data, @NotNull UrlPrefix url, @NotNull PathData path) {
            this.myActivityData = data;
            this.myUrlPrefix = url;
            this.myPathData = path;
            this.myOrder = order;
        }

        @NotNull
        public synchronized UrlPrefix getUrl() {
            return this.myUrlPrefix;
        }

        @NotNull
        public synchronized PathData getPath() {
            return this.myPathData;
        }

        @NotNull
        public synchronized ActivityData getActivityData() {
            return this.myActivityData;
        }

        @NotNull
        public synchronized Order getOrder() {
            return this.myOrder;
        }
    }
}

