/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.gservices.DeprecationBanner;
import com.android.tools.idea.gservices.DevServicesDeprecationData;
import com.google.urlassistant.datalayer.db.DalApisConsentStore;
import com.google.urlassistant.servicecompatibility.ServiceCompatibilityBanner;
import com.google.urlassistant.servicecompatibility.ServiceCompatibilityState;
import com.google.urlassistant.ui.AppLinkOverview;
import com.google.urlassistant.ui.MissingUrlsOverview;
import com.google.urlassistant.ui.UiUtils;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.UrlAssistantSidePanelKt;
import com.google.urlassistant.ui.models.AppLinkOverviewModel;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.util.IJSwingUtilities;
import icons.StudioIcons;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagLayout;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.flow.FlowCollector;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0019\b\u0007\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010$\u001a\u00020%H\u0016J\u0006\u0010&\u001a\u00020%R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\u00020\f8\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0016\u0010\u000f\u001a\u00020\u00108\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00148BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u0019\u001a\u00020\u0001@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u001c\"\u0004\b\u001d\u0010\u001eR\"\u0010!\u001a\u0004\u0018\u00010 2\b\u0010\u001f\u001a\u0004\u0018\u00010 @BX\u0082\u000e\u00a2\u0006\b\n\u0000\"\u0004\b\"\u0010#\u00a8\u0006'"}, d2={"Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "parentDisposable", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/Disposable;)V", "rootPanel", "tabbedPane", "Lcom/intellij/ui/components/JBTabbedPane;", "appLinkOverview", "Lcom/google/urlassistant/ui/AppLinkOverview;", "getAppLinkOverview", "()Lcom/google/urlassistant/ui/AppLinkOverview;", "missingUrlsOverview", "Lcom/google/urlassistant/ui/MissingUrlsOverview;", "getMissingUrlsOverview", "()Lcom/google/urlassistant/ui/MissingUrlsOverview;", "serviceCompatibilityState", "Lcom/google/urlassistant/servicecompatibility/ServiceCompatibilityState;", "getServiceCompatibilityState", "()Lcom/google/urlassistant/servicecompatibility/ServiceCompatibilityState;", "scope", "Lkotlinx/coroutines/CoroutineScope;", "newContent", "content", "getContent", "()Ljavax/swing/JPanel;", "setContent", "(Ljavax/swing/JPanel;)V", "value", "Lcom/android/tools/idea/gservices/DeprecationBanner;", "deprecatedBanner", "setDeprecatedBanner", "(Lcom/android/tools/idea/gservices/DeprecationBanner;)V", "dispose", "", "showSidePanel", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nUrlAssistantSidePanel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlAssistantSidePanel.kt\ncom/google/urlassistant/ui/UrlAssistantSidePanel\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,163:1\n1#2:164\n1310#3,2:165\n*S KotlinDebug\n*F\n+ 1 UrlAssistantSidePanel.kt\ncom/google/urlassistant/ui/UrlAssistantSidePanel\n*L\n93#1:165,2\n*E\n"})
public final class UrlAssistantSidePanel
extends JPanel
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final JPanel rootPanel;
    @NotNull
    private final JBTabbedPane tabbedPane;
    @VisibleForTesting
    @NotNull
    private final AppLinkOverview appLinkOverview;
    @VisibleForTesting
    @NotNull
    private final MissingUrlsOverview missingUrlsOverview;
    @NotNull
    private final CoroutineScope scope;
    @NotNull
    private JPanel content;
    @Nullable
    private DeprecationBanner deprecatedBanner;

    @UiThread
    public UrlAssistantSidePanel(@NotNull Project project, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.project = project;
        this.rootPanel = new JPanel(new GridBagLayout());
        this.tabbedPane = new JBTabbedPane();
        this.appLinkOverview = new AppLinkOverview(this.project, this, new AppLinkOverviewModel(this.project, this));
        this.missingUrlsOverview = new MissingUrlsOverview();
        this.scope = CoroutineUtilsKt.createCoroutineScope$default((Disposable)this, null, null, (int)3, null);
        this.content = new JPanel(new GridBagLayout());
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.setLayout(new BorderLayout());
        this.tabbedPane.addTab(UrlAssistantBundle.message("tab.all.links.title", new Object[0]), StudioIcons.Assistant.AppLinks.ALL_LINKS, (Component)this.appLinkOverview, UrlAssistantBundle.message("tab.all.links.tooltip", new Object[0]));
        this.tabbedPane.addTab(UrlAssistantBundle.message("tab.missing.urls.title", new Object[0]), StudioIcons.Assistant.AppLinks.MISSING_LINKS, (Component)this.missingUrlsOverview, UrlAssistantBundle.message("tab.missing.urls.tooltip", new Object[0]));
        this.rootPanel.add((Component)this.tabbedPane, UiUtils.createConstraintsForExpander$default(UiUtils.INSTANCE, 0, 0, 3, null));
        this.showSidePanel();
    }

    @NotNull
    public final AppLinkOverview getAppLinkOverview() {
        return this.appLinkOverview;
    }

    @NotNull
    public final MissingUrlsOverview getMissingUrlsOverview() {
        return this.missingUrlsOverview;
    }

    private final ServiceCompatibilityState getServiceCompatibilityState() {
        return ServiceCompatibilityState.Companion.getInstance();
    }

    @NotNull
    public final JPanel getContent() {
        return this.content;
    }

    public final void setContent(@NotNull JPanel newContent) {
        Intrinsics.checkNotNullParameter((Object)newContent, (String)"newContent");
        newContent.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.removeAll();
        Component component = UrlAssistantSidePanelKt.access$containsScrollPane(newContent) ? this.add(newContent) : this.add((Component)new JBScrollPane((Component)newContent));
        IJSwingUtilities.updateComponentTreeUI((Component)newContent);
        this.validate();
        this.repaint();
        if (!Intrinsics.areEqual((Object)this.content, (Object)this.appLinkOverview)) {
            JPanel jPanel = this.content;
            Disposable disposable = jPanel instanceof Disposable ? (Disposable)jPanel : null;
            if (disposable != null) {
                Disposable it = disposable;
                boolean bl = false;
                Disposer.dispose((Disposable)it);
            }
        }
        this.content = newContent;
        ApplicationManager.getApplication().invokeLater(() -> UrlAssistantSidePanel._set_content_$lambda$2(newContent));
    }

    private final void setDeprecatedBanner(DeprecationBanner value) {
        if (this.deprecatedBanner != null) {
            this.remove((Component)this.deprecatedBanner);
        }
        if (value != null) {
            super.add((Component)value, "North");
        }
        this.revalidate();
        this.deprecatedBanner = value;
    }

    public void dispose() {
    }

    public final void showSidePanel() {
        if (((Boolean)StudioFlags.ALA_SERVICE_COMPATIBILITY_ENABLED.get()).booleanValue()) {
            BuildersKt.launch$default((CoroutineScope)this.scope, null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                int label;
                final /* synthetic */ UrlAssistantSidePanel this$0;
                {
                    this.this$0 = $receiver;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final Object invokeSuspend(Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = UrlAssistantSidePanel.access$getServiceCompatibilityState(this.this$0).getDeprecationDataFlow().collect(new FlowCollector(this.this$0){
                                final /* synthetic */ UrlAssistantSidePanel this$0;
                                {
                                    this.this$0 = $receiver;
                                }

                                public final Object emit(DevServicesDeprecationData data, Continuation<? super Unit> $completion) {
                                    DalApisConsentStore.Companion.getInstance(UrlAssistantSidePanel.access$getProject$p(this.this$0)).setApiDeprecated(data.isUnsupported());
                                    if (data.isSupported()) {
                                        UrlAssistantSidePanel.access$setDeprecatedBanner(this.this$0, null);
                                        return Unit.INSTANCE;
                                    }
                                    UrlAssistantSidePanel.access$setDeprecatedBanner(this.this$0, new ServiceCompatibilityBanner(UrlAssistantSidePanel.access$getProject$p(this.this$0), data, (Function0<Unit>)((Function0)() -> showSidePanel.1.emit$lambda$0(this.this$0))));
                                    return Unit.INSTANCE;
                                }

                                private static final Unit emit$lambda$0(UrlAssistantSidePanel this$0) {
                                    UrlAssistantSidePanel.access$setDeprecatedBanner(this$0, null);
                                    return Unit.INSTANCE;
                                }
                            }, (Continuation)this);
                            if (object3 != object2) throw new KotlinNothingValueException();
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            throw new KotlinNothingValueException();
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }
        this.setContent((Boolean)StudioFlags.MISSING_URLS_FEATURE.get() != false ? this.rootPanel : (JPanel)this.appLinkOverview);
    }

    private static final void _set_content_$lambda$2(JPanel $newContent) {
        block2: {
            Object object;
            block1: {
                Component[] componentArray = $newContent.getComponents();
                Intrinsics.checkNotNullExpressionValue((Object)componentArray, (String)"getComponents(...)");
                Object[] $this$firstOrNull$iv = componentArray;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Component it = (Component)element$iv;
                    boolean bl = false;
                    if (!it.isFocusable()) continue;
                    object = element$iv;
                    break block1;
                }
                object = null;
            }
            Component component = (Component)object;
            if (component == null) break block2;
            component.requestFocusInWindow();
        }
    }

    public static final /* synthetic */ ServiceCompatibilityState access$getServiceCompatibilityState(UrlAssistantSidePanel $this) {
        return $this.getServiceCompatibilityState();
    }

    public static final /* synthetic */ Project access$getProject$p(UrlAssistantSidePanel $this) {
        return $this.project;
    }

    public static final /* synthetic */ void access$setDeprecatedBanner(UrlAssistantSidePanel $this, DeprecationBanner value) {
        $this.setDeprecatedBanner(value);
    }
}

