/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.models;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.db.DalApisConsentStore;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebAssociationMeta;
import com.google.urlassistant.datalayer.model.validation.webchecksummary.webassociationcheck.WebCheckSummary;
import com.google.urlassistant.ui.models.BaseOverviewTableModel;
import com.google.urlassistant.ui.models.BaseTableColumnOption;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0001\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0014H\u0016J\u001a\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u0014H\u0016J\u0014\u0010\u001a\u001a\u0006\u0012\u0002\b\u00030\u001b2\u0006\u0010\u001c\u001a\u00020\u0014H\u0016R0\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000bR\u001a\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u000b\u00a8\u0006\u001e"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "Lcom/google/urlassistant/ui/models/BaseOverviewTableModel;", "linkInfos", "", "Lcom/google/urlassistant/datalayer/feature/listlinks/LinkInfo;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Ljava/util/List;Lcom/intellij/openapi/project/Project;)V", "value", "getLinkInfos", "()Ljava/util/List;", "setLinkInfos", "(Ljava/util/List;)V", "columnOptions", "Lcom/google/urlassistant/ui/models/BaseTableColumnOption;", "getColumnOptions", "selectableColumnOptions", "getSelectableColumnOptions", "getRowCount", "", "getColumnCount", "getValueAt", "", "rowIndex", "columnIndex", "getColumnClass", "Ljava/lang/Class;", "modelColumnIndex", "Companion", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewModel.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,559:1\n785#2:560\n796#2:561\n1872#2,2:562\n797#2,2:564\n1874#2:566\n799#2:567\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewModel.kt\ncom/google/urlassistant/ui/models/AppLinkOverviewTableModel\n*L\n522#1:560\n522#1:561\n522#1:562,2\n522#1:564,2\n522#1:566\n522#1:567\n*E\n"})
public final class AppLinkOverviewTableModel
extends BaseOverviewTableModel {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private List<LinkInfo> linkInfos;
    @NotNull
    private final List<BaseTableColumnOption> columnOptions;
    @NotNull
    private final List<BaseTableColumnOption> selectableColumnOptions;
    public static final int SCHEME_MODEL_COLUMN_INDEX = 0;
    public static final int HOST_MODEL_COLUMN_INDEX = 1;
    public static final int PATH_MODEL_COLUMN_INDEX = 2;
    public static final int ACTIVITY_MODEL_COLUMN_INDEX = 3;
    public static final int APP_CHECKS_FAILED_MODEL_COLUMN_INDEX = 4;
    public static final int WEB_CHECKS_FAILED_MODEL_COLUMN_INDEX = 5;
    public static final int LINKS_WITH_SAME_DOMAIN_MODEL_COLUMN_INDEX = 6;
    public static final int ARROW_BUTTON_INDEX = 7;

    /*
     * WARNING - void declaration
     */
    public AppLinkOverviewTableModel(@NotNull List<LinkInfo> linkInfos, @NotNull Project project) {
        void $this$filterIndexedTo$iv$iv;
        void $this$filterIndexed$iv;
        Intrinsics.checkNotNullParameter(linkInfos, (String)"linkInfos");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.linkInfos = linkInfos;
        Object object = new BaseTableColumnOption[8];
        String string = UrlAssistantBundle.message("overview.column.scheme", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        object[0] = new BaseTableColumnOption(string, 0, true, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string2 = UrlAssistantBundle.message("overview.column.host", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        object[1] = new BaseTableColumnOption(string2, 1, true, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string3 = UrlAssistantBundle.message("overview.column.path", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"message(...)");
        object[2] = new BaseTableColumnOption(string3, 2, true, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string4 = UrlAssistantBundle.message("overview.column.activity.name", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"message(...)");
        object[3] = new BaseTableColumnOption(string4, 3, false, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string5 = UrlAssistantBundle.message("overview.column.app.check.failures", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"message(...)");
        object[4] = new BaseTableColumnOption(string5, 4, true, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string6 = UrlAssistantBundle.message("overview.column.web.check.failures", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"message(...)");
        object[5] = new BaseTableColumnOption(string6, 5, DalApisConsentStore.Companion.getInstance(project).getCanGetResults(), (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        String string7 = UrlAssistantBundle.message("overview.column.links.with.same.domain", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"message(...)");
        object[6] = new BaseTableColumnOption(string7, 6, false, (Function1<? super BaseTableColumnOption, Unit>)((Function1)new Function1<BaseTableColumnOption, Unit>((Object)this){

            public final void invoke(BaseTableColumnOption p0) {
                Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
                ((AppLinkOverviewTableModel)this.receiver).onColumnSelectionChange(p0);
            }
        }));
        object[7] = new BaseTableColumnOption("", 7, true, (Function1<? super BaseTableColumnOption, Unit>)((Function1)AppLinkOverviewTableModel::columnOptions$lambda$0));
        this.columnOptions = CollectionsKt.listOf((Object[])object);
        object = this.getColumnOptions();
        AppLinkOverviewTableModel appLinkOverviewTableModel = this;
        boolean $i$f$filterIndexed = false;
        void var5_6 = $this$filterIndexed$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterIndexedTo = false;
        void $this$forEachIndexed$iv$iv$iv = $this$filterIndexedTo$iv$iv;
        boolean $i$f$forEachIndexed = false;
        int index$iv$iv$iv = 0;
        for (Object item$iv$iv$iv : $this$forEachIndexed$iv$iv$iv) {
            void element$iv$iv;
            int n;
            if ((n = index$iv$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv$iv;
            int index$iv$iv = n;
            boolean bl = false;
            BaseTableColumnOption cfr_ignored_0 = (BaseTableColumnOption)element$iv$iv;
            int idx = index$iv$iv;
            boolean bl2 = false;
            if (!(idx != 7)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        appLinkOverviewTableModel.selectableColumnOptions = (List)destination$iv$iv;
    }

    @NotNull
    public final List<LinkInfo> getLinkInfos() {
        return this.linkInfos;
    }

    public final void setLinkInfos(@NotNull List<LinkInfo> value) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        this.linkInfos = value;
        ApplicationManager.getApplication().invokeLater(this::fireTableDataChanged);
    }

    @Override
    @NotNull
    public List<BaseTableColumnOption> getColumnOptions() {
        return this.columnOptions;
    }

    @Override
    @NotNull
    public List<BaseTableColumnOption> getSelectableColumnOptions() {
        return this.selectableColumnOptions;
    }

    @Override
    public int getRowCount() {
        return this.linkInfos.size();
    }

    @Override
    public int getColumnCount() {
        return 8;
    }

    @Override
    @Nullable
    public Object getValueAt(int rowIndex, int columnIndex) {
        LinkInfo linkInfo = (LinkInfo)CollectionsKt.getOrNull(this.linkInfos, (int)rowIndex);
        if (linkInfo == null) {
            return null;
        }
        LinkInfo link = linkInfo;
        Object result = switch (columnIndex) {
            case 0 -> link.getSingleLinkDataTagConfig().getScheme();
            case 1 -> link.getSingleLinkDataTagConfig().getRawHost();
            case 2 -> link.getSingleLinkDataTagConfig().getRawPath();
            case 3 -> link.getActivityConfig().getActivityName();
            case 4 -> link.getAppCheckSummary().getTotalFailedIntentFilterChecks();
            case 5 -> {
                WebCheckSummary v2 = link.getWebCheckSummary();
                if (v2 != null) {
                    yield v2.getTotalFailedWebAssociationChecks();
                }
                yield null;
            }
            case 6 -> {
                WebAssociationMeta v3 = link.getWebAssociationMeta();
                if (v3 != null) {
                    yield v3.getTotalAffectedAppLinks();
                }
                yield null;
            }
            case 7 -> link;
            default -> throw new AssertionError(columnIndex);
        };
        return result;
    }

    @Override
    @NotNull
    public Class<?> getColumnClass(int modelColumnIndex) {
        return switch (modelColumnIndex) {
            case 0, 1, 2, 3 -> String.class;
            case 4, 5, 6 -> Integer.TYPE;
            case 7 -> LinkInfo.class;
            default -> throw new AssertionError(modelColumnIndex);
        };
    }

    private static final Unit columnOptions$lambda$0(BaseTableColumnOption it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\b\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel$Companion;", "", "<init>", "()V", "SCHEME_MODEL_COLUMN_INDEX", "", "HOST_MODEL_COLUMN_INDEX", "PATH_MODEL_COLUMN_INDEX", "ACTIVITY_MODEL_COLUMN_INDEX", "APP_CHECKS_FAILED_MODEL_COLUMN_INDEX", "WEB_CHECKS_FAILED_MODEL_COLUMN_INDEX", "LINKS_WITH_SAME_DOMAIN_MODEL_COLUMN_INDEX", "ARROW_BUTTON_INDEX", "url-assistant"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

