/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.ui.tables;

import com.android.annotations.concurrency.UiThread;
import com.google.urlassistant.datalayer.feature.listlinks.LinkInfo;
import com.google.urlassistant.ui.AppLinkDetail;
import com.google.urlassistant.ui.AppLinkOverview;
import com.google.urlassistant.ui.UrlAssistantSidePanel;
import com.google.urlassistant.ui.models.AppLinkDetailModel;
import com.google.urlassistant.ui.models.AppLinkOverviewModel;
import com.google.urlassistant.ui.models.AppLinkOverviewTableModel;
import com.google.urlassistant.ui.models.BaseTableColumnOption;
import com.google.urlassistant.ui.tables.AppLinkTableCellRenderer;
import com.google.urlassistant.ui.tables.AppLinkTableExpandableItemsHandler;
import com.google.urlassistant.ui.tables.ArrowButtonCellRenderer;
import com.google.urlassistant.ui.tables.BaseOverviewTable;
import com.google.urlassistant.ui.tables.HeaderCellRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.ExpandableItemsHandler;
import com.intellij.ui.TableCell;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumn;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@UiThread
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0001\u0018\u00002\u00020\u00012\u00020\u0002B/\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0004\b\r\u0010\u000eJ\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0011H\u0016J\u0010\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u0010\u0010\u001e\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u000e\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020!0 H\u0014J\b\u0010\"\u001a\u00020\u0019H\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u0011X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0017\u00a8\u0006#"}, d2={"Lcom/google/urlassistant/ui/tables/AppLinkOverviewTable;", "Lcom/google/urlassistant/ui/tables/BaseOverviewTable;", "Lcom/intellij/openapi/Disposable;", "project", "Lcom/intellij/openapi/project/Project;", "overviewModel", "Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;", "model", "Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;", "sidePanelParent", "Lcom/google/urlassistant/ui/UrlAssistantSidePanel;", "appLinkOverviewParent", "Lcom/google/urlassistant/ui/AppLinkOverview;", "<init>", "(Lcom/intellij/openapi/project/Project;Lcom/google/urlassistant/ui/models/AppLinkOverviewModel;Lcom/google/urlassistant/ui/models/AppLinkOverviewTableModel;Lcom/google/urlassistant/ui/UrlAssistantSidePanel;Lcom/google/urlassistant/ui/AppLinkOverview;)V", "hiddenColumns", "", "", "Ljavax/swing/table/TableColumn;", "headerCellRenderer", "Lcom/google/urlassistant/ui/tables/HeaderCellRenderer;", "actionColumnIndex", "getActionColumnIndex", "()I", "performAction", "", "row", "onColumnSelection", "column", "Lcom/google/urlassistant/ui/models/BaseTableColumnOption;", "hideColumn", "createExpandableItemsHandler", "Lcom/intellij/ui/ExpandableItemsHandler;", "Lcom/intellij/ui/TableCell;", "dispose", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nAppLinkOverviewTable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AppLinkOverviewTable.kt\ncom/google/urlassistant/ui/tables/AppLinkOverviewTable\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,191:1\n1863#2,2:192\n*S KotlinDebug\n*F\n+ 1 AppLinkOverviewTable.kt\ncom/google/urlassistant/ui/tables/AppLinkOverviewTable\n*L\n102#1:192,2\n*E\n"})
public final class AppLinkOverviewTable
extends BaseOverviewTable
implements Disposable {
    @NotNull
    private final Project project;
    @NotNull
    private final AppLinkOverviewModel overviewModel;
    @NotNull
    private final AppLinkOverviewTableModel model;
    @NotNull
    private final UrlAssistantSidePanel sidePanelParent;
    @NotNull
    private final AppLinkOverview appLinkOverviewParent;
    @NotNull
    private final Map<Integer, TableColumn> hiddenColumns;
    @NotNull
    private final HeaderCellRenderer headerCellRenderer;
    private final int actionColumnIndex;

    public AppLinkOverviewTable(@NotNull Project project, @NotNull AppLinkOverviewModel overviewModel, @NotNull AppLinkOverviewTableModel model2, @NotNull UrlAssistantSidePanel sidePanelParent, @NotNull AppLinkOverview appLinkOverviewParent) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)overviewModel, (String)"overviewModel");
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)sidePanelParent, (String)"sidePanelParent");
        Intrinsics.checkNotNullParameter((Object)appLinkOverviewParent, (String)"appLinkOverviewParent");
        super(model2);
        this.project = project;
        this.overviewModel = overviewModel;
        this.model = model2;
        this.sidePanelParent = sidePanelParent;
        this.appLinkOverviewParent = appLinkOverviewParent;
        this.hiddenColumns = new LinkedHashMap();
        JTableHeader jTableHeader = this.getTableHeader();
        Intrinsics.checkNotNullExpressionValue((Object)jTableHeader, (String)"getTableHeader(...)");
        this.headerCellRenderer = new HeaderCellRenderer(jTableHeader, this.overviewModel);
        Disposer.register((Disposable)this.appLinkOverviewParent, (Disposable)this);
        this.getTableHeader().setReorderingAllowed(false);
        this.getTableHeader().setDefaultRenderer(this.headerCellRenderer);
        this.setRowSorter(null);
        this.getTableHeader().addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                super.mouseClicked(e);
                int modelColumn = this.convertColumnIndexToModel(this.columnAtPoint(e.getPoint()));
                switch (modelColumn) {
                    case -1: 
                    case 7: {
                        return;
                    }
                }
                overviewModel.onSortChange(modelColumn);
            }
        });
        this.getTableHeader().addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyPressed(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            }

            @Override
            public void keyReleased(KeyEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                if (this.getSelectedColumn() == 7 || this.getSelectedColumn() == -1) {
                    return;
                }
                if (e.getKeyCode() == 10 || e.getKeyCode() == 32) {
                    overviewModel.onSortChange(this.getSelectedColumn());
                }
            }
        });
        this.setDefaultRenderer(String.class, new AppLinkTableCellRenderer());
        this.setDefaultRenderer(Integer.TYPE, new AppLinkTableCellRenderer());
        this.setDefaultRenderer(LinkInfo.class, new ArrowButtonCellRenderer());
        this.setupEasyFocusTraversing();
        this.setExpandableItemsEnabled(true);
        Iterable $this$forEach$iv = this.model.getColumnOptions();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            BaseTableColumnOption it = (BaseTableColumnOption)element$iv;
            boolean bl = false;
            if (it.getSelected()) continue;
            this.hideColumn(it);
        }
        this.model.addColumnSelectionListener(arg_0 -> AppLinkOverviewTable._init_$lambda$1(this, arg_0));
        this.actionColumnIndex = 7;
    }

    @Override
    public int getActionColumnIndex() {
        return this.actionColumnIndex;
    }

    @Override
    public void performAction(int row) {
        if (!(0 <= row ? row < this.model.getLinkInfos().size() : false)) {
            return;
        }
        this.sidePanelParent.setContent(new AppLinkDetail(this.project, this.sidePanelParent, new AppLinkDetailModel(this.project, this.sidePanelParent, this.model.getLinkInfos().get(row))));
    }

    private final void onColumnSelection(BaseTableColumnOption column) {
        if (column.getSelected()) {
            TableColumn tableColumn = this.hiddenColumns.get(column.getModelIndex());
            if (tableColumn == null) {
                return;
            }
            TableColumn hiddenColumn = tableColumn;
            this.hiddenColumns.remove(hiddenColumn.getModelIndex());
            this.addColumn(hiddenColumn);
            int correctPosition = hiddenColumn.getModelIndex();
            int n = hiddenColumn.getModelIndex();
            for (int i = 0; i < n; ++i) {
                if (!this.hiddenColumns.containsKey(i)) continue;
                --correctPosition;
            }
            this.moveColumn(this.model.getColumnCount() - this.hiddenColumns.size() - 1, correctPosition);
        } else {
            this.hideColumn(column);
        }
    }

    private final void hideColumn(BaseTableColumnOption column) {
        TableColumn tableColumn = this.getColumn(column.getName());
        if (tableColumn == null) {
            return;
        }
        TableColumn columnToHide = tableColumn;
        this.hiddenColumns.put(columnToHide.getModelIndex(), columnToHide);
        this.removeColumn(columnToHide);
    }

    @NotNull
    protected ExpandableItemsHandler<TableCell> createExpandableItemsHandler() {
        return (ExpandableItemsHandler)new AppLinkTableExpandableItemsHandler(this);
    }

    public void dispose() {
        this.setDefaultRenderer(String.class, null);
        this.setDefaultRenderer(Integer.TYPE, null);
    }

    private static final void _init_$lambda$1(AppLinkOverviewTable this$0, BaseTableColumnOption column) {
        Intrinsics.checkNotNullParameter((Object)column, (String)"column");
        this$0.onColumnSelection(column);
    }
}

