/*
 * Decompiled with CFR 0.152.
 */
package com.google.urlassistant.util;

import com.android.tools.idea.concurrency.CoroutineUtilsKt;
import com.google.common.net.HostSpecifier;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.urlassistant.ActivityData;
import com.google.urlassistant.DeepLinks;
import com.google.urlassistant.Order;
import com.google.urlassistant.PathData;
import com.google.urlassistant.PathType;
import com.google.urlassistant.UrlPrefix;
import com.google.urlassistant.datalayer.model.HostAndPort;
import com.google.urlassistant.util.AndroidPatternMatcher;
import com.google.urlassistant.util.DeepLinkUtils;
import com.google.urlassistant.util.IntentFilterUtils;
import com.google.urlassistant.util.UrlAssistantBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.xml.XmlTag;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.guava.ListenableFutureKt;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000~\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J(\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u001a\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0007J\u001e\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00190\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 H\u0007J\u0010\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020\u0019H\u0007J \u0010#\u001a\u0004\u0018\u00010\u00122\f\u0010$\u001a\b\u0012\u0004\u0012\u00020&0%2\u0006\u0010\"\u001a\u00020\u0019H\u0007J/\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020\n2\u0006\u0010+\u001a\u00020,2\b\u0010-\u001a\u0004\u0018\u00010\u0019H\u0000\u00a2\u0006\u0002\b.\u00a8\u0006/"}, d2={"Lcom/google/urlassistant/util/UrlAssistUtils;", "", "<init>", "()V", "createDeepLinkIntentFilter", "Lcom/intellij/psi/xml/XmlTag;", "order", "Lcom/google/urlassistant/Order;", "activityTag", "urlPrefix", "Lcom/google/urlassistant/UrlPrefix;", "pathData", "Lcom/google/urlassistant/PathData;", "openActivityFile", "", "project", "Lcom/intellij/openapi/project/Project;", "activityData", "Lcom/google/urlassistant/ActivityData;", "openVirtualFile", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "matchesHost", "", "actualHost", "", "hostRegex", "getFirstValidUrl", "Lcom/google/common/util/concurrent/ListenableFuture;", "module", "Lcom/intellij/openapi/module/Module;", "disposableParent", "Lcom/intellij/openapi/Disposable;", "isUrlValid", "urlString", "findAssociatedActivity", "myDeepLinkList", "", "Lcom/google/urlassistant/DeepLinks$DeepLink;", "matchesUrl", "urlToMatch", "Ljava/net/URL;", "linkPatternOrigin", "linkPatternPathType", "Lcom/google/urlassistant/PathType;", "linkPatternPath", "matchesUrl$url_assistant", "url-assistant"})
@SourceDebugExtension(value={"SMAP\nUrlAssistUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UrlAssistUtils.kt\ncom/google/urlassistant/util/UrlAssistUtils\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,215:1\n1#2:216\n*E\n"})
public final class UrlAssistUtils {
    @NotNull
    public static final UrlAssistUtils INSTANCE = new UrlAssistUtils();

    private UrlAssistUtils() {
    }

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    @NotNull
    public static final XmlTag createDeepLinkIntentFilter(@NotNull Order order, @NotNull XmlTag activityTag, @NotNull UrlPrefix urlPrefix, @NotNull PathData pathData) {
        Object object;
        List list;
        List list2;
        List list3;
        XmlTag xmlTag;
        IntentFilterUtils intentFilterUtils;
        block3: {
            block2: {
                void it;
                Intrinsics.checkNotNullParameter((Object)order, (String)"order");
                Intrinsics.checkNotNullParameter((Object)activityTag, (String)"activityTag");
                Intrinsics.checkNotNullParameter((Object)urlPrefix, (String)"urlPrefix");
                Intrinsics.checkNotNullParameter((Object)pathData, (String)"pathData");
                intentFilterUtils = IntentFilterUtils.INSTANCE;
                xmlTag = activityTag;
                list3 = CollectionsKt.listOf((Object)pathData);
                list2 = CollectionsKt.listOf((Object)urlPrefix.getScheme());
                list = CollectionsKt.listOf((Object)new HostAndPort(urlPrefix.getHost(), urlPrefix.isPortSet() ? String.valueOf(urlPrefix.getPort()) : null));
                object = urlPrefix.getMimeType();
                if (object == null) break block2;
                String string = object;
                List list4 = list;
                List list5 = list2;
                List list6 = list3;
                XmlTag xmlTag2 = xmlTag;
                IntentFilterUtils intentFilterUtils2 = intentFilterUtils;
                boolean bl = false;
                List list7 = CollectionsKt.listOf((Object)it);
                intentFilterUtils = intentFilterUtils2;
                xmlTag = xmlTag2;
                list3 = list6;
                list2 = list5;
                list = list4;
                List list8 = list7;
                object = list8;
                if (list8 != null) break block3;
            }
            object = CollectionsKt.emptyList();
        }
        return intentFilterUtils.createAndInsertDeepLinkIntentFilter(xmlTag, list3, list2, list, (List<String>)object, order.getInteger());
    }

    @JvmStatic
    public static final void openActivityFile(@NotNull Project project, @NotNull ActivityData activityData) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)activityData, (String)"activityData");
        AndroidFacet androidFacet = AndroidFacet.getInstance((Module)activityData.getModule());
        if (androidFacet == null) {
            return;
        }
        AndroidFacet facet = androidFacet;
        Manifest manifest = Manifest.getMainManifest((AndroidFacet)facet);
        if (manifest == null) {
            return;
        }
        Manifest manifest2 = manifest;
        ReadAction.run(() -> UrlAssistUtils.openActivityFile$lambda$1(manifest2, activityData, project));
    }

    @JvmStatic
    public static final void openVirtualFile(@NotNull Project project, @Nullable VirtualFile virtualFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        if (virtualFile == null) {
            Messages.showMessageDialog((Project)project, (String)UrlAssistantBundle.message("check.url.mapping.open.fail", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
            return;
        }
        ApplicationManager.getApplication().invokeAndWait(() -> UrlAssistUtils.openVirtualFile$lambda$2(project, virtualFile), ModalityState.any());
    }

    @JvmStatic
    public static final boolean matchesHost(@NotNull String actualHost, @NotNull String hostRegex) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)actualHost, (String)"actualHost");
        Intrinsics.checkNotNullParameter((Object)hostRegex, (String)"hostRegex");
        if (StringsKt.contains$default((CharSequence)hostRegex, (CharSequence)"*", (boolean)false, (int)2, null) && StringsKt.indexOf$default((CharSequence)hostRegex, (char)'*', (int)0, (boolean)false, (int)6, null) != StringsKt.lastIndexOf$default((CharSequence)hostRegex, (char)'*', (int)0, (boolean)false, (int)6, null)) {
            bl = false;
        } else {
            CharSequence charSequence = actualHost;
            bl = new Regex(StringsKt.replace$default((String)StringsKt.replace$default((String)hostRegex, (String)".", (String)"\\.", (boolean)false, (int)4, null), (String)"*", (String)".+", (boolean)false, (int)4, null)).matches(charSequence);
        }
        return bl;
    }

    @JvmStatic
    @NotNull
    public static final ListenableFuture<String> getFirstValidUrl(@NotNull Module module, @NotNull Disposable disposableParent) {
        Intrinsics.checkNotNullParameter((Object)module, (String)"module");
        Intrinsics.checkNotNullParameter((Object)disposableParent, (String)"disposableParent");
        return ListenableFutureKt.asListenableFuture((Deferred)BuildersKt.async$default((CoroutineScope)CoroutineUtilsKt.AndroidCoroutineScope$default((Disposable)disposableParent, null, (int)2, null), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super String>, Object>(module, disposableParent, null){
            int label;
            final /* synthetic */ Module $module;
            final /* synthetic */ Disposable $disposableParent;
            {
                this.$module = $module;
                this.$disposableParent = $disposableParent;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            public final Object invokeSuspend(Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.label = 1;
                        v0 = DeepLinkUtils.INSTANCE.getDeeplinks(this.$module, null, this.$disposableParent, (Continuation<? super DeepLinks>)((Continuation)this));
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl13
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl13:
                        // 2 sources

                        return (deepLinks = (DeepLinks)v0).getDeepLinkList().isEmpty() == false ? ((DeepLinks.DeepLink)deepLinks.getDeepLinkList().get(0)).getUrl().toString() : "";
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super String> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null));
    }

    @JvmStatic
    public static final boolean isUrlValid(@NotNull String urlString) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (StringUtil.isEmpty((String)urlString)) {
            return false;
        }
        try {
            bl = HostSpecifier.isValid((String)new URL(urlString).getHost());
        }
        catch (MalformedURLException malformedURLException) {
            return false;
        }
        return bl;
    }

    @JvmStatic
    @Nullable
    public static final ActivityData findAssociatedActivity(@NotNull List<? extends DeepLinks.DeepLink> myDeepLinkList, @NotNull String urlString) throws MalformedURLException {
        Intrinsics.checkNotNullParameter(myDeepLinkList, (String)"myDeepLinkList");
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        if (!UrlAssistUtils.isUrlValid(urlString)) {
            throw new MalformedURLException();
        }
        URL rawUrl = new URL(urlString);
        for (DeepLinks.DeepLink deepLink : myDeepLinkList) {
            UrlPrefix urlPrefix;
            PathData pathData;
            Intrinsics.checkNotNullExpressionValue((Object)deepLink.getUrl(), (String)"getUrl(...)");
            Intrinsics.checkNotNullExpressionValue((Object)deepLink.getPath(), (String)"getPath(...)");
            PathType pathType = pathData.getPathType();
            Intrinsics.checkNotNullExpressionValue((Object)((Object)pathType), (String)"getPathType(...)");
            if (!INSTANCE.matchesUrl$url_assistant(rawUrl, urlPrefix, pathType, pathData.getPathValue())) continue;
            return deepLink.getActivityData();
        }
        return null;
    }

    public final boolean matchesUrl$url_assistant(@NotNull URL urlToMatch, @NotNull UrlPrefix linkPatternOrigin, @NotNull PathType linkPatternPathType, @Nullable String linkPatternPath) {
        Intrinsics.checkNotNullParameter((Object)urlToMatch, (String)"urlToMatch");
        Intrinsics.checkNotNullParameter((Object)linkPatternOrigin, (String)"linkPatternOrigin");
        Intrinsics.checkNotNullParameter((Object)((Object)linkPatternPathType), (String)"linkPatternPathType");
        if (Intrinsics.areEqual((Object)urlToMatch.getProtocol(), (Object)linkPatternOrigin.getScheme())) {
            String string = urlToMatch.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getHost(...)");
            String string2 = linkPatternOrigin.getHost();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getHost(...)");
            if (UrlAssistUtils.matchesHost(string, string2) && urlToMatch.getPort() == linkPatternOrigin.getPort()) {
                if (StringUtil.isEmpty((String)linkPatternPath)) {
                    return true;
                }
                String wantedPath = urlToMatch.getPath();
                if (StringUtil.isNotEmpty((String)wantedPath) && linkPatternPath != null) {
                    return switch (WhenMappings.$EnumSwitchMapping$0[linkPatternPathType.ordinal()]) {
                        case 1 -> Intrinsics.areEqual((Object)wantedPath, (Object)linkPatternPath);
                        case 2 -> {
                            Intrinsics.checkNotNull((Object)wantedPath);
                            yield StringsKt.startsWith$default((String)wantedPath, (String)linkPatternPath, (boolean)false, (int)2, null);
                        }
                        case 3 -> AndroidPatternMatcher.matchGlobPattern(linkPatternPath, wantedPath);
                        case 4 -> {
                            Intrinsics.checkNotNull((Object)wantedPath);
                            yield StringsKt.endsWith$default((String)wantedPath, (String)linkPatternPath, (boolean)false, (int)2, null);
                        }
                        case 5 -> AndroidPatternMatcher.matchAdvancedPattern(AndroidPatternMatcher.parseAndVerifyAdvancedPattern(linkPatternPath), wantedPath);
                        default -> false;
                    };
                }
            }
        }
        return false;
    }

    private static final void openActivityFile$lambda$1(Manifest $manifest, ActivityData $activityData, Project $project) {
        List activityList = $manifest.getApplication().getActivities();
        for (Activity activity : activityList) {
            if (!Intrinsics.areEqual((Object)$activityData.getActivityName(), (Object)activity.getActivityClass().getStringValue())) continue;
            PsiClass activityClass = (PsiClass)activity.getActivityClass().getValue();
            if (activityClass != null) {
                UrlAssistUtils.openVirtualFile($project, activityClass.getContainingFile().getVirtualFile());
                break;
            }
            Messages.showMessageDialog((Project)$project, (String)UrlAssistantBundle.message("check.url.mapping.activity.file.not.found", new Object[0]), (String)UrlAssistantBundle.message("dialog.error.title", new Object[0]), null);
            break;
        }
    }

    private static final void openVirtualFile$lambda$2(Project $project, VirtualFile $virtualFile) {
        FileEditorManager.getInstance((Project)$project).openFile($virtualFile, true);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[PathType.values().length];
            try {
                nArray[PathType.Path.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathPrefix.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathPattern.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathSuffix.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PathType.PathAdvancedPattern.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

