/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.ddmlib.IDevice;
import org.jetbrains.annotations.NotNull;

public class DeviceHelper {
    @NotNull
    public static RuntimeVersion getRuntime(@NotNull IDevice device) {
        String vm;
        int apiLevel = device.getVersion().getApiLevel();
        if (apiLevel < 19) {
            return RuntimeVersion.DALVIK;
        }
        if (apiLevel == 19 && (vm = device.getProperty("persist.sys.dalvik.vm.lib")) != null) {
            if (vm.equals("libdvm.so")) {
                return RuntimeVersion.DALVIK;
            }
            if (vm.equals("libart.so")) {
                return RuntimeVersion.ART;
            }
        }
        return RuntimeVersion.ART;
    }

    public static boolean isDebugLibArtSo(@NotNull IDevice device) {
        String vm = device.getProperty("persist.sys.dalvik.vm.lib2");
        if (vm == null) {
            vm = device.getProperty("persist.sys.dalvik.vm.lib");
        }
        return vm != null && vm.equals("libartd.so");
    }

    public static enum RuntimeVersion {
        DALVIK,
        ART;

    }
}

