/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk;

import com.android.sdklib.devices.Abi;
import com.android.tools.idea.util.StudioPathManager;
import com.android.tools.ndk.run.AndroidNativeAppDebugProcess;
import com.android.tools.ndk.run.NativeDebuggerAppContext;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.PathUtil;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ModulePathManager {
    private static final Map<Abi, Abi> ABI_MAPPINGS = Collections.singletonMap(Abi.ARMEABI_V7A, Abi.ARMEABI);

    @NotNull
    public static File getLldbCommonFile(@NotNull String relativePath) {
        if (StudioPathManager.isRunningFromSources()) {
            return Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts/tools/common/lldb", relativePath).toFile();
        }
        return new File(ModulePathManager.getShippedLldbDirectory(), relativePath);
    }

    private static File getShippedLldbDirectory() {
        return Paths.get(PathManager.getPreInstalledPluginsPath(), "android-ndk", "resources", "lldb").toFile();
    }

    private static File getDevLldbOsDirectory() {
        String os;
        if (SystemInfo.isLinux) {
            os = "linux-x86_64";
        } else if (SystemInfo.isMac) {
            os = SystemInfo.OS_ARCH.equals("aarch64") ? "darwin-arm64" : "darwin-x86_64";
        } else if (SystemInfo.isWindows) {
            os = "windows-x86_64";
        } else {
            throw new IllegalStateException("Unknown operating system");
        }
        return Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts/tools", os, "lldb").toFile();
    }

    @NotNull
    public static File getLldbHostDir() {
        if (StudioPathManager.isRunningFromSources()) {
            return ModulePathManager.getDevLldbOsDirectory();
        }
        return ModulePathManager.getShippedLldbDirectory();
    }

    @NotNull
    public static File getLldbHostFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbHostDir(), relativePath);
    }

    @NotNull
    public static File getLldbPythonHome() {
        if (StudioPathManager.isRunningFromSources()) {
            String pythonOsDir = SystemInfo.isLinux ? "linux-x86" : (SystemInfo.isWindows ? "windows-x86/x64" : "darwin-x86");
            return Paths.get(StudioPathManager.getSourcesRoot(), "prebuilts/python", pythonOsDir).toFile();
        }
        return ModulePathManager.getShippedLldbDirectory();
    }

    @NotNull
    public static File getLldbAndroidFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbCommonFile("android"), relativePath);
    }

    @NotNull
    public static File getLldbSharedFile(@NotNull String relativePath) {
        return new File(ModulePathManager.getLldbCommonFile("shared"), relativePath);
    }

    @Nullable
    public static FileWithAbi findLLDBServer(@NotNull NativeDebuggerAppContext appContext, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        if (abis.isEmpty()) {
            return null;
        }
        Abi mainAbi = abis.get(0);
        FileWithAbi firstFoundServerFile = null;
        for (Abi abi : abis) {
            File serverFile;
            if (!ModulePathManager.isSameCpuFamily(mainAbi, abi) || (serverFile = ModulePathManager.getServerFileByAbi(abi)) == null) continue;
            if (firstFoundServerFile == null) {
                firstFoundServerFile = new FileWithAbi(serverFile, abi);
            }
            if (AndroidNativeAppDebugProcess.getSymbolsDir(appContext, debuggerState, Collections.singletonList(abi)).isEmpty()) continue;
            return new FileWithAbi(serverFile, abi);
        }
        return firstFoundServerFile;
    }

    @NotNull
    public static Abi findTargetAbi(@NotNull NativeDebuggerAppContext appContext, @NotNull NativeAndroidDebuggerState debuggerState, @NotNull List<Abi> abis) {
        FileWithAbi lldbServerAndAbi = ModulePathManager.findLLDBServer(appContext, debuggerState, abis);
        if (lldbServerAndAbi != null) {
            return lldbServerAndAbi.getAbi();
        }
        return abis.get(0);
    }

    private static String getCpuFamily(@NotNull Abi abi) {
        switch (abi) {
            case X86: 
            case X86_64: {
                return "x86";
            }
            case ARMEABI: 
            case ARMEABI_V7A: 
            case ARM64_V8A: {
                return "arm";
            }
        }
        return abi.getDisplayName();
    }

    @VisibleForTesting
    static boolean isSameCpuFamily(@NotNull Abi abi1, @NotNull Abi abi2) {
        return ModulePathManager.getCpuFamily(abi1).equals(ModulePathManager.getCpuFamily(abi2));
    }

    @Nullable
    private static File getServerFileByAbi(@NotNull Abi abi) {
        File lldbServerFile = ModulePathManager.getAndroidLldbBinFile(abi);
        if (lldbServerFile.exists()) {
            return lldbServerFile;
        }
        Abi mappedAbi = ABI_MAPPINGS.get(abi);
        if (mappedAbi != null && (lldbServerFile = ModulePathManager.getAndroidLldbBinFile(mappedAbi)).exists()) {
            return lldbServerFile;
        }
        return null;
    }

    @NotNull
    private static File getAndroidLldbBinFile(Abi abi) {
        return ModulePathManager.getLldbAndroidFile(new File(abi.toString(), "lldb-server").getPath());
    }

    @NotNull
    public static File getRepoLLDBPrettyPrinterScriptsFolder() {
        return ModulePathManager.getLldbSharedFile("jobject_printers");
    }

    @NotNull
    public static List<String> getCidrLldbHelpers() {
        ArrayList<String> result = new ArrayList<String>();
        Path homePath = Paths.get(PathManager.getHomePath(), new String[0]);
        result.add(PathUtil.toSystemIndependentName((String)homePath.resolve("bin/lldb/helpers").toString()));
        result.add(PathUtil.toSystemIndependentName((String)homePath.resolve("bin/helpers").toString()));
        return result;
    }

    public static class FileWithAbi {
        @NotNull
        private final File myFile;
        @NotNull
        private final Abi myAbi;

        public FileWithAbi(@NotNull File file, @NotNull Abi abi) {
            this.myFile = file;
            this.myAbi = abi;
        }

        @NotNull
        public File getFile() {
            return this.myFile;
        }

        @NotNull
        public Abi getAbi() {
            return this.myAbi;
        }
    }
}

