/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.InspectionUtilsKt;
import com.android.tools.ndk.jni.inspections.JniFunctionSignatureInspection;
import com.android.tools.ndk.jni.inspections.JniFunctionSignatureInspectionKt;
import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.inspections.JniLocalQuickFix;
import com.android.tools.ndk.jni.model.JniNativeMethodId;
import com.android.tools.ndk.jni.model.JvmMethodInfo;
import com.android.tools.ndk.jni.model.MethodInfo;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.model.NativeMethodInfo;
import com.android.tools.ndk.jni.model.SimpleParameterDeclaration;
import com.android.tools.ndk.jni.service.JniMethodResolver;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.util.text.OrdinalFormat;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J.\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f2\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectMethodSignature", "", "element", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "expectedParameterDeclarations", "", "Lcom/android/tools/ndk/jni/model/SimpleParameterDeclaration;", "returnType", "", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniFunctionSignatureInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniFunctionSignatureInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspection\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,270:1\n1#2:271\n1863#3,2:272\n*S KotlinDebug\n*F\n+ 1 JniFunctionSignatureInspection.kt\ncom/android/tools/ndk/jni/inspections/JniFunctionSignatureInspection\n*L\n185#1:272,2\n*E\n"})
public final class JniFunctionSignatureInspection
extends JniInspectionTool {
    public JniFunctionSignatureInspection() {
        super(JniInspectionEvent.JniInspectionType.PARAMETERS_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        return new PsiElementVisitor(this, holder, isOnTheFly){
            final /* synthetic */ JniFunctionSignatureInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ boolean $isOnTheFly;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
                this.$isOnTheFly = $isOnTheFly;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * WARNING - void declaration
             */
            public void visitElement(PsiElement element) {
                void inspectionType$iv$iv;
                void $this$reportJniPerf$iv$iv;
                void this_$iv;
                void psiElement$iv;
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                MethodInfo methodInfo = MethodInfo.Companion.fromPsiElement(element, false);
                NativeMethodInfo nativeMethodInfo = methodInfo instanceof NativeMethodInfo ? (NativeMethodInfo)methodInfo : null;
                if (nativeMethodInfo == null) {
                    return;
                }
                NativeMethodInfo nativeMethodInfo2 = nativeMethodInfo;
                JniInspectionTool jniInspectionTool = this.this$0;
                methodInfo = element;
                JniFunctionSignatureInspection jniFunctionSignatureInspection = this.this$0;
                ProblemsHolder problemsHolder = this.$holder;
                boolean bl = this.$isOnTheFly;
                boolean $i$f$reportPerf$android_ndk = false;
                Project project = psiElement$iv.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
                Project project2 = project;
                JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
                int n = 100;
                boolean $i$f$reportJniPerf = false;
                JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
                Instant startTime$iv$iv = Instant.now();
                try {
                    JniLocalQuickFix[] jniLocalQuickFixArray;
                    PsiElement psiElement;
                    Collection collection;
                    void $this$mapTo$iv$iv;
                    void $this$map$iv;
                    Object object;
                    List<JvmMethodInfo> manuallyRegistered;
                    OCFunctionDeclaration ocFunctionDeclaration;
                    block23: {
                        block22: {
                            JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
                            boolean bl2 = false;
                            boolean bl3 = false;
                            ocFunctionDeclaration = nativeMethodInfo2.getPsiElement();
                            Project project3 = ocFunctionDeclaration.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"getProject(...)");
                            manuallyRegistered = JniMethodResolver.Companion.getInstance(project3).resolveManuallyRegistered(nativeMethodInfo2);
                            NativeMethodId nativeMethodId = nativeMethodInfo2.getNativeMethodId();
                            object = nativeMethodId instanceof JniNativeMethodId ? (JniNativeMethodId)nativeMethodId : null;
                            if (object == null) break block22;
                            JniNativeMethodId it = object;
                            boolean bl4 = false;
                            Project project4 = ocFunctionDeclaration.getProject();
                            Intrinsics.checkNotNullExpressionValue((Object)project4, (String)"getProject(...)");
                            List<JvmMethodInfo> list = JniMethodResolver.Companion.getInstance(project4).resolveImplicitlyLinkedNativeMethod(it);
                            object = list;
                            if (list != null) break block23;
                        }
                        object = CollectionsKt.emptyList();
                    }
                    List<JvmMethodInfo> implicitlyLinked = object;
                    List matchedMethodInfos = CollectionsKt.distinct((Iterable)CollectionsKt.plus((Collection)manuallyRegistered, (Iterable)implicitlyLinked));
                    Iterable iterable = matchedMethodInfos;
                    boolean $i$f$map = false;
                    void bl4 = $this$map$iv;
                    Collection destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                    boolean $i$f$mapTo2 = false;
                    for (T item$iv$iv : $this$mapTo$iv$iv) {
                        void it;
                        JvmMethodInfo jvmMethodInfo = (JvmMethodInfo)item$iv$iv;
                        collection = destination$iv$iv;
                        boolean bl5 = false;
                        collection.add(CollectionsKt.plus((Collection)it.generateNativeParameterDeclarations(), (Object)new SimpleParameterDeclaration(it.getReturnType().toJniType(), "return_value")));
                    }
                    List expectedParameterDeclarations = JniFunctionSignatureInspectionKt.access$unify((List)destination$iv$iv);
                    if (ocFunctionDeclaration.getNameIdentifier() == null) {
                        return;
                    }
                    PsiElement nameIdentifier = psiElement;
                    if (manuallyRegistered.isEmpty()) {
                        void $this$toTypedArray$iv;
                        void $this$mapTo$iv$iv2;
                        Iterable $this$map$iv2 = implicitlyLinked;
                        boolean $i$f$map2 = false;
                        Iterable $i$f$mapTo2 = $this$map$iv2;
                        Collection destination$iv$iv2 = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
                        boolean $i$f$mapTo3 = false;
                        for (E item$iv$iv : $this$mapTo$iv$iv2) {
                            void jvmMethodInfo;
                            JvmMethodInfo jvmMethodInfo2 = (JvmMethodInfo)item$iv$iv;
                            collection = destination$iv$iv2;
                            boolean bl6 = false;
                            collection.add(jniFunctionSignatureInspection.quickFix("Specialize JNI function", "Specialize to " + jvmMethodInfo.getDescription(), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> buildVisitor.2.visitElement$lambda$5$lambda$4$lambda$3((JvmMethodInfo)jvmMethodInfo, arg_0, arg_1))));
                        }
                        $this$map$iv2 = (List)destination$iv$iv2;
                        boolean $i$f$toTypedArray = false;
                        void thisCollection$iv = $this$toTypedArray$iv;
                        jniLocalQuickFixArray = thisCollection$iv.toArray(new JniLocalQuickFix[0]);
                    } else {
                        jniLocalQuickFixArray = new JniLocalQuickFix[]{};
                    }
                    JniLocalQuickFix[] quickFixes = jniLocalQuickFixArray;
                    switch (expectedParameterDeclarations.size()) {
                        case 0: {
                            return;
                        }
                        case 1: {
                            List expectedParameterDeclaration = (List)CollectionsKt.single((List)expectedParameterDeclarations);
                            JniFunctionSignatureInspection.access$inspectMethodSignature(jniFunctionSignatureInspection, ocFunctionDeclaration, problemsHolder, CollectionsKt.dropLast((List)expectedParameterDeclaration, (int)1), ((SimpleParameterDeclaration)CollectionsKt.last((List)expectedParameterDeclaration)).getType());
                            if (matchedMethodInfos.size() > 1 && bl) {
                                InspectionUtilsKt.registerOcProblem(problemsHolder, nameIdentifier, "Multiple methods are linked to this JNI method.", ProblemHighlightType.INFORMATION, Arrays.copyOf(quickFixes, quickFixes.length));
                            }
                            break;
                        }
                        default: {
                            InspectionUtilsKt.registerOcProblem(problemsHolder, nameIdentifier, "Multiple incompatible methods are linked to this JNI method.", ProblemHighlightType.GENERIC_ERROR, Arrays.copyOf(quickFixes, quickFixes.length));
                        }
                    }
                    Unit unit = Unit.INSTANCE;
                }
                finally {
                    void inverseSampleRate$iv$iv;
                    if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                        Instant bl2 = Instant.now();
                        JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl2).toMillis())));
                    }
                }
            }

            private static final boolean visitElement$lambda$5$lambda$4$lambda$3$lambda$2(ProblemDescriptor $descriptor, JvmMethodInfo $jvmMethodInfo) {
                String[] stringArray = new String[]{$jvmMethodInfo.toJniNativeMethodId(false).getFunctionName()};
                return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
            }

            private static final boolean visitElement$lambda$5$lambda$4$lambda$3(JvmMethodInfo $jvmMethodInfo, Project project, ProblemDescriptor descriptor) {
                Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
                Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
                return (Boolean)ActionsKt.runWriteAction(() -> buildVisitor.2.visitElement$lambda$5$lambda$4$lambda$3$lambda$2(descriptor, $jvmMethodInfo));
            }
        };
    }

    private final void inspectMethodSignature(OCFunctionDeclaration element, ProblemsHolder holder, List<SimpleParameterDeclaration> expectedParameterDeclarations, String returnType) {
        OCParameterList parameterList;
        Object object;
        boolean isCpp = OCLanguageKindCalculator.calculateLanguageKindFast((PsiFile)element.getContainingFile()).isCpp();
        OCTypeElement oCTypeElement = element.getReturnTypeElement();
        PsiElement returnTypeElement = oCTypeElement != null ? oCTypeElement.getOriginalElement() : null;
        OCType oCType = element.getResolvedType();
        Intrinsics.checkNotNullExpressionValue((Object)oCType, (String)"getResolvedType(...)");
        PsiFile psiFile = element.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"getContainingFile(...)");
        if (!JniFunctionSignatureInspectionKt.isCompatibleWithJniType(oCType, psiFile, returnType, isCpp) && returnTypeElement != null) {
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix return type of JNI function", "Fix return type of " + element.getName() + ".", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$1(returnType, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, returnTypeElement, "Incorrect return type " + element.getReturnType().getName() + ", which should have been " + returnType + ".", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
        if ((object = (parameterList = element.getParameterList())) == null || (object = object.getParameterDeclarations()) == null) {
            return;
        }
        Object actualParameterDeclarations = object;
        int minLength = Math.min(expectedParameterDeclarations.size(), actualParameterDeclarations.size());
        for (int i = 0; i < minLength; ++i) {
            Object object2;
            boolean bl;
            OCParameterDeclaration actual = (OCParameterDeclaration)actualParameterDeclarations.get(i);
            SimpleParameterDeclaration expected = expectedParameterDeclarations.get(i);
            OCDeclarator oCDeclarator = actual.getDeclarator();
            if (oCDeclarator != null && (oCDeclarator = oCDeclarator.getResolvedType()) != null) {
                PsiFile psiFile2 = element.getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile2, (String)"getContainingFile(...)");
                bl = JniFunctionSignatureInspectionKt.isCompatibleWithJniType((OCType)oCDeclarator, psiFile2, expected.getType(), isCpp);
            } else {
                bl = false;
            }
            if (bl) continue;
            Object object3 = actual.getDeclarator();
            if (object3 != null && (object3 = object3.getName()) != null) {
                Object object4;
                Object it = object4 = object3;
                boolean bl2 = false;
                object2 = !Intrinsics.areEqual((Object)it, (Object)"<unnamed>") ? object4 : null;
            } else {
                object2 = null;
            }
            Object parameterName = object2;
            String parameterDescription = parameterName == null ? "the " + OrdinalFormat.formatEnglish((long)((long)i + 1L)) + " parameter" : "parameter '" + parameterName + "'";
            Intrinsics.checkNotNull((Object)actual);
            JniLocalQuickFix[] jniLocalQuickFixArray = new JniLocalQuickFix[]{this.quickFix("Fix parameter type of JNI function", "Fix type of " + parameterDescription, (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$4(expected, (String)parameterName, arg_0, arg_1)))};
            InspectionUtilsKt.registerOcProblem(holder, (PsiElement)actual, "Incorrect type for " + parameterDescription + ", which should have type '" + expected.getType() + "'.", ProblemHighlightType.GENERIC_ERROR, jniLocalQuickFixArray);
        }
        if (actualParameterDeclarations.size() < expectedParameterDeclarations.size()) {
            List<SimpleParameterDeclaration> missingParameterDeclarations = expectedParameterDeclarations.subList(minLength, expectedParameterDeclarations.size());
            PsiElement rightParenthsis = parameterList.getLastChild();
            String missingParameters = CollectionsKt.joinToString$default((Iterable)missingParameterDeclarations, null, null, null, (int)0, null, JniFunctionSignatureInspection::inspectMethodSignature$lambda$5, (int)31, null);
            Intrinsics.checkNotNull((Object)rightParenthsis);
            var13_15 = new JniLocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Insert missing parameters", null, (arg_0, arg_1) -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$7((List)actualParameterDeclarations, missingParameterDeclarations, arg_0, arg_1), 2, null)};
            InspectionUtilsKt.registerOcProblem(holder, rightParenthsis, "Missing parameter" + (missingParameterDeclarations.size() == 1 ? "" : "s") + ": " + missingParameters + ".", ProblemHighlightType.GENERIC_ERROR, var13_15);
        } else if (actualParameterDeclarations.size() > expectedParameterDeclarations.size()) {
            List unexpectedParameterDeclarations = actualParameterDeclarations.subList(minLength, actualParameterDeclarations.size());
            for (OCParameterDeclaration unexpectedParameterDeclaration : unexpectedParameterDeclarations) {
                Intrinsics.checkNotNull((Object)unexpectedParameterDeclaration);
                var13_15 = new JniLocalQuickFix[]{this.quickFix("Remove extra parameters", "Remove extra parameter" + (unexpectedParameterDeclarations.size() == 1 ? "" : "s"), (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$10(unexpectedParameterDeclarations, arg_0, arg_1)))};
                InspectionUtilsKt.registerOcProblem(holder, (PsiElement)unexpectedParameterDeclaration, "Unexpected parameter declaration.", ProblemHighlightType.GENERIC_ERROR, var13_15);
            }
        }
    }

    private static final boolean inspectMethodSignature$lambda$1$lambda$0(ProblemDescriptor $descriptor, String $returnType) {
        String[] stringArray = new String[]{$returnType};
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    private static final boolean inspectMethodSignature$lambda$1(String $returnType, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$1$lambda$0(descriptor, $returnType));
    }

    private static final boolean inspectMethodSignature$lambda$4$lambda$3(ProblemDescriptor $descriptor, SimpleParameterDeclaration $expected, String $parameterName) {
        String[] stringArray = new String[1];
        String string = $parameterName;
        if (string == null) {
            string = $expected.getName();
        }
        stringArray[0] = SimpleParameterDeclaration.copy$default($expected, null, string, 1, null).toString();
        return InspectionUtilsKt.replaceAtHighlighted($descriptor, stringArray);
    }

    private static final boolean inspectMethodSignature$lambda$4(SimpleParameterDeclaration $expected, String $parameterName, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$4$lambda$3(descriptor, $expected, $parameterName));
    }

    private static final CharSequence inspectMethodSignature$lambda$5(SimpleParameterDeclaration it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "'" + it + "'";
    }

    private static final boolean inspectMethodSignature$lambda$7$lambda$6(ProblemDescriptor $descriptor, List $actualParameterDeclarations, List $missingParameterDeclarations) {
        String[] stringArray = new String[]{($actualParameterDeclarations.isEmpty() ? "" : ", ") + CollectionsKt.joinToString$default((Iterable)$missingParameterDeclarations, null, null, null, (int)0, null, null, (int)63, null)};
        return InspectionUtilsKt.insertAtHighlighted($descriptor, stringArray);
    }

    private static final boolean inspectMethodSignature$lambda$7(List $actualParameterDeclarations, List $missingParameterDeclarations, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        return (Boolean)ActionsKt.runWriteAction(() -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$7$lambda$6(descriptor, $actualParameterDeclarations, $missingParameterDeclarations));
    }

    private static final void inspectMethodSignature$lambda$10$lambda$9(List $unexpectedParameterDeclarations) {
        Iterable $this$forEach$iv = $unexpectedParameterDeclarations;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            OCParameterDeclaration it = (OCParameterDeclaration)element$iv;
            boolean bl = false;
            OCChangeUtil.delete((PsiElement)((PsiElement)it));
        }
    }

    private static final boolean inspectMethodSignature$lambda$10(List $unexpectedParameterDeclarations, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ApplicationManager.getApplication().runWriteAction(() -> JniFunctionSignatureInspection.inspectMethodSignature$lambda$10$lambda$9($unexpectedParameterDeclarations));
        return true;
    }

    public static final /* synthetic */ void access$inspectMethodSignature(JniFunctionSignatureInspection $this, OCFunctionDeclaration element, ProblemsHolder holder, List expectedParameterDeclarations, String returnType) {
        $this.inspectMethodSignature(element, holder, expectedParameterDeclarations, returnType);
    }
}

