/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.inspections;

import com.android.tools.ndk.jni.inspections.JniInspectionTool;
import com.android.tools.ndk.jni.utils.JniUsageEventReporter;
import com.android.tools.ndk.jni.utils.JniUtilsKt;
import com.google.wireless.android.sdk.stats.JniInspectionEvent;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.application.ActionsKt;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.jetbrains.cidr.lang.LanguageUtils;
import com.jetbrains.cidr.lang.psi.OCDeclarator;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCParameterList;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.refactoring.util.OCChangeUtil;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u00a8\u0006\u0010"}, d2={"Lcom/android/tools/ndk/jni/inspections/JniOnloadInspection;", "Lcom/android/tools/ndk/jni/inspections/JniInspectionTool;", "<init>", "()V", "buildVisitor", "Lcom/intellij/psi/PsiElementVisitor;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "isOnTheFly", "", "inspectDeclaration", "", "declarator", "Lcom/jetbrains/cidr/lang/psi/OCFunctionDeclaration;", "returnTypeName", "", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nJniOnloadInspection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 JniOnloadInspection.kt\ncom/android/tools/ndk/jni/inspections/JniOnloadInspection\n+ 2 JniInspectionTool.kt\ncom/android/tools/ndk/jni/inspections/JniInspectionTool\n+ 3 JniUtils.kt\ncom/android/tools/ndk/jni/utils/JniUtilsKt\n*L\n1#1,143:1\n62#2,4:144\n66#2:152\n67#2:162\n516#3,4:148\n522#3,9:153\n*S KotlinDebug\n*F\n+ 1 JniOnloadInspection.kt\ncom/android/tools/ndk/jni/inspections/JniOnloadInspection\n*L\n54#1:144,4\n54#1:152\n54#1:162\n54#1:148,4\n54#1:153,9\n*E\n"})
public final class JniOnloadInspection
extends JniInspectionTool {
    public JniOnloadInspection() {
        super(JniInspectionEvent.JniInspectionType.ONLOAD_INSPECTION_EVENT);
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        LanguageUtils languageUtils = LanguageUtils.Companion.getInstance();
        Project project = holder.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        if (languageUtils.isCppSupportDisabled(project)) {
            return new PsiElementVisitor(){};
        }
        return new PsiElementVisitor(this, holder){
            final /* synthetic */ JniOnloadInspection this$0;
            final /* synthetic */ ProblemsHolder $holder;
            {
                this.this$0 = $receiver;
                this.$holder = $holder;
            }

            public void visitElement(PsiElement element) {
                block11: {
                    Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                    OCFunctionDeclaration oCFunctionDeclaration = element instanceof OCFunctionDeclaration ? (OCFunctionDeclaration)element : null;
                    if (oCFunctionDeclaration == null) {
                        return;
                    }
                    OCFunctionDeclaration declarator = oCFunctionDeclaration;
                    String string = declarator.getName();
                    if (string == null) break block11;
                    int n = -1;
                    switch (string.hashCode()) {
                        case -1749321345: {
                            if (string.equals("JNI_OnLoad")) {
                                n = 1;
                            }
                            break;
                        }
                        case -1508519592: {
                            if (string.equals("JNI_OnUnload")) {
                                n = 2;
                            }
                            break;
                        }
                    }
                    switch (n) {
                        case 1: {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "jint");
                            break;
                        }
                        case 2: {
                            JniOnloadInspection.access$inspectDeclaration(this.this$0, declarator, this.$holder, "void");
                        }
                    }
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void inspectDeclaration(OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        void inspectionType$iv$iv;
        void $this$reportJniPerf$iv$iv;
        void this_$iv;
        JniInspectionTool jniInspectionTool = this;
        PsiElement psiElement$iv = (PsiElement)declarator;
        boolean $i$f$reportPerf$android_ndk = false;
        Project project = psiElement$iv.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        Project project2 = project;
        JniInspectionEvent.JniInspectionType jniInspectionType = JniInspectionTool.access$getInspectionType$p((JniInspectionTool)this_$iv);
        int n = 100;
        boolean $i$f$reportJniPerf = false;
        JniUsageEventReporter reporter$iv$iv = new JniUsageEventReporter((Project)$this$reportJniPerf$iv$iv, (JniInspectionEvent.JniInspectionType)inspectionType$iv$iv);
        Instant startTime$iv$iv = Instant.now();
        try {
            Integer n2;
            LocalQuickFix[] localQuickFixArray;
            JniUsageEventReporter $this$reportPerf_u24lambda_u240$iv = reporter$iv$iv;
            boolean bl = false;
            boolean bl2 = false;
            if (!declarator.getReturnType().equalsAfterResolving(returnTypeName, OCResolveContext.forPsi((PsiElement)((PsiElement)declarator)))) {
                OCTypeElement oCTypeElement = declarator.getReturnTypeElement();
                OCElement elementToShow = oCTypeElement != null ? (OCElement)oCTypeElement : (OCElement)declarator;
                localQuickFixArray = new LocalQuickFix[]{this.quickFix("Fix type", "Change return type to '" + returnTypeName + "'", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$1(declarator, returnTypeName, arg_0, arg_1)))};
                holder.registerProblem((PsiElement)elementToShow, "Wrong type", ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            }
            List list = declarator.getParameters();
            Integer n3 = n2 = list != null ? Integer.valueOf(list.size()) : null;
            if (n3 != null && n3 == 0) {
                localQuickFixArray = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Add parameters", null, (arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$3(declarator, arg_0, arg_1), 2, null)};
                holder.registerProblem((PsiElement)declarator, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, localQuickFixArray);
            } else {
                Integer n4 = n2;
                int n5 = 1;
                if (n4 != null && n4 == n5) {
                    OCParameterList oCParameterList;
                    if (declarator.getParameterList() == null) {
                        return;
                    }
                    OCParameterList parameterList = oCParameterList;
                    LocalQuickFix[] localQuickFixArray2 = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Add parameters", null, (arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$5(parameterList, declarator, arg_0, arg_1), 2, null)};
                    holder.registerProblem((PsiElement)parameterList, "Not enough parameters", ProblemHighlightType.WEAK_WARNING, localQuickFixArray2);
                } else {
                    Integer n6 = n2;
                    int parameterList = 2;
                    if (n6 != null && n6 == parameterList) {
                        List list2;
                        LocalQuickFix[] localQuickFixArray3;
                        List list3 = declarator.getParameters();
                        boolean bl3 = list3 != null && (list3 = (OCDeclarator)list3.get(0)) != null && (list3 = list3.getType()) != null ? !list3.equalsAfterResolving("JavaVM *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator))) : false;
                        if (bl3) {
                            List list4 = declarator.getParameters();
                            if (list4 == null || (list4 = (OCDeclarator)list4.get(0)) == null) {
                                return;
                            }
                            List typeNameElement = list4;
                            localQuickFixArray3 = new LocalQuickFix[]{this.quickFix("Change type", "Change type to JavaVM *", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$7((OCDeclarator)typeNameElement, arg_0, arg_1)))};
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, localQuickFixArray3);
                        }
                        boolean bl4 = (list2 = declarator.getParameters()) != null && (list2 = (OCDeclarator)list2.get(1)) != null && (list2 = list2.getType()) != null ? !list2.equalsAfterResolving("void *", OCResolveContext.forPsi((PsiElement)((PsiElement)declarator))) : false;
                        if (bl4) {
                            List list5 = declarator.getParameters();
                            if (list5 == null || (list5 = (OCDeclarator)list5.get(1)) == null) {
                                return;
                            }
                            List typeNameElement = list5;
                            localQuickFixArray3 = new LocalQuickFix[]{this.quickFix("Change type", "Change type to void *", (Function2<? super Project, ? super ProblemDescriptor, Boolean>)((Function2)(arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$9((OCDeclarator)typeNameElement, arg_0, arg_1)))};
                            holder.registerProblem((PsiElement)typeNameElement, "Wrong type", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, localQuickFixArray3);
                        }
                    } else if (n2 != null) {
                        OCParameterList oCParameterList;
                        Object parameter2Name;
                        Object object;
                        Object parameter1Name;
                        Object object2 = declarator.getParameters();
                        if (object2 == null || (object2 = (OCDeclarator)object2.get(0)) == null || (object2 = object2.getName()) == null) {
                            object2 = parameter1Name = "vm";
                        }
                        if ((object = declarator.getParameters()) == null || (object = (OCDeclarator)object.get(1)) == null || (object = object.getName()) == null) {
                            object = parameter2Name = "unused";
                        }
                        if (declarator.getParameterList() == null) {
                            return;
                        }
                        OCParameterList parameterList2 = oCParameterList;
                        LocalQuickFix[] localQuickFixArray4 = new LocalQuickFix[]{JniInspectionTool.quickFix$default(this, "Reduce parameter list length", null, (arg_0, arg_1) -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$11(parameterList2, declarator, (String)parameter1Name, (String)parameter2Name, arg_0, arg_1), 2, null)};
                        holder.registerProblem(parameterList2.getNavigationElement(), "Too many parameters", ProblemHighlightType.LIKE_UNKNOWN_SYMBOL, localQuickFixArray4);
                    }
                }
            }
            Unit unit = Unit.INSTANCE;
        }
        finally {
            void inverseSampleRate$iv$iv;
            if (JniUtilsKt.access$getRandom$p().nextInt((int)inverseSampleRate$iv$iv) == 0) {
                Instant bl = Instant.now();
                JniUtilsKt.access$sendJniEvent((Project)$this$reportJniPerf$iv$iv, JniInspectionEvent.newBuilder().setType((JniInspectionEvent.JniInspectionType)inspectionType$iv$iv).setEventCategory(JniInspectionEvent.EventCategory.PERFORMANCE_EVENT).setPerformanceEvent(JniInspectionEvent.PerformanceEvent.newBuilder().setDelayMs((int)Duration.between(startTime$iv$iv, bl).toMillis())));
            }
        }
    }

    private static final Unit inspectDeclaration$lambda$12$lambda$1$lambda$0(OCFunctionDeclaration $declarator, Project $project, String $returnTypeName) {
        OCTypeElement oCTypeElement = $declarator.getReturnTypeElement();
        if (oCTypeElement == null) {
            return Unit.INSTANCE;
        }
        OCTypeElement elementToChange = oCTypeElement;
        OCChangeUtil.changeText((Project)$project, (PsiFile)$declarator.getContainingFile(), (int)elementToChange.getTextOffset(), (int)elementToChange.getTextLength(), (String)$returnTypeName, (boolean)true);
        return Unit.INSTANCE;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$1(OCFunctionDeclaration $declarator, String $returnTypeName, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$1$lambda$0($declarator, project, $returnTypeName));
        return true;
    }

    private static final Unit inspectDeclaration$lambda$12$lambda$3$lambda$2(OCFunctionDeclaration $declarator, Project $project) {
        OCParameterList oCParameterList = $declarator.getParameterList();
        if (oCParameterList == null) {
            return Unit.INSTANCE;
        }
        int textOffset = oCParameterList.getTextOffset();
        OCParameterList oCParameterList2 = $declarator.getParameterList();
        if (oCParameterList2 == null) {
            return Unit.INSTANCE;
        }
        int textLength = oCParameterList2.getTextLength();
        OCChangeUtil.changeText((Project)$project, (PsiFile)$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)"(JavaVM* vm, void* unused)", (boolean)true);
        return Unit.INSTANCE;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$3(OCFunctionDeclaration $declarator, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$3$lambda$2($declarator, project));
        return true;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$5$lambda$4(OCParameterList $parameterList, OCFunctionDeclaration $declarator, Project $project) {
        int textOffset = $parameterList.getTextOffset();
        int textLength = $parameterList.getTextLength();
        Object object = $declarator.getParameters();
        if (object == null || (object = (OCDeclarator)object.get(0)) == null || (object = object.getName()) == null) {
            object = "vm";
        }
        Object parameterName = object;
        return OCChangeUtil.changeText((Project)$project, (PsiFile)$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM * " + (String)parameterName + ", void* unused)"), (boolean)true);
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$5(OCParameterList $parameterList, OCFunctionDeclaration $declarator, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$5$lambda$4($parameterList, $declarator, project));
        return true;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$7$lambda$6(OCDeclarator $typeNameElement, Project $project) {
        String string = $typeNameElement.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String varName = string;
        return OCChangeUtil.changeText((Project)$project, (PsiFile)$typeNameElement.getContainingFile(), (int)$typeNameElement.getParent().getTextOffset(), (int)$typeNameElement.getParent().getTextLength(), (String)("JavaVM *" + varName), (boolean)true);
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$7(OCDeclarator $typeNameElement, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$7$lambda$6($typeNameElement, project));
        return true;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$9$lambda$8(OCDeclarator $typeNameElement, Project $project) {
        String string = $typeNameElement.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        String varName = string;
        return OCChangeUtil.changeText((Project)$project, (PsiFile)$typeNameElement.getContainingFile(), (int)$typeNameElement.getParent().getTextOffset(), (int)$typeNameElement.getParent().getTextLength(), (String)("void *" + varName), (boolean)true);
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$9(OCDeclarator $typeNameElement, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$9$lambda$8($typeNameElement, project));
        return true;
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$11$lambda$10(OCParameterList $parameterList, Project $project, OCFunctionDeclaration $declarator, String $parameter1Name, String $parameter2Name) {
        int textOffset = $parameterList.getTextOffset();
        int textLength = $parameterList.getTextLength();
        return OCChangeUtil.changeText((Project)$project, (PsiFile)$declarator.getContainingFile(), (int)textOffset, (int)textLength, (String)("(JavaVM* " + $parameter1Name + ", void *" + $parameter2Name + ")"), (boolean)true);
    }

    private static final boolean inspectDeclaration$lambda$12$lambda$11(OCParameterList $parameterList, OCFunctionDeclaration $declarator, String $parameter1Name, String $parameter2Name, Project project, ProblemDescriptor descriptor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)descriptor, (String)"descriptor");
        ActionsKt.runWriteAction(() -> JniOnloadInspection.inspectDeclaration$lambda$12$lambda$11$lambda$10($parameterList, project, $declarator, $parameter1Name, $parameter2Name));
        return true;
    }

    public static final /* synthetic */ void access$inspectDeclaration(JniOnloadInspection $this, OCFunctionDeclaration declarator, ProblemsHolder holder, String returnTypeName) {
        $this.inspectDeclaration(declarator, holder, returnTypeName);
    }
}

