/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.jni.model;

import com.android.tools.ndk.jni.model.FullyQualifiedClassName;
import com.android.tools.ndk.jni.model.JvmType;
import com.android.tools.ndk.jni.model.JvmTypeKt;
import com.android.tools.ndk.jni.model.NativeMethodId;
import com.android.tools.ndk.jni.utils.JniMangleUtilsKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB'\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\nB+\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u0007\u00a2\u0006\u0004\b\t\u0010\u000bJ\b\u0010\u0014\u001a\u00020\u0005H\u0016J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00c6\u0003J\u0011\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0003J/\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\u0010\b\u0002\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007H\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0019\u0010\u0006\u001a\n\u0012\u0004\u0012\u00020\b\u0018\u00010\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u000f\u00a8\u0006 "}, d2={"Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "Lcom/android/tools/ndk/jni/model/NativeMethodId;", "className", "Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "methodName", "", "argTypes", "", "Lcom/android/tools/ndk/jni/model/JvmType;", "<init>", "(Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;Ljava/lang/String;Ljava/util/List;)V", "(Ljava/lang/String;Ljava/lang/String;Ljava/util/List;)V", "getClassName", "()Lcom/android/tools/ndk/jni/model/FullyQualifiedClassName;", "getMethodName", "()Ljava/lang/String;", "getArgTypes", "()Ljava/util/List;", "functionName", "getFunctionName", "toString", "component1", "component2", "component3", "copy", "equals", "", "other", "", "hashCode", "", "Companion", "android-ndk"})
@SourceDebugExtension(value={"SMAP\nNativeMethodId.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NativeMethodId.kt\ncom/android/tools/ndk/jni/model/JniNativeMethodId\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,121:1\n1557#2:122\n1628#2,3:123\n*S KotlinDebug\n*F\n+ 1 NativeMethodId.kt\ncom/android/tools/ndk/jni/model/JniNativeMethodId\n*L\n74#1:122\n74#1:123,3\n*E\n"})
public final class JniNativeMethodId
extends NativeMethodId {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final FullyQualifiedClassName className;
    @NotNull
    private final String methodName;
    @Nullable
    private final List<JvmType> argTypes;

    public JniNativeMethodId(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @Nullable List<? extends JvmType> argTypes) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        super(null);
        this.className = className;
        this.methodName = methodName;
        this.argTypes = argTypes;
    }

    @NotNull
    public final FullyQualifiedClassName getClassName() {
        return this.className;
    }

    @NotNull
    public final String getMethodName() {
        return this.methodName;
    }

    @Nullable
    public final List<JvmType> getArgTypes() {
        return this.argTypes;
    }

    /*
     * WARNING - void declaration
     */
    public JniNativeMethodId(@NotNull String className, @NotNull String methodName, @Nullable List<String> argTypes) {
        Collection<JvmType> collection;
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        JniNativeMethodId jniNativeMethodId = this;
        FullyQualifiedClassName fullyQualifiedClassName = FullyQualifiedClassName.Companion.fromString(className);
        String string = methodName;
        List<String> list = argTypes;
        if (list != null) {
            Collection<JvmType> collection2;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Iterable iterable = list;
            String string2 = string;
            FullyQualifiedClassName fullyQualifiedClassName2 = fullyQualifiedClassName;
            JniNativeMethodId jniNativeMethodId2 = jniNativeMethodId;
            boolean $i$f$map = false;
            void var6_9 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string3 = (String)item$iv$iv;
                collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(JvmType.Companion.fromJvmString$default(JvmType.Companion, (String)it, false, false, 6, null));
            }
            collection2 = (List)destination$iv$iv;
            jniNativeMethodId = jniNativeMethodId2;
            fullyQualifiedClassName = fullyQualifiedClassName2;
            string = string2;
            collection = collection2;
        } else {
            collection = null;
        }
        jniNativeMethodId(fullyQualifiedClassName, string, (List<? extends JvmType>)collection);
    }

    public /* synthetic */ JniNativeMethodId(String string, String string2, List list, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list = null;
        }
        this(string, string2, list);
    }

    @Override
    @NotNull
    public String getFunctionName() {
        String result = "Java_" + JniMangleUtilsKt.escape(this.className.getJvm()) + "_" + JniMangleUtilsKt.escape(this.methodName);
        if (this.argTypes != null) {
            result = result + "__" + JniMangleUtilsKt.escape(JvmTypeKt.serializeAsString(this.argTypes));
        }
        return result;
    }

    @NotNull
    public String toString() {
        String string = this.className.getJava();
        List<JvmType> list = this.argTypes;
        if (list == null || (list = CollectionsKt.joinToString$default((Iterable)list, null, null, null, (int)0, null, null, (int)63, null)) == null) {
            list = "<unknown>";
        }
        return string + "#" + this.methodName + "(" + (String)((Object)list) + ")";
    }

    @NotNull
    public final FullyQualifiedClassName component1() {
        return this.className;
    }

    @NotNull
    public final String component2() {
        return this.methodName;
    }

    @Nullable
    public final List<JvmType> component3() {
        return this.argTypes;
    }

    @NotNull
    public final JniNativeMethodId copy(@NotNull FullyQualifiedClassName className, @NotNull String methodName, @Nullable List<? extends JvmType> argTypes) {
        Intrinsics.checkNotNullParameter((Object)className, (String)"className");
        Intrinsics.checkNotNullParameter((Object)methodName, (String)"methodName");
        return new JniNativeMethodId(className, methodName, argTypes);
    }

    public static /* synthetic */ JniNativeMethodId copy$default(JniNativeMethodId jniNativeMethodId, FullyQualifiedClassName fullyQualifiedClassName, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            fullyQualifiedClassName = jniNativeMethodId.className;
        }
        if ((n & 2) != 0) {
            string = jniNativeMethodId.methodName;
        }
        if ((n & 4) != 0) {
            list = jniNativeMethodId.argTypes;
        }
        return jniNativeMethodId.copy(fullyQualifiedClassName, string, list);
    }

    public int hashCode() {
        int result = this.className.hashCode();
        result = result * 31 + this.methodName.hashCode();
        result = result * 31 + (this.argTypes == null ? 0 : ((Object)this.argTypes).hashCode());
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof JniNativeMethodId)) {
            return false;
        }
        JniNativeMethodId jniNativeMethodId = (JniNativeMethodId)other;
        if (!Intrinsics.areEqual((Object)this.className, (Object)jniNativeMethodId.className)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.methodName, (Object)jniNativeMethodId.methodName)) {
            return false;
        }
        return Intrinsics.areEqual(this.argTypes, jniNativeMethodId.argTypes);
    }

    @JvmStatic
    @Nullable
    public static final JniNativeMethodId fromJniMethodName(@NotNull String jniMethodName) {
        return Companion.fromJniMethodName(jniMethodName);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/ndk/jni/model/JniNativeMethodId$Companion;", "", "<init>", "()V", "fromJniMethodName", "Lcom/android/tools/ndk/jni/model/JniNativeMethodId;", "jniMethodName", "", "android-ndk"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @Nullable
        public final JniNativeMethodId fromJniMethodName(@NotNull String jniMethodName) {
            Intrinsics.checkNotNullParameter((Object)jniMethodName, (String)"jniMethodName");
            if (!StringsKt.startsWith$default((String)jniMethodName, (String)"Java_", (boolean)false, (int)2, null)) {
                return null;
            }
            try {
                String[] stringArray = new String[]{"__"};
                List parts = StringsKt.split$default((CharSequence)StringsKt.removePrefix((String)jniMethodName, (CharSequence)"Java_"), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                String jniClassNameAndMethodName = (String)parts.get(0);
                String jniParameterTypes = parts.size() == 2 ? (String)parts.get(1) : null;
                Pair<String, String> pair = JniMangleUtilsKt.bisectAtLast(JniMangleUtilsKt.unescape(jniClassNameAndMethodName), '/');
                String fqClassName = (String)pair.component1();
                String methodName = (String)pair.component2();
                String string = jniParameterTypes;
                List<JvmType> argTypes = string != null && (string = JniMangleUtilsKt.unescape(string)) != null ? JvmTypeKt.parseJvmTypes(string) : null;
                return new JniNativeMethodId(FullyQualifiedClassName.Companion.fromString(fqClassName), methodName, argTypes);
            }
            catch (IllegalArgumentException e) {
                return null;
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

