/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.editor;

import com.android.tools.idea.execution.common.debug.AndroidDebuggerConfigurable;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerPanel;
import com.android.tools.ndk.run.editor.NativeAndroidDebuggerState;
import com.intellij.openapi.project.Project;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NativeAndroidDebuggerConfigurable<S extends NativeAndroidDebuggerState>
extends AndroidDebuggerConfigurable<S> {
    private final NativeAndroidDebuggerPanel myNativeAndroidDebuggerPanel;
    private final boolean myEnableShowAttachOnWaitForDebugger;
    private final boolean myEnableShowDebugSandboxSdk;

    NativeAndroidDebuggerConfigurable(@NotNull Project project, boolean enableShowAttachOnWaitForDebugger, boolean enableShowDebugSandboxSdk) {
        this.myEnableShowAttachOnWaitForDebugger = enableShowAttachOnWaitForDebugger;
        this.myEnableShowDebugSandboxSdk = enableShowDebugSandboxSdk;
        this.myNativeAndroidDebuggerPanel = new NativeAndroidDebuggerPanel(project, this.myEnableShowAttachOnWaitForDebugger, this.myEnableShowDebugSandboxSdk);
    }

    @Nullable
    public JComponent getComponent() {
        return this.myNativeAndroidDebuggerPanel.getComponent();
    }

    public void resetFrom(@NotNull S state) {
        this.myNativeAndroidDebuggerPanel.setShowStaticVars(((NativeAndroidDebuggerState)((Object)state)).showStaticVars());
        this.myNativeAndroidDebuggerPanel.setShowOptimizedWarning(((NativeAndroidDebuggerState)((Object)state)).showOptimizedWarning());
        this.myNativeAndroidDebuggerPanel.getSymbolDirectoryPanel().setSymbolDirs(((NativeAndroidDebuggerState)((Object)state)).getSymbolDirs());
        this.myNativeAndroidDebuggerPanel.setTargetLoggingChannels(((NativeAndroidDebuggerState)((Object)state)).getTargetLoggingChannels());
        this.myNativeAndroidDebuggerPanel.setUserStartupCommands(((NativeAndroidDebuggerState)((Object)state)).getUserStartupCommands());
        this.myNativeAndroidDebuggerPanel.setUserPostAttachCommands(((NativeAndroidDebuggerState)((Object)state)).getUserPostAttachCommands());
        this.myNativeAndroidDebuggerPanel.setAttachOnWaitForDebugger(state.attachOnWaitForDebugger() && this.myEnableShowAttachOnWaitForDebugger);
        this.myNativeAndroidDebuggerPanel.setDebugSandboxSdk(state.debugSandboxSdk());
    }

    public void applyTo(@NotNull S state) {
        ((NativeAndroidDebuggerState)((Object)state)).setShowStaticVars(this.myNativeAndroidDebuggerPanel.showStaticVars());
        ((NativeAndroidDebuggerState)((Object)state)).setShowOptimizedWarning(this.myNativeAndroidDebuggerPanel.showOptimizedWarning());
        ((NativeAndroidDebuggerState)((Object)state)).setSymbolDirs(this.myNativeAndroidDebuggerPanel.getSymbolDirectoryPanel().getSymbolDirs());
        ((NativeAndroidDebuggerState)((Object)state)).setTargetLoggingChannels(this.myNativeAndroidDebuggerPanel.getTargetLoggingChannels());
        ((NativeAndroidDebuggerState)((Object)state)).setUserStartupCommands(this.myNativeAndroidDebuggerPanel.getUserStartupCommands());
        ((NativeAndroidDebuggerState)((Object)state)).setUserPostAttachCommands(this.myNativeAndroidDebuggerPanel.getUserPostAttachCommands());
        state.setAttachOnWaitForDebugger(this.myNativeAndroidDebuggerPanel.attachOnWaitForDebugger() && this.myEnableShowAttachOnWaitForDebugger);
        state.setDebugSandboxSdk(this.myNativeAndroidDebuggerPanel.debugSandboxSdk() && this.myEnableShowDebugSandboxSdk);
    }
}

