/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.ndk.run.lldb.renderers;

import com.android.tools.ndk.run.lldb.renderers.TypeNameFormatterCategory;
import com.android.utils.Pair;
import org.jetbrains.annotations.NotNull;

class ConstTypeNameFormatter
implements TypeNameFormatterCategory.TypeNameFormatter {
    private static final String CONST_PREFIX = "const ";
    private static final int CONST_PREFIX_LENGTH = "const ".length();
    private TypeNameFormatterCategory.TypeNameFormatter myNonConstFormatter = null;

    @NotNull
    public static Pair<String, Boolean> getNonConstTypeName(@NotNull String typeName) {
        if (typeName.startsWith(CONST_PREFIX)) {
            return Pair.of((Object)typeName.substring(CONST_PREFIX_LENGTH), (Object)Boolean.TRUE);
        }
        return Pair.of((Object)typeName, (Object)Boolean.FALSE);
    }

    public ConstTypeNameFormatter(@NotNull TypeNameFormatterCategory.TypeNameFormatter nonConstFormatter) {
        this.myNonConstFormatter = nonConstFormatter;
    }

    @Override
    @NotNull
    public String format(@NotNull String rawTypeName) {
        return CONST_PREFIX + this.myNonConstFormatter.format((String)ConstTypeNameFormatter.getNonConstTypeName(rawTypeName).getFirst());
    }
}

