/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.incremental.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.incremental.impl.UtilsKt;
import org.jetbrains.org.objectweb.asm.ClassVisitor;
import org.jetbrains.org.objectweb.asm.ClassWriter;
import org.jetbrains.org.objectweb.asm.tree.AnnotationNode;
import org.jetbrains.org.objectweb.asm.tree.ClassNode;
import org.jetbrains.org.objectweb.asm.tree.FieldNode;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007J\u0018\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\t\u001a\u00020\nJ\u000e\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000e\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\u0015\u001a\u00020\u0007H\u0002\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter;", "", "<init>", "()V", "snapshotClass", "", "classNode", "Lorg/jetbrains/org/objectweb/asm/tree/ClassNode;", "snapshotClassExcludingMembers", "alsoExcludeKotlinMetaData", "", "snapshotField", "fieldNode", "Lorg/jetbrains/org/objectweb/asm/tree/FieldNode;", "snapshotMethod", "methodNode", "Lorg/jetbrains/org/objectweb/asm/tree/MethodNode;", "classVersion", "", "sortClassMembers", "", "emptyClass", "kotlin-build-common"})
@SourceDebugExtension(value={"SMAP\nClassNodeSnapshotter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClassNodeSnapshotter.kt\norg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n827#2:69\n855#2,2:70\n*S KotlinDebug\n*F\n+ 1 ClassNodeSnapshotter.kt\norg/jetbrains/kotlin/incremental/impl/ClassNodeSnapshotter\n*L\n30#1:69\n30#1:70,2\n*E\n"})
public final class ClassNodeSnapshotter {
    @NotNull
    public static final ClassNodeSnapshotter INSTANCE = new ClassNodeSnapshotter();

    private ClassNodeSnapshotter() {
    }

    public final long snapshotClass(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        ClassWriter classWriter = new ClassWriter(0);
        classNode.accept((ClassVisitor)classWriter);
        byte[] byArray = classWriter.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return UtilsKt.hashToLong(byArray);
    }

    /*
     * WARNING - void declaration
     */
    public final long snapshotClassExcludingMembers(@NotNull ClassNode classNode, boolean alsoExcludeKotlinMetaData) {
        long l;
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List originalFields = classNode.fields;
        List originalMethods = classNode.methods;
        List originalVisibleAnnotations = classNode.visibleAnnotations;
        classNode.fields = CollectionsKt.emptyList();
        classNode.methods = CollectionsKt.emptyList();
        if (alsoExcludeKotlinMetaData) {
            List list;
            ClassNode classNode2 = classNode;
            List list2 = originalVisibleAnnotations;
            if (list2 != null) {
                void $this$filterNotTo$iv$iv;
                void $this$filterNot$iv;
                Iterable iterable = list2;
                ClassNode classNode3 = classNode2;
                boolean $i$f$filterNot = false;
                void var9_11 = $this$filterNot$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$filterNotTo = false;
                for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
                    AnnotationNode it = (AnnotationNode)element$iv$iv;
                    boolean bl = false;
                    if (Intrinsics.areEqual((Object)it.desc, (Object)"Lkotlin/Metadata;")) continue;
                    destination$iv$iv.add(element$iv$iv);
                }
                list = (List)destination$iv$iv;
                classNode2 = classNode3;
            } else {
                list = null;
            }
            classNode2.visibleAnnotations = list;
        }
        long it = l = this.snapshotClass(classNode);
        boolean bl = false;
        classNode.fields = originalFields;
        classNode.methods = originalMethods;
        classNode.visibleAnnotations = originalVisibleAnnotations;
        return l;
    }

    public static /* synthetic */ long snapshotClassExcludingMembers$default(ClassNodeSnapshotter classNodeSnapshotter, ClassNode classNode, boolean bl, int n, Object object) {
        if ((n & 2) != 0) {
            bl = false;
        }
        return classNodeSnapshotter.snapshotClassExcludingMembers(classNode, bl);
    }

    public final long snapshotField(@NotNull FieldNode fieldNode) {
        Intrinsics.checkNotNullParameter((Object)fieldNode, (String)"fieldNode");
        ClassNode classNode = this.emptyClass();
        classNode.fields.add(fieldNode);
        return this.snapshotClass(classNode);
    }

    public final long snapshotMethod(@NotNull MethodNode methodNode, int classVersion) {
        Intrinsics.checkNotNullParameter((Object)methodNode, (String)"methodNode");
        ClassNode classNode = this.emptyClass();
        classNode.version = classVersion;
        classNode.methods.add(methodNode);
        return this.snapshotClass(classNode);
    }

    public final void sortClassMembers(@NotNull ClassNode classNode) {
        Intrinsics.checkNotNullParameter((Object)classNode, (String)"classNode");
        List list = classNode.fields;
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"fields");
        Function1[] function1Array = new Function1[]{ClassNodeSnapshotter::sortClassMembers$lambda$2, ClassNodeSnapshotter::sortClassMembers$lambda$3};
        CollectionsKt.sortWith((List)list, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
        List list2 = classNode.methods;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"methods");
        function1Array = new Function1[]{ClassNodeSnapshotter::sortClassMembers$lambda$4, ClassNodeSnapshotter::sortClassMembers$lambda$5};
        CollectionsKt.sortWith((List)list2, (Comparator)ComparisonsKt.compareBy((Function1[])function1Array));
    }

    private final ClassNode emptyClass() {
        ClassNode classNode;
        ClassNode it = classNode = new ClassNode();
        boolean bl = false;
        it.name = "SomeClass";
        return classNode;
    }

    private static final Comparable sortClassMembers$lambda$2(FieldNode it) {
        return (Comparable)((Object)it.name);
    }

    private static final Comparable sortClassMembers$lambda$3(FieldNode it) {
        return (Comparable)((Object)it.desc);
    }

    private static final Comparable sortClassMembers$lambda$4(MethodNode it) {
        return (Comparable)((Object)it.name);
    }

    private static final Comparable sortClassMembers$lambda$5(MethodNode it) {
        return (Comparable)((Object)it.desc);
    }
}

