/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.calls.inference.components;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.config.LanguageFeature;
import org.jetbrains.kotlin.config.LanguageVersionSettings;
import org.jetbrains.kotlin.resolve.calls.inference.components.VariableFixationFinder;
import org.jetbrains.kotlin.resolve.calls.inference.model.Constraint;
import org.jetbrains.kotlin.resolve.calls.inference.model.VariableWithConstraints;
import org.jetbrains.kotlin.resolve.calls.model.PostponedResolvedAtomMarker;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.MarkerExtensionsKt;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeSystemContextHelpersKt;
import org.jetbrains.kotlin.utils.SmartSet;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010%\n\u0002\u0010#\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\n\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\u00020\u0001BC\u0012\u0012\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u0012\b\u0010\t\u001a\u0004\u0018\u00010\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u000e\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J\u000e\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J\u0010\u0010\u001f\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004H\u0002J\u000e\u0010 \u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010!\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010\"\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u00152\u0006\u0010\u001d\u001a\u00020\u0004J\u0016\u0010#\u001a\u00020\u001c2\u0006\u0010$\u001a\u00020\u00042\u0006\u0010%\u001a\u00020\u0004J\b\u0010&\u001a\u00020'H\u0002J\b\u0010(\u001a\u00020'H\u0002J\b\u0010)\u001a\u00020'H\u0002J\b\u0010*\u001a\u00020'H\u0002J\b\u0010+\u001a\u00020'H\u0002J\u0010\u0010,\u001a\u00020\u001c2\u0006\u0010-\u001a\u00020\u0004H\u0002J \u0010.\u001a\u00020\u001c*\u00020\n2\u0012\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020'00H\u0002J\u0016\u00101\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u00102\u001a\u00020\u0004H\u0002J\u0016\u00103\u001a\b\u0012\u0004\u0012\u00020\u00040\u00122\u0006\u00102\u001a\u00020\u0004H\u0002J&\u00104\u001a\u00020'2\f\u00105\u001a\b\u0012\u0004\u0012\u00020\u00040\u00152\u0006\u00106\u001a\u00020\u00042\u0006\u00107\u001a\u00020\u001cH\u0002R\u001a\u0010\u0002\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00050\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0013\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0017\u001a\u0014\u0012\u0004\u0012\u00020\u0004\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00040\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00040\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u001a\u001a\n\u0012\u0004\u0012\u00020\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00068"}, d2={"Lorg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider;", "", "notFixedTypeVariables", "", "Lorg/jetbrains/kotlin/types/model/TypeConstructorMarker;", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/VariableWithConstraints;", "postponedKtPrimitives", "", "Lorg/jetbrains/kotlin/resolve/calls/model/PostponedResolvedAtomMarker;", "topLevelType", "Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;", "typeSystemContext", "Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;", "languageVersionSettings", "Lorg/jetbrains/kotlin/config/LanguageVersionSettings;", "<init>", "(Ljava/util/Map;Ljava/util/List;Lorg/jetbrains/kotlin/types/model/KotlinTypeMarker;Lorg/jetbrains/kotlin/resolve/calls/inference/components/VariableFixationFinder$Context;Lorg/jetbrains/kotlin/config/LanguageVersionSettings;)V", "outerTypeVariables", "", "deepTypeVariableDependencies", "", "", "shallowTypeVariableDependencies", "postponeArgumentsEdges", "relatedToAllOutputTypes", "relatedToTopLevelType", "relatedToOuterTypeVariables", "isVariableRelatedToTopLevelType", "", "variable", "isRelatedToOuterTypeVariable", "oldIsRelatedToOuterTypeVariable", "isVariableRelatedToAnyOutputType", "getDeeplyDependentVariables", "getShallowlyDependentVariables", "areVariablesDependentShallowly", "a", "b", "computeConstraintEdges", "", "computePostponeArgumentsEdges", "computeRelatedToAllOutputTypes", "computeRelatedToTopLevelType", "computeRelatedToTopOuterTypeVariables", "isMyTypeVariable", "typeConstructor", "forAllMyTypeVariables", "action", "Lkotlin/Function1;", "getConstraintEdges", "from", "getPostponeEdges", "addAllRelatedNodes", "to", "node", "includePostponedEdges", "resolution.common"})
@SourceDebugExtension(value={"SMAP\nTypeVariableDependencyInformationProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 TypeVariableDependencyInformationProvider.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n*L\n1#1,194:1\n1761#2,3:195\n1761#2,3:198\n1761#2,3:201\n384#3,7:204\n384#3,7:211\n384#3,7:218\n384#3,7:225\n384#3,7:232\n*S KotlinDebug\n*F\n+ 1 TypeVariableDependencyInformationProvider.kt\norg/jetbrains/kotlin/resolve/calls/inference/components/TypeVariableDependencyInformationProvider\n*L\n72#1:195,3\n85#1:198,3\n86#1:201,3\n91#1:204,7\n92#1:211,7\n96#1:218,7\n97#1:225,7\n120#1:232,7\n*E\n"})
public final class TypeVariableDependencyInformationProvider {
    @NotNull
    private final Map<TypeConstructorMarker, VariableWithConstraints> notFixedTypeVariables;
    @NotNull
    private final List<PostponedResolvedAtomMarker> postponedKtPrimitives;
    @Nullable
    private final KotlinTypeMarker topLevelType;
    @NotNull
    private final VariableFixationFinder.Context typeSystemContext;
    @NotNull
    private final LanguageVersionSettings languageVersionSettings;
    @Nullable
    private final Set<TypeConstructorMarker> outerTypeVariables;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> deepTypeVariableDependencies;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> shallowTypeVariableDependencies;
    @NotNull
    private final Map<TypeConstructorMarker, Set<TypeConstructorMarker>> postponeArgumentsEdges;
    @NotNull
    private final Set<TypeConstructorMarker> relatedToAllOutputTypes;
    @NotNull
    private final Set<TypeConstructorMarker> relatedToTopLevelType;
    @Nullable
    private Set<TypeConstructorMarker> relatedToOuterTypeVariables;

    public TypeVariableDependencyInformationProvider(@NotNull Map<TypeConstructorMarker, ? extends VariableWithConstraints> notFixedTypeVariables, @NotNull List<? extends PostponedResolvedAtomMarker> postponedKtPrimitives, @Nullable KotlinTypeMarker topLevelType, @NotNull VariableFixationFinder.Context typeSystemContext, @NotNull LanguageVersionSettings languageVersionSettings) {
        Intrinsics.checkNotNullParameter(notFixedTypeVariables, (String)"notFixedTypeVariables");
        Intrinsics.checkNotNullParameter(postponedKtPrimitives, (String)"postponedKtPrimitives");
        Intrinsics.checkNotNullParameter((Object)typeSystemContext, (String)"typeSystemContext");
        Intrinsics.checkNotNullParameter((Object)languageVersionSettings, (String)"languageVersionSettings");
        this.notFixedTypeVariables = notFixedTypeVariables;
        this.postponedKtPrimitives = postponedKtPrimitives;
        this.topLevelType = topLevelType;
        this.typeSystemContext = typeSystemContext;
        this.languageVersionSettings = languageVersionSettings;
        this.outerTypeVariables = this.typeSystemContext.getOuterTypeVariables();
        this.deepTypeVariableDependencies = new HashMap();
        this.shallowTypeVariableDependencies = new HashMap();
        this.postponeArgumentsEdges = new HashMap();
        this.relatedToAllOutputTypes = new HashSet();
        this.relatedToTopLevelType = new HashSet();
        this.computeConstraintEdges();
        this.computePostponeArgumentsEdges();
        this.computeRelatedToAllOutputTypes();
        this.computeRelatedToTopLevelType();
        this.computeRelatedToTopOuterTypeVariables();
    }

    public final boolean isVariableRelatedToTopLevelType(@NotNull TypeConstructorMarker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.relatedToTopLevelType.contains(variable);
    }

    public final boolean isRelatedToOuterTypeVariable(@NotNull TypeConstructorMarker variable) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        if (this.languageVersionSettings.supportsFeature(LanguageFeature.PCLAEnhancementsIn21)) {
            Set<TypeConstructorMarker> set = this.relatedToOuterTypeVariables;
            bl = set != null ? set.contains(variable) : false;
        } else {
            bl = this.oldIsRelatedToOuterTypeVariable(variable);
        }
        return bl;
    }

    private final boolean oldIsRelatedToOuterTypeVariable(TypeConstructorMarker variable) {
        boolean bl;
        block5: {
            Set<TypeConstructorMarker> set = this.outerTypeVariables;
            if (set == null) {
                return false;
            }
            Set<TypeConstructorMarker> outerTypeVariables = set;
            Set<TypeConstructorMarker> set2 = this.getDeeplyDependentVariables(variable);
            if (set2 == null) {
                return false;
            }
            Set<TypeConstructorMarker> myDependent = set2;
            Iterable $this$any$iv = myDependent;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    TypeConstructorMarker it = (TypeConstructorMarker)element$iv;
                    boolean bl2 = false;
                    if (!outerTypeVariables.contains(it)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    public final boolean isVariableRelatedToAnyOutputType(@NotNull TypeConstructorMarker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.relatedToAllOutputTypes.contains(variable);
    }

    @Nullable
    public final Set<TypeConstructorMarker> getDeeplyDependentVariables(@NotNull TypeConstructorMarker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.deepTypeVariableDependencies.get(variable);
    }

    @Nullable
    public final Set<TypeConstructorMarker> getShallowlyDependentVariables(@NotNull TypeConstructorMarker variable) {
        Intrinsics.checkNotNullParameter((Object)variable, (String)"variable");
        return this.shallowTypeVariableDependencies.get(variable);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean areVariablesDependentShallowly(@NotNull TypeConstructorMarker a, @NotNull TypeConstructorMarker b) {
        boolean bl;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)a, (String)"a");
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        if (Intrinsics.areEqual((Object)a, (Object)b)) {
            return true;
        }
        Set<TypeConstructorMarker> set = this.shallowTypeVariableDependencies.get(a);
        if (set == null) {
            return false;
        }
        Set<TypeConstructorMarker> shallowDependencies = set;
        Iterable $this$any$iv = shallowDependencies;
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            bl2 = false;
        } else {
            for (Object element$iv : $this$any$iv) {
                TypeConstructorMarker it = (TypeConstructorMarker)element$iv;
                boolean bl3 = false;
                if (!Intrinsics.areEqual((Object)it, (Object)b)) continue;
                return true;
            }
            bl2 = false;
        }
        if (bl2) return true;
        $this$any$iv = this.shallowTypeVariableDependencies.values();
        $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            Object element$iv;
            if (!iterator2.hasNext()) return false;
            element$iv = iterator2.next();
            Set dependencies = (Set)element$iv;
            boolean bl4 = false;
            if (dependencies.contains(a) && dependencies.contains(b)) {
                return true;
            }
            bl = false;
        } while (!bl);
        return true;
    }

    private final void computeConstraintEdges() {
        for (VariableWithConstraints variableWithConstraints : this.notFixedTypeVariables.values()) {
            TypeConstructorMarker from = MarkerExtensionsKt.freshTypeConstructor(variableWithConstraints.getTypeVariable(), this.typeSystemContext);
            for (Constraint constraint : variableWithConstraints.getConstraints()) {
                TypeConstructorMarker constraintTypeConstructor = TypeSystemContextHelpersKt.typeConstructor(constraint.getType(), this.typeSystemContext);
                this.forAllMyTypeVariables(constraint.getType(), (Function1<? super TypeConstructorMarker, Unit>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.computeConstraintEdges$lambda$7(this, from, arg_0)));
                if (!this.isMyTypeVariable(constraintTypeConstructor)) continue;
                TypeVariableDependencyInformationProvider.computeConstraintEdges$addConstraintEdgeForShallowDependency(this, from, constraintTypeConstructor);
            }
        }
    }

    private final void computePostponeArgumentsEdges() {
        for (PostponedResolvedAtomMarker argument : this.postponedKtPrimitives) {
            if (argument.getAnalyzed()) continue;
            SmartSet typeVariablesInOutputType = SmartSet.Companion.create();
            KotlinTypeMarker kotlinTypeMarker = argument.getOutputType();
            if (kotlinTypeMarker == null) continue;
            this.forAllMyTypeVariables(kotlinTypeMarker, (Function1<? super TypeConstructorMarker, Unit>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.computePostponeArgumentsEdges$lambda$9(typeVariablesInOutputType, arg_0)));
            if (typeVariablesInOutputType.isEmpty()) continue;
            for (KotlinTypeMarker inputType : argument.getInputTypes()) {
                this.forAllMyTypeVariables(inputType, (Function1<? super TypeConstructorMarker, Unit>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.computePostponeArgumentsEdges$lambda$10(typeVariablesInOutputType, this, arg_0)));
            }
        }
    }

    private final void computeRelatedToAllOutputTypes() {
        for (PostponedResolvedAtomMarker argument : this.postponedKtPrimitives) {
            if (argument.getAnalyzed()) continue;
            KotlinTypeMarker kotlinTypeMarker = argument.getOutputType();
            if (kotlinTypeMarker == null) continue;
            this.forAllMyTypeVariables(kotlinTypeMarker, (Function1<? super TypeConstructorMarker, Unit>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.computeRelatedToAllOutputTypes$lambda$11(this, arg_0)));
        }
    }

    private final void computeRelatedToTopLevelType() {
        if (this.topLevelType == null) {
            return;
        }
        this.forAllMyTypeVariables(this.topLevelType, (Function1<? super TypeConstructorMarker, Unit>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.computeRelatedToTopLevelType$lambda$12(this, arg_0)));
    }

    private final void computeRelatedToTopOuterTypeVariables() {
        Set<TypeConstructorMarker> set = this.outerTypeVariables;
        if (set == null) {
            return;
        }
        Set<TypeConstructorMarker> outerTypeVariables = set;
        this.relatedToOuterTypeVariables = new LinkedHashSet();
        for (TypeConstructorMarker outerTypeVariable : outerTypeVariables) {
            Set<TypeConstructorMarker> set2 = this.relatedToOuterTypeVariables;
            Intrinsics.checkNotNull(set2);
            this.addAllRelatedNodes(set2, outerTypeVariable, true);
        }
    }

    private final boolean isMyTypeVariable(TypeConstructorMarker typeConstructor) {
        return this.notFixedTypeVariables.containsKey(typeConstructor);
    }

    private final boolean forAllMyTypeVariables(KotlinTypeMarker $this$forAllMyTypeVariables, Function1<? super TypeConstructorMarker, Unit> action) {
        VariableFixationFinder.Context $this$forAllMyTypeVariables_u24lambda_u2414 = this.typeSystemContext;
        boolean bl = false;
        return $this$forAllMyTypeVariables_u24lambda_u2414.contains($this$forAllMyTypeVariables, (Function1<? super KotlinTypeMarker, Boolean>)((Function1)arg_0 -> TypeVariableDependencyInformationProvider.forAllMyTypeVariables$lambda$14$lambda$13($this$forAllMyTypeVariables_u24lambda_u2414, this, action, arg_0)));
    }

    private final Set<TypeConstructorMarker> getConstraintEdges(TypeConstructorMarker from) {
        Set set = this.deepTypeVariableDependencies.get(from);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final Set<TypeConstructorMarker> getPostponeEdges(TypeConstructorMarker from) {
        Set set = this.postponeArgumentsEdges.get(from);
        if (set == null) {
            set = SetsKt.emptySet();
        }
        return set;
    }

    private final void addAllRelatedNodes(Set<TypeConstructorMarker> to, TypeConstructorMarker node, boolean includePostponedEdges) {
        if (to.add(node)) {
            for (TypeConstructorMarker relatedNode : this.getConstraintEdges(node)) {
                this.addAllRelatedNodes(to, relatedNode, includePostponedEdges);
            }
            if (includePostponedEdges) {
                for (TypeConstructorMarker relatedNode : this.getPostponeEdges(node)) {
                    this.addAllRelatedNodes(to, relatedNode, includePostponedEdges);
                }
            }
        }
    }

    private static final void computeConstraintEdges$addConstraintEdgeForDeepDependency(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from, TypeConstructorMarker to) {
        Set set;
        Set set2;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.deepTypeVariableDependencies;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(from, answer$iv);
            set2 = answer$iv;
        } else {
            set2 = value$iv;
        }
        set2.add((TypeConstructorMarker)to);
        $this$getOrPut$iv = this$0.deepTypeVariableDependencies;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(to, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)from);
    }

    private static final void computeConstraintEdges$addConstraintEdgeForShallowDependency(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from, TypeConstructorMarker to) {
        Set set;
        Set set2;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.shallowTypeVariableDependencies;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(from, answer$iv);
            set2 = answer$iv;
        } else {
            set2 = value$iv;
        }
        set2.add((TypeConstructorMarker)to);
        $this$getOrPut$iv = this$0.shallowTypeVariableDependencies;
        $i$f$getOrPut = false;
        value$iv = $this$getOrPut$iv.get(to);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new LinkedHashSet();
            $this$getOrPut$iv.put(to, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)from);
    }

    private static final Unit computeConstraintEdges$lambda$7(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker $from, TypeConstructorMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (this$0.isMyTypeVariable(it)) {
            TypeVariableDependencyInformationProvider.computeConstraintEdges$addConstraintEdgeForDeepDependency(this$0, $from, it);
        }
        return Unit.INSTANCE;
    }

    private static final void computePostponeArgumentsEdges$addPostponeArgumentsEdges(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from, TypeConstructorMarker to) {
        Set set;
        Map<TypeConstructorMarker, Set<TypeConstructorMarker>> $this$getOrPut$iv = this$0.postponeArgumentsEdges;
        boolean $i$f$getOrPut = false;
        Set value$iv = $this$getOrPut$iv.get(from);
        if (value$iv == null) {
            boolean bl = false;
            Set answer$iv = new HashSet();
            $this$getOrPut$iv.put(from, answer$iv);
            set = answer$iv;
        } else {
            set = value$iv;
        }
        set.add((TypeConstructorMarker)to);
    }

    private static final Unit computePostponeArgumentsEdges$lambda$9(SmartSet $typeVariablesInOutputType, TypeConstructorMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        $typeVariablesInOutputType.add(it);
        return Unit.INSTANCE;
    }

    private static final Unit computePostponeArgumentsEdges$lambda$10(SmartSet $typeVariablesInOutputType, TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker from) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        Iterator iterator2 = $typeVariablesInOutputType.iterator();
        while (iterator2.hasNext()) {
            TypeConstructorMarker to = (TypeConstructorMarker)iterator2.next();
            TypeVariableDependencyInformationProvider.computePostponeArgumentsEdges$addPostponeArgumentsEdges(this$0, from, to);
        }
        return Unit.INSTANCE;
    }

    private static final Unit computeRelatedToAllOutputTypes$lambda$11(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addAllRelatedNodes(this$0.relatedToAllOutputTypes, it, false);
        return Unit.INSTANCE;
    }

    private static final Unit computeRelatedToTopLevelType$lambda$12(TypeVariableDependencyInformationProvider this$0, TypeConstructorMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        this$0.addAllRelatedNodes(this$0.relatedToTopLevelType, it, true);
        return Unit.INSTANCE;
    }

    private static final boolean forAllMyTypeVariables$lambda$14$lambda$13(VariableFixationFinder.Context $this_with, TypeVariableDependencyInformationProvider this$0, Function1 $action, KotlinTypeMarker it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        TypeConstructorMarker typeConstructor = $this_with.typeConstructor(it);
        if (this$0.isMyTypeVariable(typeConstructor)) {
            $action.invoke((Object)typeConstructor);
        }
        return false;
    }
}

