/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.internal.daemon;

import com.intellij.gradle.toolingExtension.util.GradleVersionUtil;
import java.io.File;
import java.lang.reflect.Constructor;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.internal.file.DefaultFileCollectionFactory;
import org.gradle.api.internal.file.FileCollectionFactory;
import org.gradle.api.internal.file.IdentityFileResolver;
import org.gradle.api.internal.file.collections.DefaultDirectoryFileTreeFactory;
import org.gradle.api.internal.file.collections.DirectoryFileTreeFactory;
import org.gradle.api.internal.tasks.DefaultTaskDependencyFactory;
import org.gradle.api.internal.tasks.TaskDependencyFactory;
import org.gradle.api.tasks.util.internal.DefaultPatternSetFactory;
import org.gradle.api.tasks.util.internal.PatternSetFactory;
import org.gradle.api.tasks.util.internal.PatternSpecFactory;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.internal.Factory;
import org.gradle.internal.file.PathToFileResolver;
import org.gradle.internal.nativeintegration.filesystem.FileSystem;
import org.gradle.launcher.configuration.BuildLayoutResult;
import org.gradle.launcher.daemon.configuration.DaemonParameters;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.internal.daemon.DaemonAction;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u001a\u0010\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0007\u001a\u0010\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0007\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u000f\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0011"}, d2={"getDaemonParameters", "Lorg/gradle/launcher/daemon/configuration/DaemonParameters;", "layout", "Lorg/gradle/initialization/BuildLayoutParameters;", "daemonParameters8Dot12", "daemonParameters6Dot6", "daemonParameters6Dot4", "daemonParameters6Dot3", "createCollectionFactory6Dot3", "Lorg/gradle/api/internal/file/DefaultFileCollectionFactory;", "fileResolver", "Lorg/gradle/api/internal/file/IdentityFileResolver;", "patternFactory", "Lorg/gradle/api/tasks/util/internal/PatternSetFactory;", "daemonParameters6Dot0", "daemonParameters5Dot3", "daemonParametersPre5Dot3", "intellij.gradle"})
@JvmName(name="GradleDaemonParametersFactory")
public final class GradleDaemonParametersFactory {
    @ApiStatus.Internal
    @NotNull
    public static final DaemonParameters getDaemonParameters(@NotNull BuildLayoutParameters layout) {
        Intrinsics.checkNotNullParameter((Object)layout, (String)"layout");
        try {
            return GradleVersionUtil.isCurrentGradleAtLeast((String)"8.12") ? GradleDaemonParametersFactory.daemonParameters8Dot12(layout) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.6") ? GradleDaemonParametersFactory.daemonParameters6Dot6(layout) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.4") ? GradleDaemonParametersFactory.daemonParameters6Dot4(layout) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.3") ? GradleDaemonParametersFactory.daemonParameters6Dot3(layout) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"6.0") ? GradleDaemonParametersFactory.daemonParameters6Dot0(layout) : (GradleVersionUtil.isCurrentGradleAtLeast((String)"5.3") ? GradleDaemonParametersFactory.daemonParameters5Dot3(layout) : GradleDaemonParametersFactory.daemonParametersPre5Dot3(layout))))));
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException("Cannot create DaemonParameters by reflection, gradle version " + GradleVersion.current(), e);
        }
    }

    private static final DaemonParameters daemonParameters8Dot12(BuildLayoutParameters layout) {
        DefaultPatternSetFactory patternSetFactory = new DefaultPatternSetFactory(PatternSpecFactory.INSTANCE);
        IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNull((Object)identityFileResolver);
        DefaultFileCollectionFactory collectionFactory = GradleDaemonParametersFactory.createCollectionFactory6Dot3(identityFileResolver, (PatternSetFactory)patternSetFactory);
        Class[] classArray = new Class[]{File.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray);
        Object[] objectArray = new Object[]{layout.getGradleUserHomeDir(), collectionFactory};
        Object t = daemonParametersConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DaemonParameters daemonParameters6Dot6(BuildLayoutParameters layout) {
        ClassLoader classLoader = DaemonAction.class.getClassLoader();
        Class<?> resultClass = classLoader.loadClass("org.gradle.launcher.cli.converter.BuildLayoutConverter$Result");
        Class[] classArray = new Class[]{layout.getClass()};
        Constructor<?> resultConstructor = resultClass.getConstructor(classArray);
        resultConstructor.setAccessible(true);
        Object[] objectArray = new Object[]{layout};
        Object obj = resultConstructor.newInstance(objectArray);
        Intrinsics.checkNotNull(obj, (String)"null cannot be cast to non-null type org.gradle.launcher.configuration.BuildLayoutResult");
        BuildLayoutResult buildLayoutResult = (BuildLayoutResult)obj;
        resultConstructor.setAccessible(false);
        DefaultPatternSetFactory patternSetFactory = new DefaultPatternSetFactory(PatternSpecFactory.INSTANCE);
        IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNull((Object)identityFileResolver);
        DefaultFileCollectionFactory collectionFactory = GradleDaemonParametersFactory.createCollectionFactory6Dot3(identityFileResolver, (PatternSetFactory)patternSetFactory);
        Class[] classArray2 = new Class[]{BuildLayoutResult.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray2);
        Object[] objectArray2 = new Object[]{buildLayoutResult, collectionFactory};
        Object t = daemonParametersConstructor.newInstance(objectArray2);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DaemonParameters daemonParameters6Dot4(BuildLayoutParameters layout) {
        DefaultPatternSetFactory patternSetFactory = new DefaultPatternSetFactory(PatternSpecFactory.INSTANCE);
        IdentityFileResolver identityFileResolver = (IdentityFileResolver)IdentityFileResolver.class.getConstructor(new Class[0]).newInstance(new Object[0]);
        Intrinsics.checkNotNull((Object)identityFileResolver);
        DefaultFileCollectionFactory collectionFactory = GradleDaemonParametersFactory.createCollectionFactory6Dot3(identityFileResolver, (PatternSetFactory)patternSetFactory);
        Class[] classArray = new Class[]{BuildLayoutParameters.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray);
        Object[] objectArray = new Object[]{layout, collectionFactory};
        Object t = daemonParametersConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DaemonParameters daemonParameters6Dot3(BuildLayoutParameters layout) {
        DefaultPatternSetFactory patternSetFactory = new DefaultPatternSetFactory(PatternSpecFactory.INSTANCE);
        Object[] objectArray = new Class[]{Factory.class};
        Constructor constructor = IdentityFileResolver.class.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{patternSetFactory};
        IdentityFileResolver identityFileResolver = (IdentityFileResolver)constructor.newInstance(objectArray);
        Intrinsics.checkNotNull((Object)identityFileResolver);
        DefaultFileCollectionFactory collectionFactory = GradleDaemonParametersFactory.createCollectionFactory6Dot3(identityFileResolver, (PatternSetFactory)patternSetFactory);
        Class[] classArray = new Class[]{BuildLayoutParameters.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray);
        Object[] objectArray2 = new Object[]{layout, collectionFactory};
        Object t = daemonParametersConstructor.newInstance(objectArray2);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DefaultFileCollectionFactory createCollectionFactory6Dot3(IdentityFileResolver fileResolver, PatternSetFactory patternFactory) throws ReflectiveOperationException {
        ClassLoader classLoader = DaemonAction.class.getClassLoader();
        Class<?> propertyHostClass = classLoader.loadClass("org.gradle.api.internal.provider.PropertyHost");
        Object propertyHostNoOp = propertyHostClass.getField("NO_OP").get(null);
        Class[] classArray = new Class[]{PathToFileResolver.class, TaskDependencyFactory.class, DirectoryFileTreeFactory.class, Factory.class, propertyHostClass, FileSystem.class};
        Constructor collectionFactoryConstructor = DefaultFileCollectionFactory.class.getConstructor(classArray);
        Object[] objectArray = new Object[]{fileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), patternFactory, propertyHostNoOp, null};
        Object t = collectionFactoryConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DefaultFileCollectionFactory)t;
    }

    private static final DaemonParameters daemonParameters6Dot0(BuildLayoutParameters layout) {
        DefaultPatternSetFactory patternSetFactory = new DefaultPatternSetFactory(PatternSpecFactory.INSTANCE);
        Object[] objectArray = new Class[]{Factory.class};
        Constructor constructor = IdentityFileResolver.class.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{patternSetFactory};
        IdentityFileResolver identityFileResolver = (IdentityFileResolver)constructor.newInstance(objectArray);
        Class[] classArray = new Class[]{PathToFileResolver.class, TaskDependencyFactory.class, DirectoryFileTreeFactory.class, Factory.class};
        Constructor collectionFactoryConstructor = DefaultFileCollectionFactory.class.getConstructor(classArray);
        Object[] objectArray2 = new Object[]{identityFileResolver, DefaultTaskDependencyFactory.withNoAssociatedProject(), new DefaultDirectoryFileTreeFactory(), patternSetFactory};
        DefaultFileCollectionFactory factory = (DefaultFileCollectionFactory)collectionFactoryConstructor.newInstance(objectArray2);
        Class[] classArray2 = new Class[]{BuildLayoutParameters.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray2);
        Object[] objectArray3 = new Object[]{layout, factory};
        Object t = daemonParametersConstructor.newInstance(objectArray3);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DaemonParameters daemonParameters5Dot3(BuildLayoutParameters layout) {
        Class[] classArray = new Class[]{BuildLayoutParameters.class, FileCollectionFactory.class};
        Constructor daemonParametersConstructor = DaemonParameters.class.getConstructor(classArray);
        Object[] objectArray = new Object[]{layout, DefaultFileCollectionFactory.class.getConstructor(new Class[0]).newInstance(new Object[0])};
        Object t = daemonParametersConstructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }

    private static final DaemonParameters daemonParametersPre5Dot3(BuildLayoutParameters layout) {
        Object[] objectArray = new Class[]{BuildLayoutParameters.class};
        Constructor constructor = DaemonParameters.class.getConstructor((Class<?>[])objectArray);
        objectArray = new Object[]{layout};
        Object t = constructor.newInstance(objectArray);
        Intrinsics.checkNotNullExpressionValue(t, (String)"newInstance(...)");
        return (DaemonParameters)t;
    }
}

