/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.model.data;

import com.intellij.serialization.PropertyMapping;
import java.io.File;
import java.io.Serializable;
import org.jetbrains.annotations.NotNull;

public class EarResource
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NotNull
    private final String earDirectory;
    @NotNull
    private final String relativePath;
    @NotNull
    private final File file;

    @PropertyMapping(value={"earDirectory", "relativePath", "file"})
    public EarResource(@NotNull String earDirectory, @NotNull String relativePath, @NotNull File file) {
        if (earDirectory == null) {
            EarResource.$$$reportNull$$$0(0);
        }
        if (relativePath == null) {
            EarResource.$$$reportNull$$$0(1);
        }
        if (file == null) {
            EarResource.$$$reportNull$$$0(2);
        }
        this.earDirectory = earDirectory;
        this.relativePath = EarResource.getAdjustedPath(relativePath);
        this.file = file;
    }

    @NotNull
    public String getEarDirectory() {
        String string = this.earDirectory;
        if (string == null) {
            EarResource.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    public String getRelativePath() {
        String string = this.relativePath;
        if (string == null) {
            EarResource.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public File getFile() {
        File file = this.file;
        if (file == null) {
            EarResource.$$$reportNull$$$0(5);
        }
        return file;
    }

    private static String getAdjustedPath(@NotNull String path) {
        if (path == null) {
            EarResource.$$$reportNull$$$0(6);
        }
        return path.isEmpty() || path.charAt(0) != '/' ? "/" + path : path;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EarResource)) {
            return false;
        }
        EarResource resource = (EarResource)o;
        if (!this.file.getPath().equals(resource.file.getPath())) {
            return false;
        }
        if (!this.earDirectory.equals(resource.earDirectory)) {
            return false;
        }
        return this.relativePath.equals(resource.relativePath);
    }

    public int hashCode() {
        int result = this.earDirectory.hashCode();
        result = 31 * result + this.relativePath.hashCode();
        result = 31 * result + this.file.getPath().hashCode();
        return result;
    }

    public String toString() {
        return "Resource{earDirectory=" + this.earDirectory + ", relativePath='" + this.relativePath + "', file=" + this.file + "}";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "earDirectory";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativePath";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/gradle/model/data/EarResource";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getEarDirectory";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAdjustedPath";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5 -> new IllegalStateException(string);
        };
    }
}

