/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers;

import com.android.tools.profiler.proto.Common;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.sessions.SessionItem;
import com.android.tools.profilers.sessions.SessionsManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\r\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006H\u0002J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J:\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0018\u0010\u0010\u001a\u0014\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011H\u0007J \u0010\u0014\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0007J9\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0017\u0010\u001a\u001a\u0013\u0012\u0004\u0012\u00020\u001c\u0012\u0004\u0012\u00020\u000b0\u001b\u00a2\u0006\u0002\b\u001dH\u0007J8\u0010\u001e\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\b2\u001e\u0010\u001f\u001a\u001a\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u000b0 H\u0002\u00a8\u0006!"}, d2={"Lcom/android/tools/profilers/ImportedSessionUtils;", "", "<init>", "()V", "getLogger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "copyToTemp", "Ljava/io/File;", "file", "importFileWithArtifactEvent", "", "sessionsManager", "Lcom/android/tools/profilers/sessions/SessionsManager;", "sessionType", "Lcom/android/tools/profiler/proto/Common$SessionData$SessionStarted$SessionType;", "makeEvent", "Lkotlin/Function2;", "", "Lcom/android/tools/profiler/proto/Common$Event;", "importFile", "makeEndedEvent", "groupId", "timeStamp", "kind", "Lcom/android/tools/profiler/proto/Common$Event$Kind;", "prepare", "Lkotlin/Function1;", "Lcom/android/tools/profiler/proto/Common$Event$Builder;", "Lkotlin/ExtensionFunctionType;", "withFileImportedOnce", "handle", "Lkotlin/Function3;", "intellij.android.profilers"})
public final class ImportedSessionUtils {
    @NotNull
    public static final ImportedSessionUtils INSTANCE = new ImportedSessionUtils();

    private ImportedSessionUtils() {
    }

    private final Logger getLogger() {
        Logger logger = Logger.getInstance(INSTANCE.getClass());
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        return logger;
    }

    private final File copyToTemp(File file) {
        File file2;
        try {
            File file3 = FileUtil.createTempFile((String)("profiler-import-" + FilesKt.getNameWithoutExtension((File)file)), (String)("." + FilesKt.getExtension((File)file)), (boolean)true);
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"createTempFile(...)");
            File tempFile = file3;
            FileUtil.copy((File)file, (File)tempFile);
        }
        catch (IOException e) {
            this.getLogger().warn("Failed to create a temporary copy of the imported file: " + file.getPath() + ". Using original file.", (Throwable)e);
            file2 = file;
        }
        return file2;
    }

    @JvmStatic
    public static final void importFileWithArtifactEvent(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType, @NotNull Function2<? super Long, ? super Long, Common.Event> makeEvent) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        Intrinsics.checkNotNullParameter(makeEvent, (String)"makeEvent");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function3<? super Long, ? super Long, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ImportedSessionUtils.importFileWithArtifactEvent$lambda$0(file, sessionsManager, sessionType, makeEvent, arg_0, arg_1, arg_2)));
    }

    @JvmStatic
    public static final void importFile(@NotNull SessionsManager sessionsManager, @NotNull File file, @NotNull Common.SessionData.SessionStarted.SessionType sessionType) {
        Intrinsics.checkNotNullParameter((Object)((Object)sessionsManager), (String)"sessionsManager");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)sessionType, (String)"sessionType");
        INSTANCE.withFileImportedOnce(sessionsManager, file, (Function3<? super Long, ? super Long, ? super Long, Unit>)((Function3)(arg_0, arg_1, arg_2) -> ImportedSessionUtils.importFile$lambda$1(file, sessionsManager, sessionType, arg_0, arg_1, arg_2)));
    }

    @JvmStatic
    @NotNull
    public static final Common.Event makeEndedEvent(long groupId, long timeStamp, @NotNull Common.Event.Kind kind, @NotNull Function1<? super Common.Event.Builder, Unit> prepare) {
        Intrinsics.checkNotNullParameter((Object)kind, (String)"kind");
        Intrinsics.checkNotNullParameter(prepare, (String)"prepare");
        Common.Event.Builder builder = Common.Event.newBuilder().setKind(kind).setGroupId(groupId).setTimestamp(timeStamp).setIsEnded(true);
        prepare.invoke((Object)builder);
        Common.Event event = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)event, (String)"build(...)");
        return event;
    }

    private final void withFileImportedOnce(SessionsManager sessionsManager, File file, Function3<? super Long, ? super Long, ? super Long, Unit> handle) {
        long startTimestampEpochNs = System.currentTimeMillis();
        Pair<Long, Long> timestampsNs = StudioProfilers.computeImportedFileStartEndTimestampsNs(file);
        Long sessionStartTimeNs = (Long)timestampsNs.first;
        Long sessionEndTimeNs = (Long)timestampsNs.second;
        StudioProfilers studioProfilers = sessionsManager.getStudioProfilers();
        Intrinsics.checkNotNullExpressionValue((Object)((Object)studioProfilers), (String)"getStudioProfilers(...)");
        StudioProfilers profilers = studioProfilers;
        if (sessionsManager.getSessionIdToSessionItems().containsKey(sessionStartTimeNs)) {
            if (profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                SessionItem sessionItem = sessionsManager.getSessionIdToSessionItems().get(sessionStartTimeNs);
                Intrinsics.checkNotNull((Object)sessionItem);
                SessionItem session = sessionItem;
                profilers.getPastRecordingsTabModel().getRecordingListModel().openRecording(session);
            } else {
                Intrinsics.checkNotNull((Object)sessionStartTimeNs);
                sessionsManager.setSessionById(sessionStartTimeNs);
            }
        } else {
            Long l = startTimestampEpochNs;
            Intrinsics.checkNotNull((Object)sessionStartTimeNs);
            Intrinsics.checkNotNull((Object)sessionEndTimeNs);
            handle.invoke((Object)l, (Object)sessionStartTimeNs, (Object)sessionEndTimeNs);
        }
    }

    private static final Unit importFileWithArtifactEvent$lambda$0(File $file, SessionsManager $sessionsManager, Common.SessionData.SessionStarted.SessionType $sessionType, Function2 $makeEvent, long startTimestampsEpochMs, long startTime, long endTime) {
        File copiedFile = INSTANCE.copyToTemp($file);
        Common.Event[] eventArray = new Common.Event[]{$makeEvent.invoke((Object)startTime, (Object)endTime)};
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((kotlin.Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)copiedFile.getAbsolutePath())), eventArray);
        return Unit.INSTANCE;
    }

    private static final Unit importFile$lambda$1(File $file, SessionsManager $sessionsManager, Common.SessionData.SessionStarted.SessionType $sessionType, long startTimestampsEpochMs, long startTime, long endTime) {
        File copiedFile = INSTANCE.copyToTemp($file);
        $sessionsManager.createImportedSession($file.getName(), $sessionType, startTime, endTime, startTimestampsEpochMs, MapsKt.mapOf((kotlin.Pair)TuplesKt.to((Object)String.valueOf(startTime), (Object)copiedFile.getAbsolutePath())), new Common.Event[0]);
        return Unit.INSTANCE;
    }
}

