/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import androidx.compose.runtime.internal.StabilityInferred;
import com.android.tools.adtui.TabularLayout;
import com.android.tools.adtui.TooltipView;
import com.android.tools.adtui.model.AspectObserver;
import com.android.tools.adtui.model.formatter.NumberFormatter;
import com.android.tools.profilers.cpu.BatteryDrainTooltip;
import com.google.common.annotations.VisibleForTesting;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\u0013\u001a\u00020\u0003H\u0014J\b\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0017H\u0002R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000e8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lcom/android/tools/profilers/cpu/BatteryDrainTooltipView;", "Lcom/android/tools/adtui/TooltipView;", "parent", "Ljavax/swing/JComponent;", "tooltip", "Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;", "<init>", "(Ljavax/swing/JComponent;Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;)V", "getTooltip", "()Lcom/android/tools/profilers/cpu/BatteryDrainTooltip;", "content", "Ljavax/swing/JPanel;", "valueLabel", "Ljavax/swing/JLabel;", "Lorg/jetbrains/annotations/NotNull;", "getValueLabel$annotations", "()V", "getValueLabel", "()Ljavax/swing/JLabel;", "createTooltip", "updateView", "", "getTitle", "", "counterName", "intellij.android.profilers.ui"})
@StabilityInferred(parameters=0)
public final class BatteryDrainTooltipView
extends TooltipView {
    @NotNull
    private final BatteryDrainTooltip tooltip;
    @NotNull
    private final JPanel content;
    @NotNull
    private final JLabel valueLabel;
    public static final int $stable = 8;

    public BatteryDrainTooltipView(@NotNull JComponent parent, @NotNull BatteryDrainTooltip tooltip) {
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)((Object)tooltip), (String)"tooltip");
        super(tooltip.getTimeline());
        this.tooltip = tooltip;
        this.content = new JPanel((LayoutManager)new TabularLayout("*").setVGap(12));
        JLabel jLabel = TooltipView.createTooltipLabel();
        Intrinsics.checkNotNullExpressionValue((Object)jLabel, (String)"createTooltipLabel(...)");
        this.valueLabel = jLabel;
        this.content.add((Component)this.valueLabel, new TabularLayout.Constraint(0, 0, 0, 4, null));
        this.tooltip.addDependency((AspectObserver)this).onChange((Enum)BatteryDrainTooltip.Aspect.VALUE_CHANGED, () -> BatteryDrainTooltipView._init_$lambda$0(this));
        this.updateView();
    }

    @NotNull
    public final BatteryDrainTooltip getTooltip() {
        return this.tooltip;
    }

    @NotNull
    public final JLabel getValueLabel() {
        return this.valueLabel;
    }

    @VisibleForTesting
    public static /* synthetic */ void getValueLabel$annotations() {
    }

    @NotNull
    protected JComponent createTooltip() {
        return this.content;
    }

    private final void updateView() {
        String string = NumberFormatter.formatInteger((Number)this.tooltip.getActiveValue());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"formatInteger(...)");
        String batteryDrainValueText = string;
        this.valueLabel.setText(this.getTitle(this.tooltip.getCounterName()) + ": " + batteryDrainValueText);
        JLabel jLabel = this.valueLabel;
        String string2 = this.tooltip.getUnit();
        jLabel.setText(jLabel.getText() + (String)(Intrinsics.areEqual((Object)string2, (Object)"\u00b5ah") || Intrinsics.areEqual((Object)string2, (Object)"\u00b5a") ? " " + this.tooltip.getUnit() : this.tooltip.getUnit()));
    }

    private final String getTitle(String counterName) {
        return counterName;
    }

    private static final void _init_$lambda$0(BatteryDrainTooltipView this$0) {
        this$0.updateView();
    }
}

