/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.Range;
import com.android.tools.profiler.proto.Commands;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profiler.proto.Transport;
import com.android.tools.profilers.ImportedSessionUtils;
import com.android.tools.profilers.ProfilerClient;
import com.android.tools.profilers.ProfilerMonitor;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StudioProfiler;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.TraceConfigOptionsUtils;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParserUtil;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuMonitor;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.config.ImportedConfiguration;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.cpu.systemtrace.AtraceExporter;
import com.android.tools.profilers.sessions.SessionsManager;
import com.android.tools.profilers.transporteventutils.TransportUtils;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfiler
implements StudioProfiler {
    @NotNull
    private final StudioProfilers profilers;

    public CpuProfiler(@NotNull StudioProfilers profilers) {
        this.profilers = profilers;
        this.registerImportedSessionListener();
        this.registerTraceImportHandler();
    }

    private void onImportSessionSelected() {
        long traceId = this.profilers.getSession().getStartTimestamp();
        this.profilers.getIdeServices().runAsync(() -> CpuCaptureStage.create(this.profilers, (ProfilingConfiguration)new ImportedConfiguration(), CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, traceId), captureStage -> {
            if (captureStage != null) {
                this.profilers.getIdeServices().getMainExecutor().execute(() -> this.profilers.setStage((Stage)((Object)captureStage)));
            } else {
                this.profilers.getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
            }
        });
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfiler.class);
    }

    private void registerImportedSessionListener() {
        this.profilers.registerSessionChangeListener(Common.SessionMetaData.SessionType.CPU_CAPTURE, this::onImportSessionSelected);
    }

    private void registerTraceImportHandler() {
        SessionsManager sessionsManager = this.profilers.getSessionsManager();
        sessionsManager.registerImportHandler("trace", this::loadCapture);
        sessionsManager.registerImportHandler("pftrace", this::loadCapture);
        sessionsManager.registerImportHandler("perfetto-trace", this::loadCapture);
    }

    private void loadCapture(File file) throws IllegalStateException {
        boolean isTaskBasedUxEnabled = this.profilers.getIdeServices().getFeatureConfig().isTaskBasedUxEnabled();
        ProfilingConfiguration.TraceType traceType = CpuCaptureParserUtil.getFileTraceType(file, ProfilingConfiguration.TraceType.UNSPECIFIED);
        if (isTaskBasedUxEnabled && (traceType == null || traceType == ProfilingConfiguration.TraceType.UNSPECIFIED)) {
            throw new IllegalStateException("Cannot import trace with type:\n" + traceType);
        }
        if (isTaskBasedUxEnabled) {
            Function2 makeEvent = (start, end) -> {
                Trace.TraceInfo.Builder importedTraceInfo = Trace.TraceInfo.newBuilder().setTraceId(start.longValue()).setFromTimestamp(start.longValue()).setToTimestamp(end.longValue());
                Trace.TraceConfiguration.Builder config = Trace.TraceConfiguration.newBuilder();
                TraceConfigOptionsUtils.addDefaultTraceOptions(config, traceType);
                importedTraceInfo.setConfiguration(config);
                return ImportedSessionUtils.makeEndedEvent(start, end, Common.Event.Kind.CPU_TRACE, (Function1<? super Common.Event.Builder, Unit>)((Function1)builder -> {
                    builder.setTraceData(Trace.TraceData.newBuilder().setTraceEnded(Trace.TraceData.TraceEnded.newBuilder().setTraceInfo(importedTraceInfo)));
                    return Unit.INSTANCE;
                }));
            };
            ImportedSessionUtils.importFileWithArtifactEvent(this.profilers.getSessionsManager(), file, Common.SessionData.SessionStarted.SessionType.CPU_CAPTURE, (Function2<? super Long, ? super Long, Common.Event>)makeEvent);
        } else {
            ImportedSessionUtils.importFile(this.profilers.getSessionsManager(), file, Common.SessionData.SessionStarted.SessionType.CPU_CAPTURE);
        }
        this.profilers.getIdeServices().getFeatureTracker().trackCreateSession(Common.SessionMetaData.SessionType.CPU_CAPTURE, SessionsManager.SessionCreationSource.MANUAL);
    }

    @Override
    @NotNull
    public ProfilerMonitor newMonitor() {
        return new CpuMonitor(this.profilers);
    }

    @Override
    public void startProfiling(@NotNull Common.Session session) {
    }

    @Override
    public void stopProfiling(@NotNull Common.Session session) {
        Trace.TraceInfo mostRecentTrace;
        List<Trace.TraceInfo> traces = CpuProfiler.getTraceInfoFromSession(this.profilers.getClient(), session);
        Trace.TraceInfo traceInfo = mostRecentTrace = traces.isEmpty() ? null : traces.get(traces.size() - 1);
        if (mostRecentTrace != null && mostRecentTrace.getToTimestamp() == -1L) {
            CpuProfiler.stopTracing(this.profilers, session, mostRecentTrace.getConfiguration(), null, null);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void saveCaptureToFile(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceInfo info, @NotNull OutputStream outputStream) {
        try {
            Transport.BytesRequest traceRequest = Transport.BytesRequest.newBuilder().setStreamId(session.getStreamId()).setId(String.valueOf(info.getTraceId())).build();
            Transport.FileResponse traceResponse = profilers.getClient().getTransportClient().getFile(traceRequest);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) == ProfilingConfiguration.TraceType.ATRACE) {
                File trace = FileUtil.createTempFile((String)String.format("cpu_trace_%d", info.getTraceId()), (String)".trace", (boolean)true);
                try (FileOutputStream out = new FileOutputStream(trace);){
                    FileUtil.copy((InputStream)new FileInputStream(traceResponse.getFilePath()), (OutputStream)out);
                }
                AtraceExporter.export(trace, outputStream);
                return;
            }
            FileUtil.copy((InputStream)new FileInputStream(traceResponse.getFilePath()), (OutputStream)outputStream);
            if (ProfilingConfiguration.TraceType.from(info.getConfiguration()) != ProfilingConfiguration.TraceType.PERFETTO) return;
        }
        catch (IOException exception) {
            CpuProfiler.getLogger().warn("Failed to export CPU trace file:\n" + exception);
        }
    }

    @NotNull
    public static String generateCaptureFileName(@NotNull ProfilingConfiguration.TraceType profilerType) {
        StringBuilder traceName = new StringBuilder(String.format("cpu-%s-", StringUtil.toLowerCase((String)profilerType.name())));
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd'T'HHmmss");
        traceName.append(LocalDateTime.now().format(formatter));
        return traceName.toString();
    }

    @NotNull
    public static List<Trace.TraceInfo> getTraceInfoFromRange(@NotNull ProfilerClient client, @NotNull Common.Session session, @NotNull Range rangeUs) {
        long rangeMinNs = rangeUs.getMin() == -9.223372036854776E18 ? Long.MIN_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMin());
        long rangeMaxNs = rangeUs.getMax() == 9.223372036854776E18 ? Long.MAX_VALUE : TimeUnit.MICROSECONDS.toNanos((long)rangeUs.getMax());
        Transport.GetEventGroupsResponse response = client.getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setKind(Common.Event.Kind.CPU_TRACE).setFromTimestamp(rangeMinNs).setToTimestamp(rangeMaxNs).build());
        return response.getGroupsList().stream().map(group -> {
            Trace.TraceInfo info;
            Common.Event event = group.getEvents(group.getEventsCount() - 1);
            Trace.TraceInfo traceInfo = info = event.getTraceData().hasTraceStarted() ? event.getTraceData().getTraceStarted().getTraceInfo() : event.getTraceData().getTraceEnded().getTraceInfo();
            if (info.equals((Object)Trace.TraceInfo.getDefaultInstance())) {
                assert (group.getEventsCount() > 1);
                info = group.getEvents(0).getTraceData().getTraceStarted().getTraceInfo();
                if (info.getToTimestamp() == -1L) {
                    info = info.toBuilder().setToTimestamp(session.getEndTimestamp()).setStopStatus(Trace.TraceStopStatus.newBuilder().setStatus(Trace.TraceStopStatus.Status.APP_PROCESS_DIED)).build();
                }
            }
            return info;
        }).sorted(Comparator.comparingLong(Trace.TraceInfo::getFromTimestamp)).collect(Collectors.toList());
    }

    @NotNull
    public static Trace.TraceInfo getTraceInfoFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.CPU_TRACE).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            return Trace.TraceInfo.getDefaultInstance();
        }
        Trace.TraceData data = response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1).getTraceData();
        if (data.hasTraceStarted()) {
            return data.getTraceStarted().getTraceInfo();
        }
        return data.getTraceEnded().getTraceInfo();
    }

    @NotNull
    public static List<Trace.TraceInfo> getTraceInfoFromSession(@NotNull ProfilerClient client, @NotNull Common.Session session) {
        return CpuProfiler.getTraceInfoFromRange(client, session, new Range(-9.223372036854776E18, 9.223372036854776E18));
    }

    @NotNull
    public static Common.Event getTraceStatusEventFromId(@NotNull StudioProfilers profilers, long traceId) {
        Transport.GetEventGroupsResponse response = profilers.getClient().getTransportClient().getEventGroups(Transport.GetEventGroupsRequest.newBuilder().setStreamId(profilers.getSession().getStreamId()).setKind(Common.Event.Kind.TRACE_STATUS).setGroupId(traceId).build());
        if (response.getGroupsCount() == 0) {
            return Common.Event.getDefaultInstance();
        }
        return response.getGroups(0).getEvents(response.getGroups(0).getEventsCount() - 1);
    }

    public static void startTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceConfiguration configuration, @NotNull Consumer<Trace.TraceStartStatus> statusResponseHandler, @Nullable Consumer<Trace.TraceInfo> cpuTraceResponseHandler) {
        Executor poolExecutor = profilers.getIdeServices().getPoolExecutor();
        Commands.Command startCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setType(Commands.Command.CommandType.START_TRACE).setStartTrace(Trace.StartTrace.newBuilder().setProfilerType(Trace.ProfilerType.CPU).setConfiguration(configuration).build()).build();
        profilers.getClient().executeAsync(startCommand, poolExecutor).thenAcceptAsync(response -> {
            Function<Common.Event, Boolean> traceStatusEventCallback = event -> {
                statusResponseHandler.accept(event.getTraceStatus().getTraceStartStatus());
                return true;
            };
            TransportUtils.registerListener(profilers, Common.Event.Kind.TRACE_STATUS, session.getStreamId(), session.getPid(), response.getCommandId(), traceStatusEventCallback);
            if (cpuTraceResponseHandler != null) {
                Function<Common.Event, Boolean> cpuTraceEventCallback = event -> {
                    if (event.getTraceData().hasTraceStarted()) {
                        cpuTraceResponseHandler.accept(event.getTraceData().getTraceStarted().getTraceInfo());
                    }
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.CPU_TRACE, session.getStreamId(), session.getPid(), response.getCommandId(), cpuTraceEventCallback);
            }
        }, poolExecutor);
    }

    public static void stopTracing(@NotNull StudioProfilers profilers, @NotNull Common.Session session, @NotNull Trace.TraceConfiguration configuration, @Nullable Consumer<Trace.TraceStopStatus> statusResponseHandler, @Nullable Consumer<Trace.TraceInfo> cpuTraceResponseHandler) {
        Executor poolExecutor = profilers.getIdeServices().getPoolExecutor();
        Commands.Command stopCommand = Commands.Command.newBuilder().setStreamId(session.getStreamId()).setPid(session.getPid()).setSessionId(session.getSessionId()).setType(Commands.Command.CommandType.STOP_TRACE).setStopTrace(Trace.StopTrace.newBuilder().setProfilerType(Trace.ProfilerType.CPU).setConfiguration(configuration).setNeedTraceResponse(statusResponseHandler != null)).build();
        profilers.getClient().executeAsync(stopCommand, poolExecutor).thenAcceptAsync(response -> {
            if (statusResponseHandler != null) {
                Function<Common.Event, Boolean> traceStatusEventCallback = event -> {
                    statusResponseHandler.accept(event.getTraceStatus().getTraceStopStatus());
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.TRACE_STATUS, session.getStreamId(), session.getPid(), response.getCommandId(), traceStatusEventCallback);
            }
            if (cpuTraceResponseHandler != null) {
                Function<Common.Event, Boolean> cpuTraceEventCallback = event -> {
                    if (event.getTraceData().hasTraceEnded()) {
                        cpuTraceResponseHandler.accept(event.getTraceData().getTraceEnded().getTraceInfo());
                    }
                    return true;
                };
                TransportUtils.registerListener(profilers, Common.Event.Kind.CPU_TRACE, session.getStreamId(), session.getPid(), response.getCommandId(), cpuTraceEventCallback);
            }
        }, poolExecutor);
    }
}

