/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.cpu;

import com.android.tools.adtui.model.AspectModel;
import com.android.tools.adtui.model.DurationDataModel;
import com.android.tools.adtui.model.EaseOutModel;
import com.android.tools.adtui.model.Interpolatable;
import com.android.tools.adtui.model.Range;
import com.android.tools.adtui.model.RangeSelectionModel;
import com.android.tools.adtui.model.SeriesData;
import com.android.tools.adtui.model.axis.AxisComponentModel;
import com.android.tools.adtui.model.axis.ClampedAxisComponentModel;
import com.android.tools.adtui.model.formatter.BaseAxisFormatter;
import com.android.tools.adtui.model.formatter.SingleUnitAxisFormatter;
import com.android.tools.adtui.model.legend.Legend;
import com.android.tools.adtui.model.legend.LegendComponentModel;
import com.android.tools.adtui.model.legend.SeriesLegend;
import com.android.tools.adtui.model.updater.Updatable;
import com.android.tools.adtui.model.updater.UpdatableManager;
import com.android.tools.idea.protobuf.GeneratedMessageV3;
import com.android.tools.idea.transport.TransportFileManager;
import com.android.tools.profiler.proto.Common;
import com.android.tools.profiler.proto.Trace;
import com.android.tools.profilers.InterimStage;
import com.android.tools.profilers.LogUtils;
import com.android.tools.profilers.ProfilerAspect;
import com.android.tools.profilers.RecordingOption;
import com.android.tools.profilers.RecordingOptionsModel;
import com.android.tools.profilers.Stage;
import com.android.tools.profilers.StreamingStage;
import com.android.tools.profilers.StudioProfilers;
import com.android.tools.profilers.cpu.CpuCaptureMetadata;
import com.android.tools.profilers.cpu.CpuCaptureParser;
import com.android.tools.profilers.cpu.CpuCaptureStage;
import com.android.tools.profilers.cpu.CpuProfiler;
import com.android.tools.profilers.cpu.CpuProfilerAspect;
import com.android.tools.profilers.cpu.CpuProfilerNotifications;
import com.android.tools.profilers.cpu.CpuThreadsModel;
import com.android.tools.profilers.cpu.CpuTraceInfo;
import com.android.tools.profilers.cpu.DetailedCpuUsage;
import com.android.tools.profilers.cpu.ProfilingTechnology;
import com.android.tools.profilers.cpu.adapters.CpuDataProvider;
import com.android.tools.profilers.cpu.config.ArtInstrumentedConfiguration;
import com.android.tools.profilers.cpu.config.CpuProfilerConfigModel;
import com.android.tools.profilers.cpu.config.ProfilingConfiguration;
import com.android.tools.profilers.event.EventMonitor;
import com.android.tools.profilers.taskbased.task.interim.RecordingScreenModel;
import com.android.tools.profilers.tasks.TaskEventTrackerUtils;
import com.android.tools.profilers.tasks.TaskStartFailedMetadata;
import com.android.tools.profilers.tasks.TaskStopFailedMetadata;
import com.google.common.annotations.VisibleForTesting;
import com.google.wireless.android.sdk.stats.AndroidProfilerEvent;
import com.intellij.openapi.diagnostic.Logger;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CpuProfilerStage
extends StreamingStage
implements InterimStage {
    private static final String HAS_USED_CPU_CAPTURE = "cpu.used.capture";
    private static final SingleUnitAxisFormatter CPU_USAGE_FORMATTER = new SingleUnitAxisFormatter(1, 5, 10, "%");
    private static final SingleUnitAxisFormatter NUM_THREADS_AXIS = new SingleUnitAxisFormatter(1, 5, 1, "");
    public static final int CPU_ART_STOP_TIMEOUT_SEC = Math.max(5, Math.min(Integer.getInteger("profiler.cpu.art.stop.timeout.sec", 10), 300));
    @VisibleForTesting
    static final ProfilingConfiguration API_INITIATED_TRACING_PROFILING_CONFIG = new ArtInstrumentedConfiguration("API tracing");
    private final CpuDataProvider myCpuDataProvider;
    private final CpuProfilerConfigModel myProfilerConfigModel;
    @NotNull
    private final RecordingOptionsModel myRecordingOptionsModel;
    @NotNull
    private CaptureState myCaptureState;
    private long myCaptureStartTimeNs;
    private long myCaptureStopTimeNs;
    private final InProgressTraceHandler myInProgressTraceHandler;
    @NotNull
    private Trace.TraceInfo myInProgressTraceInfo = Trace.TraceInfo.getDefaultInstance();
    private final CpuCaptureParser myCaptureParser;
    @NotNull
    private final Common.Session mySession;
    private final Map<Long, CpuTraceInfo> myCompletedTraceIdToInfoMap = new HashMap<Long, CpuTraceInfo>();
    private final CpuCaptureMetadata.CpuProfilerEntryPoint myEntryPoint;
    private final boolean isTraceboxEnabled;
    @NotNull
    private final Runnable myStopAction;
    @Nullable
    private final RecordingScreenModel<CpuProfilerStage> myRecordingScreenModel;

    public CpuProfilerStage(@NotNull StudioProfilers profilers) {
        this(profilers, new CpuCaptureParser(profilers), CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, () -> {});
    }

    @VisibleForTesting
    public CpuProfilerStage(@NotNull StudioProfilers profilers, @NotNull CpuCaptureParser captureParser) {
        this(profilers, captureParser, CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, () -> {});
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, @NotNull Runnable stopAction) {
        this(profilers, new CpuCaptureParser(profilers), CpuCaptureMetadata.CpuProfilerEntryPoint.UNKNOWN, stopAction);
    }

    public CpuProfilerStage(@NotNull StudioProfilers profilers, CpuCaptureMetadata.CpuProfilerEntryPoint entryPoint) {
        this(profilers, new CpuCaptureParser(profilers), entryPoint, () -> {});
    }

    private CpuProfilerStage(@NotNull StudioProfilers profilers, @NotNull CpuCaptureParser captureParser, CpuCaptureMetadata.CpuProfilerEntryPoint entryPoint, @NotNull Runnable stopAction) {
        super(profilers);
        this.mySession = profilers.getSession();
        this.myCpuDataProvider = new CpuDataProvider(profilers, this.getTimeline());
        this.myProfilerConfigModel = new CpuProfilerConfigModel(profilers, this);
        this.myRecordingOptionsModel = new RecordingOptionsModel();
        this.myCaptureState = CaptureState.IDLE;
        this.myCaptureParser = captureParser;
        this.myEntryPoint = entryPoint;
        this.myStopAction = stopAction;
        this.myRecordingScreenModel = this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() ? new RecordingScreenModel<CpuProfilerStage>(this) : null;
        List<Trace.TraceInfo> existingCompletedTraceInfoList = CpuProfiler.getTraceInfoFromSession(this.getStudioProfilers().getClient(), this.mySession).stream().filter(info -> info.getToTimestamp() != -1L).collect(Collectors.toList());
        existingCompletedTraceInfoList.forEach(info -> this.myCompletedTraceIdToInfoMap.put(info.getTraceId(), new CpuTraceInfo((Trace.TraceInfo)info)));
        this.myInProgressTraceHandler = new InProgressTraceHandler();
        this.isTraceboxEnabled = this.getStudioProfilers().getIdeServices().getFeatureConfig().isTraceboxEnabled();
    }

    private static Logger getLogger() {
        return Logger.getInstance(CpuProfilerStage.class);
    }

    public boolean hasUserUsedCpuCapture() {
        return this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().getBoolean(HAS_USED_CPU_CAPTURE, false);
    }

    @NotNull
    public RangeSelectionModel getRangeSelectionModel() {
        return this.myCpuDataProvider.getRangeSelectionModel();
    }

    @NotNull
    public EaseOutModel getInstructionsEaseOutModel() {
        return this.myCpuDataProvider.getInstructionsEaseOutModel();
    }

    public AxisComponentModel getCpuUsageAxis() {
        return this.myCpuDataProvider.getCpuUsageAxis();
    }

    public AxisComponentModel getThreadCountAxis() {
        return this.myCpuDataProvider.getThreadCountAxis();
    }

    public AxisComponentModel getTimeAxisGuide() {
        return this.myCpuDataProvider.getTimeAxisGuide();
    }

    public DetailedCpuUsage getCpuUsage() {
        return this.myCpuDataProvider.getCpuUsage();
    }

    public CpuStageLegends getLegends() {
        return this.myCpuDataProvider.getLegends();
    }

    public DurationDataModel<CpuTraceInfo> getTraceDurations() {
        return this.myCpuDataProvider.getTraceDurations();
    }

    public String getName() {
        return "CPU";
    }

    public EventMonitor getEventMonitor() {
        return this.myCpuDataProvider.getEventMonitor();
    }

    public RecordingOptionsModel getRecordingModel() {
        return this.myRecordingOptionsModel;
    }

    @NotNull
    public CpuProfilerConfigModel getProfilerConfigModel() {
        return this.myProfilerConfigModel;
    }

    public CpuCaptureMetadata.CpuProfilerEntryPoint getEntryPoint() {
        return this.myEntryPoint;
    }

    @Override
    @NotNull
    public Runnable getStopAction() {
        return this.myStopAction;
    }

    @Nullable
    public RecordingScreenModel<CpuProfilerStage> getRecordingScreenModel() {
        return this.myRecordingScreenModel;
    }

    @Override
    public void enter() {
        this.logEnterStage();
        this.getEventMonitor().enter();
        this.getStudioProfilers().getUpdater().register((Updatable)this.getCpuUsage());
        this.getStudioProfilers().getUpdater().register(this.getTraceDurations());
        this.getStudioProfilers().getUpdater().register((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().register((Updatable)((ClampedAxisComponentModel)this.getCpuUsageAxis()));
        this.getStudioProfilers().getUpdater().register((Updatable)((ClampedAxisComponentModel)this.getThreadCountAxis()));
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.myRecordingScreenModel != null) {
            this.getStudioProfilers().getUpdater().register(this.myRecordingScreenModel);
        }
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackEnterStage(this.getStageType());
        this.getStudioProfilers().addDependency(this).onChange((Enum)ProfilerAspect.PROCESSES, this.myProfilerConfigModel::updateProfilingConfigurations);
        this.myProfilerConfigModel.updateProfilingConfigurations();
        this.setupRecordingOptions();
    }

    @Override
    public void exit() {
        this.getEventMonitor().exit();
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.getCpuUsage());
        this.getStudioProfilers().getUpdater().unregister(this.getTraceDurations());
        this.getStudioProfilers().getUpdater().unregister((Updatable)this.myInProgressTraceHandler);
        this.getStudioProfilers().getUpdater().unregister((Updatable)((ClampedAxisComponentModel)this.getCpuUsageAxis()));
        this.getStudioProfilers().getUpdater().unregister((Updatable)((ClampedAxisComponentModel)this.getThreadCountAxis()));
        if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() && this.myRecordingScreenModel != null) {
            this.getStudioProfilers().getUpdater().unregister(this.myRecordingScreenModel);
        }
        this.myCaptureParser.abortParsing();
        this.getRangeSelectionModel().clearListeners();
        this.getUpdatableManager().releaseAll();
    }

    @Override
    public AndroidProfilerEvent.Stage getStageType() {
        return AndroidProfilerEvent.Stage.CPU_STAGE;
    }

    @NotNull
    public UpdatableManager getUpdatableManager() {
        return this.myCpuDataProvider.getUpdatableManager();
    }

    public AspectModel<CpuProfilerAspect> getAspect() {
        return this.myCpuDataProvider.getAspect();
    }

    public void toggleCapturing() {
        if (this.myCaptureState == CaptureState.CAPTURING) {
            this.stopCapturing();
        } else {
            this.startCapturing();
        }
    }

    public void startCapturing() {
        LogUtils.log(this.getClass(), "CPU capture start attempted");
        ProfilingConfiguration config = this.myProfilerConfigModel.getProfilingConfiguration();
        assert (this.getStudioProfilers().getProcess() != null);
        Common.Process process = this.getStudioProfilers().getProcess();
        String traceFilePath = String.format(Locale.US, "%s/%s-%d.trace", "/data/local/tmp/perfd", process.getName(), System.nanoTime());
        this.setCaptureState(CaptureState.STARTING);
        Trace.TraceConfiguration.Builder configurationBuilder = Trace.TraceConfiguration.newBuilder().setAppName(process.getName()).setAbiCpuArch(TransportFileManager.getShortAbiName((String)this.getStudioProfilers().getDevice().getCpuAbi())).setInitiationType(Trace.TraceInitiationType.INITIATED_BY_UI).setTempPath(traceFilePath);
        config.addOptions(configurationBuilder, Map.of(ProfilingConfiguration.AdditionalOptions.APP_PKG_NAME, process.getName(), ProfilingConfiguration.AdditionalOptions.SYMBOL_DIRS, this.getStudioProfilers().getIdeServices().getNativeSymbolsDirectories()));
        Trace.TraceConfiguration configuration = configurationBuilder.build();
        CpuProfiler.startTracing(this.getStudioProfilers(), this.mySession, configuration, this::startCapturingCallback, null);
        this.getStudioProfilers().getIdeServices().getTemporaryProfilerPreferences().setBoolean(HAS_USED_CPU_CAPTURE, true);
        this.getInstructionsEaseOutModel().setCurrentRatio(1.0f);
    }

    private void startCapturingCallback(@NotNull Trace.TraceStartStatus status) {
        if (status.getStatus().equals((Object)Trace.TraceStartStatus.Status.SUCCESS)) {
            LogUtils.log(this.getClass(), "CPU capture start succeeded");
            this.myCaptureStartTimeNs = this.currentTimeNs();
            this.setCaptureState(CaptureState.CAPTURING);
            this.getTimeline().setStreaming(true);
        } else {
            CpuProfilerStage.getLogger().warn("Unable to start tracing: " + status.getStatus() + " due to error code " + status.getErrorCode());
            this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.CAPTURE_START_FAILURE);
            this.setCaptureState(CaptureState.IDLE);
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                TaskEventTrackerUtils.trackStartTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStartFailedMetadata(status, null, null));
            }
        }
    }

    @VisibleForTesting
    void stopCapturing() {
        LogUtils.log(this.getClass(), "CPU capture stop attempted");
        if (Trace.TraceInfo.getDefaultInstance().equals((Object)this.myInProgressTraceInfo)) {
            return;
        }
        this.myCaptureStopTimeNs = this.currentTimeNs();
        this.setCaptureState(CaptureState.STOPPING);
        CpuProfiler.stopTracing(this.getStudioProfilers(), this.mySession, this.myInProgressTraceInfo.getConfiguration(), this::stopCapturingCallback, null);
    }

    public long getCaptureStartTimeNs() {
        return this.myCaptureStartTimeNs;
    }

    public long getCaptureStopTimeNs() {
        return this.myCaptureStopTimeNs;
    }

    private void stopCapturingCallback(@NotNull Trace.TraceStopStatus status) {
        this.myRecordingOptionsModel.setFinished();
        if (!status.getStatus().equals((Object)Trace.TraceStopStatus.Status.UNSPECIFIED) && !status.getStatus().equals((Object)Trace.TraceStopStatus.Status.SUCCESS)) {
            CpuCaptureMetadata captureMetadata = this.trackAndLogTraceStopFailures(status);
            if (this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled()) {
                TaskEventTrackerUtils.trackStopTaskFailed(this.getStudioProfilers(), this.getStudioProfilers().getSessionsManager().isSessionAlive(), new TaskStopFailedMetadata(null, null, captureMetadata));
            }
            this.setCaptureState(CaptureState.IDLE);
        }
    }

    private CpuCaptureMetadata trackAndLogTraceStopFailures(@NotNull Trace.TraceStopStatus status) {
        CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(this.myProfilerConfigModel.getProfilingConfiguration());
        long estimateDurationMs = TimeUnit.NANOSECONDS.toMillis(this.currentTimeNs() - this.myCaptureStartTimeNs);
        captureMetadata.setCaptureDurationMs(estimateDurationMs);
        captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(status.getStoppingDurationNs()));
        captureMetadata.setStatus(CpuCaptureMetadata.CaptureStatus.fromStopStatus(status.getStatus()));
        captureMetadata.setCpuProfilerEntryPoint(this.myEntryPoint);
        if (captureMetadata.getProfilingConfiguration().getTraceType() == ProfilingConfiguration.TraceType.ART) {
            captureMetadata.setArtStopTimeoutSec(CPU_ART_STOP_TIMEOUT_SEC);
        }
        this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCaptureTrace(captureMetadata);
        CpuProfilerStage.getLogger().warn("Unable to stop tracing: " + status.getStatus() + " error code " + status.getErrorCode());
        this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.getCaptureStopFailure(status.getStatus().toString()));
        return captureMetadata;
    }

    private void goToCaptureStage(long traceId) {
        if (this.myCompletedTraceIdToInfoMap.containsKey(traceId)) {
            this.getStudioProfilers().getIdeServices().runAsync(() -> {
                this.myRecordingOptionsModel.setLoading(true);
                return CpuCaptureStage.create(this.getStudioProfilers(), ProfilingConfiguration.fromProto(this.myCompletedTraceIdToInfoMap.get(traceId).getTraceInfo().getConfiguration(), this.isTraceboxEnabled), this.myEntryPoint, traceId);
            }, stage -> {
                this.myRecordingOptionsModel.setLoading(false);
                if (stage != null) {
                    this.getStudioProfilers().getIdeServices().getMainExecutor().execute(() -> this.getStudioProfilers().setStage((Stage)((Object)stage)));
                } else {
                    this.setCaptureState(CaptureState.IDLE);
                    this.getStudioProfilers().getIdeServices().showNotification(CpuProfilerNotifications.IMPORT_TRACE_PARSING_FAILURE);
                }
            }, 300000L);
        }
    }

    @NotNull
    public CpuCaptureParser getCaptureParser() {
        return this.myCaptureParser;
    }

    @Nullable
    public CpuTraceInfo getIntersectingTraceInfo(Range range) {
        List infoList = this.getTraceDurations().getSeries().getSeriesForRange(range);
        for (SeriesData info : infoList) {
            Range captureRange = ((CpuTraceInfo)info.value).getRange();
            if (!captureRange.intersectsWith(range)) continue;
            return (CpuTraceInfo)info.value;
        }
        return null;
    }

    public long currentTimeNs() {
        return TimeUnit.MICROSECONDS.toNanos((long)this.getTimeline().getDataRange().getMax());
    }

    public void setAndSelectCapture(long traceId) {
        this.goToCaptureStage(traceId);
    }

    public int getSelectedThread() {
        return this.getThreadStates().getThread();
    }

    public void setSelectedThread(int id) {
        this.getThreadStates().setThread(id);
        Range range = this.getTimeline().getSelectionRange();
        if (range.isEmpty()) {
            this.getAspect().changed((Enum)CpuProfilerAspect.SELECTED_THREADS);
        }
    }

    @NotNull
    public CaptureState getCaptureState() {
        return this.myCaptureState;
    }

    @NotNull
    public Trace.TraceInitiationType getCaptureInitiationType() {
        return this.myInProgressTraceInfo.getConfiguration().getInitiationType();
    }

    public void setCaptureState(@NotNull CaptureState captureState) {
        if (!this.myCaptureState.equals((Object)captureState)) {
            this.myCaptureState = captureState;
            this.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_STATE);
            if (captureState == CaptureState.CAPTURING) {
                if (!this.myRecordingOptionsModel.isRecording()) {
                    if (this.isApiInitiatedTracingInProgress()) {
                        RecordingOption option2 = this.addConfiguration(API_INITIATED_TRACING_PROFILING_CONFIG);
                        this.myRecordingOptionsModel.getCustomConfigurationModel().setSelectedItem(option2);
                        this.myRecordingOptionsModel.selectCurrentCustomConfiguration();
                    } else if (this.getCaptureInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_STARTUP)) {
                        this.myRecordingOptionsModel.selectOptionBy((Function1<? super RecordingOption, Boolean>)((Function1)option -> option.getTitle().equals(this.myProfilerConfigModel.getProfilingConfiguration().getName())));
                    }
                }
                this.myRecordingOptionsModel.setRecording();
            }
        }
    }

    public boolean isApiInitiatedTracingInProgress() {
        return this.myCaptureState == CaptureState.CAPTURING && this.getCaptureInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_API);
    }

    @NotNull
    public CpuDataProvider.CpuTraceDataSeries getCpuTraceDataSeries() {
        return this.myCpuDataProvider.getCpuTraceDataSeries();
    }

    @NotNull
    public CpuThreadsModel getThreadStates() {
        return this.myCpuDataProvider.getThreadStates();
    }

    public void refreshRecordingConfigurations() {
        this.myRecordingOptionsModel.clearConfigurations();
        this.myProfilerConfigModel.getCustomProfilingConfigurationsDeviceFiltered().forEach(this::addConfiguration);
    }

    private RecordingOption addConfiguration(ProfilingConfiguration config) {
        RecordingOption option = new RecordingOption(config.getName(), "", () -> this.startRecordingConfig(config), this::stopCapturing);
        this.myRecordingOptionsModel.addConfigurations(option);
        return option;
    }

    private void startRecordingConfig(ProfilingConfiguration config) {
        this.myProfilerConfigModel.setProfilingConfiguration(config);
        this.startCapturing();
    }

    public void startCpuRecording() {
        this.getRecordingModel().start();
    }

    public void stopCpuRecording() {
        this.getRecordingModel().stop();
    }

    private void setupRecordingOptions() {
        List<ProfilingConfiguration> configurations = this.getStudioProfilers().getIdeServices().getFeatureConfig().isTaskBasedUxEnabled() ? this.myProfilerConfigModel.getTaskProfilingConfigurations() : this.myProfilerConfigModel.getDefaultProfilingConfigurations();
        for (ProfilingConfiguration configuration : configurations) {
            ProfilingTechnology tech = ProfilingTechnology.fromConfig(configuration);
            this.myRecordingOptionsModel.addBuiltInOptions(new RecordingOption(configuration.getName(), tech.getDescription(), () -> this.startRecordingConfig(configuration), this::stopCapturing));
        }
        this.refreshRecordingConfigurations();
        this.myRecordingOptionsModel.selectOptionBy((Function1<? super RecordingOption, Boolean>)((Function1)recordingOption -> recordingOption.getTitle().equals(this.myProfilerConfigModel.getProfilingConfiguration().getName())));
    }

    public static enum CaptureState {
        IDLE,
        CAPTURING,
        STARTING,
        STOPPING;

    }

    private class InProgressTraceHandler
    implements Updatable {
        private InProgressTraceHandler() {
        }

        public void update(long elapsedNs) {
            if (CpuProfilerStage.this.getCaptureParser().isParsing()) {
                CpuProfilerStage.this.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            Trace.TraceInfo finishedTraceToSelect = null;
            Range dataRange = CpuProfilerStage.this.getTimeline().getDataRange();
            List<Trace.TraceInfo> traceInfoList = CpuProfiler.getTraceInfoFromRange(CpuProfilerStage.this.getStudioProfilers().getClient(), CpuProfilerStage.this.mySession, dataRange);
            for (int i = 0; i < traceInfoList.size(); ++i) {
                Trace.TraceInfo trace = traceInfoList.get(i);
                if (trace.getToTimestamp() == -1L) {
                    assert (i == traceInfoList.size() - 1);
                    finishedTraceToSelect = null;
                    this.handleInProgressTrace(trace);
                    break;
                }
                if (CpuProfilerStage.this.myCompletedTraceIdToInfoMap.containsKey(trace.getTraceId())) continue;
                CpuProfilerStage.this.myCompletedTraceIdToInfoMap.put(trace.getTraceId(), new CpuTraceInfo(trace));
                finishedTraceToSelect = trace;
                if (trace.getConfiguration().getInitiationType().equals((Object)Trace.TraceInitiationType.INITIATED_BY_API)) {
                    CpuCaptureMetadata metadata = new CpuCaptureMetadata(API_INITIATED_TRACING_PROFILING_CONFIG);
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), metadata);
                    CpuProfilerStage.this.getStudioProfilers().getIdeServices().getFeatureTracker().trackCpuApiTracing(false, true, -1, -1, -1);
                }
                if (trace.getStopStatus().getStatus().equals((Object)Trace.TraceStopStatus.Status.SUCCESS)) {
                    LogUtils.log(this.getClass(), "CPU capture stop succeeded");
                    CpuCaptureMetadata captureMetadata = new CpuCaptureMetadata(ProfilingConfiguration.fromProto(finishedTraceToSelect.getConfiguration(), CpuProfilerStage.this.isTraceboxEnabled));
                    captureMetadata.setCaptureDurationMs(TimeUnit.NANOSECONDS.toMillis(trace.getToTimestamp() - trace.getFromTimestamp()));
                    captureMetadata.setStoppingTimeMs((int)TimeUnit.NANOSECONDS.toMillis(trace.getStopStatus().getStoppingDurationNs()));
                    captureMetadata.setCpuProfilerEntryPoint(CpuProfilerStage.this.myEntryPoint);
                    CpuProfilerStage.this.myCaptureParser.trackCaptureMetadata(trace.getTraceId(), captureMetadata);
                    continue;
                }
                CpuProfilerStage.this.trackAndLogTraceStopFailures(trace.getStopStatus());
            }
            if (finishedTraceToSelect != null) {
                CpuProfilerStage.this.myInProgressTraceInfo = Trace.TraceInfo.getDefaultInstance();
                if (finishedTraceToSelect.getStopStatus().getStatus() == Trace.TraceStopStatus.Status.SUCCESS) {
                    CpuProfilerStage.this.setAndSelectCapture(finishedTraceToSelect.getTraceId());
                    CpuProfilerStage.this.getStudioProfilers().getSessionsManager().registerSelectedArtifactProto((GeneratedMessageV3)finishedTraceToSelect);
                } else {
                    CpuProfilerStage.this.setCaptureState(CaptureState.IDLE);
                }
                CpuProfilerStage.this.getAspect().changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            }
        }

        private void handleInProgressTrace(@NotNull Trace.TraceInfo traceInfo) {
            if (traceInfo.equals((Object)CpuProfilerStage.this.myInProgressTraceInfo)) {
                CpuProfilerStage.this.getAspect().changed((Enum)CpuProfilerAspect.CAPTURE_ELAPSED_TIME);
                return;
            }
            CpuProfilerStage.this.myInProgressTraceInfo = traceInfo;
            CaptureState state = CaptureState.CAPTURING;
            CpuProfilerStage.this.myCaptureStartTimeNs = CpuProfilerStage.this.myInProgressTraceInfo.getFromTimestamp();
            Common.Event statusEvent = CpuProfiler.getTraceStatusEventFromId(CpuProfilerStage.this.getStudioProfilers(), CpuProfilerStage.this.myInProgressTraceInfo.getTraceId());
            if (statusEvent.getKind() == Common.Event.Kind.TRACE_STATUS && statusEvent.getTraceStatus().hasTraceStopStatus()) {
                state = CaptureState.STOPPING;
                CpuProfilerStage.this.myCaptureStopTimeNs = statusEvent.getTimestamp();
            }
            if (CpuProfilerStage.this.myInProgressTraceInfo.getConfiguration().getInitiationType() == Trace.TraceInitiationType.INITIATED_BY_API) {
                CpuProfilerStage.this.getAspect().changed((Enum)CpuProfilerAspect.PROFILING_CONFIGURATION);
            } else {
                CpuProfilerStage.this.myProfilerConfigModel.setProfilingConfiguration(ProfilingConfiguration.fromProto(traceInfo.getConfiguration(), CpuProfilerStage.this.isTraceboxEnabled));
            }
            CpuProfilerStage.this.setCaptureState(state);
            CpuProfilerStage.this.getTimeline().setStreaming(true);
        }
    }

    public static class CpuStageLegends
    extends LegendComponentModel {
        @NotNull
        private final SeriesLegend myCpuLegend;
        @NotNull
        private final SeriesLegend myOthersLegend;
        @NotNull
        private final SeriesLegend myThreadsLegend;

        public CpuStageLegends(@NotNull DetailedCpuUsage cpuUsage, @NotNull Range dataRange) {
            super(dataRange);
            this.myCpuLegend = new SeriesLegend(cpuUsage.getCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myOthersLegend = new SeriesLegend(cpuUsage.getOtherCpuSeries(), (BaseAxisFormatter)CPU_USAGE_FORMATTER, dataRange);
            this.myThreadsLegend = new SeriesLegend(cpuUsage.getThreadsCountSeries(), (BaseAxisFormatter)NUM_THREADS_AXIS, dataRange, Interpolatable.SteppedLineInterpolator);
            this.myCpuLegend.setCachingLastValue(true);
            this.myOthersLegend.setCachingLastValue(true);
            this.add((Legend)this.myCpuLegend);
            this.add((Legend)this.myOthersLegend);
            this.add((Legend)this.myThreadsLegend);
        }

        @NotNull
        public SeriesLegend getCpuLegend() {
            return this.myCpuLegend;
        }

        @NotNull
        public SeriesLegend getOthersLegend() {
            return this.myOthersLegend;
        }

        @NotNull
        public SeriesLegend getThreadsLegend() {
            return this.myThreadsLegend;
        }
    }
}

