/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory;

import com.android.tools.adtui.common.ColumnTreeBuilder;
import com.android.tools.profilers.ProfilerLayout;
import com.android.tools.profilers.memory.MemoryObjectTreeNode;
import com.android.tools.profilers.memory.adapters.MemoryObject;
import com.intellij.ui.ColoredTreeCellRenderer;
import java.util.Comparator;
import java.util.function.Supplier;
import javax.swing.SortOrder;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

class AttributeColumn<T extends MemoryObject> {
    private final String myName;
    private final Supplier<ColoredTreeCellRenderer> myRendererSuppier;
    private final int myHeaderAlignment;
    private final int myPreferredWidth;
    private final int myMaxWidth;
    private final SortOrder mySortOrderPreference;
    private final Comparator<MemoryObjectTreeNode<T>> myComparator;

    public AttributeColumn(@NotNull String name, @NotNull Supplier<ColoredTreeCellRenderer> rendererSupplier, int headerAlignment, int preferredWidth, @NotNull SortOrder sortOrderPreference, @NotNull Comparator<MemoryObjectTreeNode<T>> comparator) {
        this(name, rendererSupplier, headerAlignment, preferredWidth, Integer.MAX_VALUE, sortOrderPreference, comparator);
    }

    public AttributeColumn(@NotNull String name, @NotNull Supplier<ColoredTreeCellRenderer> rendererSupplier, int headerAlignment, int preferredWidth, int maxWidth, @NotNull SortOrder sortOrderPreference, @NotNull Comparator<MemoryObjectTreeNode<T>> comparator) {
        this.myName = name;
        this.myRendererSuppier = rendererSupplier;
        this.myHeaderAlignment = headerAlignment;
        this.myPreferredWidth = preferredWidth;
        this.myMaxWidth = maxWidth;
        this.mySortOrderPreference = sortOrderPreference;
        this.myComparator = comparator;
    }

    @NotNull
    public ColumnTreeBuilder.ColumnBuilder getBuilder() {
        Border border = this.myHeaderAlignment == 2 ? ProfilerLayout.TABLE_COLUMN_HEADER_BORDER : ProfilerLayout.TABLE_COLUMN_RIGHT_ALIGNED_HEADER_BORDER;
        return new ColumnTreeBuilder.ColumnBuilder().setName(this.myName).setRenderer(this.myRendererSuppier.get()).setHeaderAlignment(this.myHeaderAlignment).setPreferredWidth(this.myPreferredWidth).setMaxWidth(this.myMaxWidth).setSortOrderPreference(this.mySortOrderPreference).setComparator(this.myComparator).setHeaderBorder(border);
    }

    public Comparator<MemoryObjectTreeNode<T>> getComparator() {
        return this.myComparator;
    }
}

