/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.profilers.memory.adapters;

import com.android.tools.idea.codenavigation.CodeLocation;
import com.android.tools.inspectors.common.api.stacktrace.ThreadId;
import com.android.tools.profiler.proto.Memory;
import com.android.tools.profilers.memory.adapters.ClassDb;
import com.android.tools.profilers.memory.adapters.InstanceObject;
import com.android.tools.profilers.memory.adapters.JniReferenceInstanceObject;
import com.android.tools.profilers.memory.adapters.LiveAllocationCaptureObject;
import com.android.tools.profilers.memory.adapters.ValueObject;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000p\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\u0010\b\u001a\u0004\u0018\u00010\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\b\u0010\u0017\u001a\u00020\u000bH\u0016J\u000e\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u000bJ\u000e\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0012\u001a\u00020\u000bJ\b\u0010\u001b\u001a\u00020\u000bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\b\u0010\u001e\u001a\u00020\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u001dH\u0016J\b\u0010 \u001a\u00020!H\u0016J\b\u0010\"\u001a\u00020\rH\u0016J\b\u0010#\u001a\u00020\rH\u0016J\n\u0010$\u001a\u0004\u0018\u00010\tH\u0016J\u0018\u0010%\u001a\u0012\u0012\u000e\u0012\f0'\u00a2\u0006\u0002\b(\u00a2\u0006\u0002\b)0&H\u0016J\b\u0010*\u001a\u00020\u0007H\u0016J\b\u0010+\u001a\u00020\u0005H\u0016J\b\u0010,\u001a\u00020\u0011H\u0016J\r\u0010-\u001a\u00070!\u00a2\u0006\u0002\b(H\u0016J\u0010\u0010.\u001a\u0004\u0018\u00010\u00162\u0006\u0010/\u001a\u00020\u000bJ\u000e\u00100\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0016J\u000e\u00102\u001a\u00020\u00192\u0006\u00101\u001a\u00020\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0014\u001a\n\u0012\u0004\u0012\u00020\u0016\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject;", "Lcom/android/tools/profilers/memory/adapters/InstanceObject;", "captureObject", "Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject;", "classEntry", "Lcom/android/tools/profilers/memory/adapters/ClassDb$ClassEntry;", "threadId", "Lcom/android/tools/inspectors/common/api/stacktrace/ThreadId;", "callstack", "Lcom/android/tools/profiler/proto/Memory$AllocationStack;", "size", "", "heapId", "", "<init>", "(Lcom/android/tools/profilers/memory/adapters/LiveAllocationCaptureObject;Lcom/android/tools/profilers/memory/adapters/ClassDb$ClassEntry;Lcom/android/tools/inspectors/common/api/stacktrace/ThreadId;Lcom/android/tools/profiler/proto/Memory$AllocationStack;JI)V", "valueType", "Lcom/android/tools/profilers/memory/adapters/ValueObject$ValueType;", "allocTime", "deallocTime", "jniRefs", "Lit/unimi/dsi/fastutil/longs/Long2ObjectOpenHashMap;", "Lcom/android/tools/profilers/memory/adapters/JniReferenceInstanceObject;", "getAllocTime", "setDeallocTime", "", "setAllocationTime", "getDeallocTime", "hasTimeData", "", "hasAllocTime", "hasDeallocTime", "getName", "", "getHeapId", "getShallowSize", "getAllocationCallStack", "getAllocationCodeLocations", "", "Lcom/android/tools/idea/codenavigation/CodeLocation;", "Lorg/jetbrains/annotations/NotNull;", "Lkotlin/jvm/internal/EnhancedNullability;", "getAllocationThreadId", "getClassEntry", "getValueType", "getValueText", "getJniRefByValue", "refValue", "addJniRef", "ref", "removeJniRef", "intellij.android.profilers"})
@SourceDebugExtension(value={"SMAP\nLiveAllocationInstanceObject.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiveAllocationInstanceObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1557#2:86\n1628#2,3:87\n*S KotlinDebug\n*F\n+ 1 LiveAllocationInstanceObject.kt\ncom/android/tools/profilers/memory/adapters/LiveAllocationInstanceObject\n*L\n60#1:86\n60#1:87,3\n*E\n"})
public final class LiveAllocationInstanceObject
implements InstanceObject {
    @NotNull
    private final LiveAllocationCaptureObject captureObject;
    @NotNull
    private final ClassDb.ClassEntry classEntry;
    @NotNull
    private final ThreadId threadId;
    @Nullable
    private final Memory.AllocationStack callstack;
    private final long size;
    private final int heapId;
    @NotNull
    private final ValueObject.ValueType valueType;
    private long allocTime;
    private long deallocTime;
    @Nullable
    private Long2ObjectOpenHashMap<JniReferenceInstanceObject> jniRefs;

    public LiveAllocationInstanceObject(@NotNull LiveAllocationCaptureObject captureObject, @NotNull ClassDb.ClassEntry classEntry, @NotNull ThreadId threadId, @Nullable Memory.AllocationStack callstack, long size, int heapId) {
        ValueObject.ValueType valueType;
        Intrinsics.checkNotNullParameter((Object)captureObject, (String)"captureObject");
        Intrinsics.checkNotNullParameter((Object)classEntry, (String)"classEntry");
        Intrinsics.checkNotNullParameter((Object)threadId, (String)"threadId");
        this.captureObject = captureObject;
        this.classEntry = classEntry;
        this.threadId = threadId;
        this.callstack = callstack;
        this.size = size;
        this.heapId = heapId;
        if (Intrinsics.areEqual((Object)this.classEntry.getClassName(), (Object)"java.lang.String")) {
            valueType = ValueObject.ValueType.STRING;
        } else {
            String string = this.classEntry.getClassName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getClassName(...)");
            valueType = StringsKt.endsWith$default((String)string, (String)"[]", (boolean)false, (int)2, null) ? ValueObject.ValueType.ARRAY : ValueObject.ValueType.OBJECT;
        }
        this.valueType = valueType;
        this.allocTime = Long.MIN_VALUE;
        this.deallocTime = Long.MAX_VALUE;
    }

    @Override
    public long getAllocTime() {
        return this.allocTime;
    }

    public final void setDeallocTime(long deallocTime) {
        this.deallocTime = deallocTime;
    }

    public final void setAllocationTime(long allocTime) {
        this.allocTime = allocTime;
    }

    @Override
    public long getDeallocTime() {
        return this.deallocTime;
    }

    @Override
    public boolean hasTimeData() {
        return this.hasAllocTime() || this.hasDeallocTime();
    }

    @Override
    public boolean hasAllocTime() {
        return this.allocTime != Long.MIN_VALUE;
    }

    @Override
    public boolean hasDeallocTime() {
        return this.deallocTime != Long.MAX_VALUE;
    }

    @Override
    @NotNull
    public String getName() {
        return "";
    }

    @Override
    public int getHeapId() {
        return this.heapId;
    }

    @Override
    public int getShallowSize() {
        return (int)this.size;
    }

    @Override
    @Nullable
    public Memory.AllocationStack getAllocationCallStack() {
        return this.callstack;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public List<CodeLocation> getAllocationCodeLocations() {
        List list;
        Memory.AllocationStack allocationStack = this.callstack;
        Object object = allocationStack != null ? allocationStack.getFrameCase() : null;
        if ((object == null ? -1 : WhenMappings.$EnumSwitchMapping$0[object.ordinal()]) == 1) {
            void $this$mapTo$iv$iv;
            List list2 = this.callstack.getEncodedStack().getFramesList();
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getFramesList(...)");
            Iterable $this$map$iv = list2;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void frame;
                Memory.AllocationStack.EncodedFrame encodedFrame = (Memory.AllocationStack.EncodedFrame)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Memory.AllocationStack.StackFrame resolvedFrame = this.captureObject.getStackFrame(frame.getMethodId());
                collection.add(new CodeLocation.Builder(resolvedFrame.getClassName()).setMethodName(resolvedFrame.getMethodName()).setLineNumber(frame.getLineNumber() - 1).build());
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @Override
    @NotNull
    public ThreadId getAllocationThreadId() {
        return this.threadId;
    }

    @Override
    @NotNull
    public ClassDb.ClassEntry getClassEntry() {
        return this.classEntry;
    }

    @Override
    @NotNull
    public ValueObject.ValueType getValueType() {
        return this.valueType;
    }

    @Override
    @NotNull
    public String getValueText() {
        String string = this.classEntry.getSimpleClassName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getSimpleClassName(...)");
        return string;
    }

    @Nullable
    public final JniReferenceInstanceObject getJniRefByValue(long refValue) {
        Long2ObjectOpenHashMap<JniReferenceInstanceObject> long2ObjectOpenHashMap = this.jniRefs;
        return long2ObjectOpenHashMap != null ? (JniReferenceInstanceObject)long2ObjectOpenHashMap.get(refValue) : null;
    }

    public final void addJniRef(@NotNull JniReferenceInstanceObject ref) {
        Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
        if (this.jniRefs == null) {
            this.jniRefs = new Long2ObjectOpenHashMap();
        }
        Long2ObjectOpenHashMap<JniReferenceInstanceObject> long2ObjectOpenHashMap = this.jniRefs;
        Intrinsics.checkNotNull(long2ObjectOpenHashMap);
        long2ObjectOpenHashMap.put(ref.getRefValue(), (Object)ref);
    }

    public final void removeJniRef(@NotNull JniReferenceInstanceObject ref) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)ref, (String)"ref");
            Long2ObjectOpenHashMap<JniReferenceInstanceObject> long2ObjectOpenHashMap = this.jniRefs;
            if (long2ObjectOpenHashMap == null) break block0;
            JniReferenceInstanceObject cfr_ignored_0 = (JniReferenceInstanceObject)long2ObjectOpenHashMap.remove(ref.getRefValue());
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[Memory.AllocationStack.FrameCase.values().length];
            try {
                nArray[Memory.AllocationStack.FrameCase.ENCODED_STACK.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

