/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.dependency.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.dependency.BackDependencyIndex;
import org.jetbrains.jps.dependency.Delta;
import org.jetbrains.jps.dependency.Node;
import org.jetbrains.jps.dependency.NodeSource;
import org.jetbrains.jps.dependency.ReferenceID;
import org.jetbrains.jps.javac.Iterators;

final class SourceOnlyDelta
implements Delta {
    private final Set<NodeSource> myBaseSources;
    private final Set<NodeSource> myDeletedSources;
    private final Map<String, BackDependencyIndex> myIndices = new HashMap<String, BackDependencyIndex>();

    SourceOnlyDelta(Iterable<String> indexNames, Iterable<NodeSource> baseSources, Iterable<NodeSource> deletedSources) {
        this.myBaseSources = Collections.unmodifiableSet(baseSources instanceof Set ? (Set)baseSources : (Set)Iterators.collect(baseSources, new HashSet()));
        this.myDeletedSources = Collections.unmodifiableSet(deletedSources instanceof Set ? (Set)deletedSources : (Set)Iterators.collect(deletedSources, new HashSet()));
        for (String name : indexNames) {
            this.myIndices.put(name, BackDependencyIndex.createEmpty(name));
        }
    }

    @Override
    public boolean isSourceOnly() {
        return true;
    }

    @Override
    public Set<NodeSource> getBaseSources() {
        return this.myBaseSources;
    }

    @Override
    public Set<NodeSource> getDeletedSources() {
        return this.myDeletedSources;
    }

    @Override
    public void associate(@NotNull Node<?, ?> node, @NotNull Iterable<NodeSource> sources) {
        if (node == null) {
            SourceOnlyDelta.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            SourceOnlyDelta.$$$reportNull$$$0(1);
        }
    }

    @Override
    public Iterable<BackDependencyIndex> getIndices() {
        return this.myIndices.values();
    }

    @Override
    @Nullable
    public BackDependencyIndex getIndex(String name) {
        return this.myIndices.get(name);
    }

    @Override
    @NotNull
    public Iterable<ReferenceID> getDependingNodes(@NotNull ReferenceID id) {
        if (id == null) {
            SourceOnlyDelta.$$$reportNull$$$0(2);
        }
        List<ReferenceID> list = Collections.emptyList();
        if (list == null) {
            SourceOnlyDelta.$$$reportNull$$$0(3);
        }
        return list;
    }

    @Override
    public Iterable<NodeSource> getSources(@NotNull ReferenceID id) {
        if (id == null) {
            SourceOnlyDelta.$$$reportNull$$$0(4);
        }
        return Collections.emptyList();
    }

    @Override
    public Iterable<ReferenceID> getRegisteredNodes() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<NodeSource> getSources() {
        return Collections.emptyList();
    }

    @Override
    public Iterable<Node<?, ?>> getNodes(@NotNull NodeSource source) {
        if (source == null) {
            SourceOnlyDelta.$$$reportNull$$$0(5);
        }
        return Collections.emptyList();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/jps/dependency/impl/SourceOnlyDelta";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/jps/dependency/impl/SourceOnlyDelta";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependingNodes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "associate";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getDependingNodes";
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getSources";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getNodes";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

