/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.storage;

import java.util.function.Supplier;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOneToManyPathMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalOutputToTargetMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalSourceToOutputMapping;
import org.jetbrains.jps.incremental.storage.ExperimentalTimeStampStorage;
import org.jetbrains.jps.incremental.storage.HashStampStorage;
import org.jetbrains.jps.incremental.storage.PathTypeAwareRelativizer;
import org.jetbrains.jps.incremental.storage.ProjectStamps;
import org.jetbrains.jps.incremental.storage.RelativePathType;
import org.jetbrains.jps.incremental.storage.StampsStorage;
import org.jetbrains.jps.incremental.storage.StorageManager;
import org.jetbrains.jps.incremental.storage.dataTypes.LongPairKeyDataType;
import org.jetbrains.jps.incremental.storage.dataTypes.StringListDataType;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B1\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u0007\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t\u00a2\u0006\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u0006\u0012\u0002\b\u00030\u000e8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u000f\u001a\u00020\u00108FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0013\u0010\u0014\u001a\u0004\b\u0011\u0010\u0012R\u001b\u0010\u0015\u001a\u00020\u00168FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0019\u0010\u0014\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/jps/incremental/storage/PerTargetMapManager;", "", "storageManager", "Lorg/jetbrains/jps/incremental/storage/StorageManager;", "relativizer", "Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;", "target", "Lorg/jetbrains/jps/builders/BuildTarget;", "outputToTargetMapping", "Ljava/util/function/Supplier;", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOutputToTargetMapping;", "<init>", "(Lorg/jetbrains/jps/incremental/storage/StorageManager;Lorg/jetbrains/jps/incremental/storage/PathTypeAwareRelativizer;Lorg/jetbrains/jps/builders/BuildTarget;Ljava/util/function/Supplier;)V", "stamp", "Lorg/jetbrains/jps/incremental/storage/StampsStorage;", "sourceToOutputMapping", "Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "getSourceToOutputMapping", "()Lorg/jetbrains/jps/builders/storage/SourceToOutputMapping;", "sourceToOutputMapping$delegate", "Lkotlin/Lazy;", "sourceToForm", "Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "getSourceToForm", "()Lorg/jetbrains/jps/incremental/storage/ExperimentalOneToManyPathMapping;", "sourceToForm$delegate", "intellij.platform.jps.build"})
public final class PerTargetMapManager {
    @JvmField
    @NotNull
    public final StampsStorage<?> stamp;
    @NotNull
    private final Lazy sourceToOutputMapping$delegate;
    @NotNull
    private final Lazy sourceToForm$delegate;

    public PerTargetMapManager(@NotNull StorageManager storageManager, @NotNull PathTypeAwareRelativizer relativizer, @NotNull BuildTarget<?> target, @NotNull Supplier<ExperimentalOutputToTargetMapping> outputToTargetMapping) {
        StampsStorage stampsStorage;
        Intrinsics.checkNotNullParameter((Object)storageManager, (String)"storageManager");
        Intrinsics.checkNotNullParameter((Object)relativizer, (String)"relativizer");
        Intrinsics.checkNotNullParameter(target, (String)"target");
        Intrinsics.checkNotNullParameter(outputToTargetMapping, (String)"outputToTargetMapping");
        if (ProjectStamps.PORTABLE_CACHES) {
            String string = target.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string2 = target.getTargetType().getTypeId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeId(...)");
            stampsStorage = HashStampStorage.Companion.createSourceToStampMap(storageManager, relativizer, string, string2);
        } else {
            String string = target.getId();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
            String string3 = target.getTargetType().getTypeId();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getTypeId(...)");
            stampsStorage = ExperimentalTimeStampStorage.Companion.createSourceToStampMap(storageManager, relativizer, string, string3);
        }
        this.stamp = stampsStorage;
        this.sourceToOutputMapping$delegate = LazyKt.lazy(() -> PerTargetMapManager.sourceToOutputMapping_delegate$lambda$0(storageManager, relativizer, target, outputToTargetMapping));
        this.sourceToForm$delegate = LazyKt.lazy(() -> PerTargetMapManager.sourceToForm_delegate$lambda$1(storageManager, target, relativizer));
    }

    @NotNull
    public final SourceToOutputMapping getSourceToOutputMapping() {
        Lazy lazy = this.sourceToOutputMapping$delegate;
        return (SourceToOutputMapping)lazy.getValue();
    }

    @NotNull
    public final ExperimentalOneToManyPathMapping getSourceToForm() {
        Lazy lazy = this.sourceToForm$delegate;
        return (ExperimentalOneToManyPathMapping)lazy.getValue();
    }

    private static final ExperimentalSourceToOutputMapping sourceToOutputMapping_delegate$lambda$0(StorageManager $storageManager, PathTypeAwareRelativizer $relativizer, BuildTarget $target, Supplier $outputToTargetMapping) {
        String string = $target.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $target.getTargetType().getTypeId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeId(...)");
        return ExperimentalSourceToOutputMapping.Companion.createSourceToOutputMap($storageManager, $relativizer, string, string2, (ExperimentalOutputToTargetMapping)$outputToTargetMapping.get());
    }

    private static final ExperimentalOneToManyPathMapping sourceToForm_delegate$lambda$1(StorageManager $storageManager, BuildTarget $target, PathTypeAwareRelativizer $relativizer) {
        String string = $target.getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = $target.getTargetType().getTypeId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getTypeId(...)");
        return new ExperimentalOneToManyPathMapping($storageManager.openMap($storageManager.getMapName(string, string2, "source-to-form-v1"), LongPairKeyDataType.INSTANCE, StringListDataType.INSTANCE), $relativizer, 0, RelativePathType.SOURCE, RelativePathType.OUTPUT, 4, null);
    }
}

