/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbUsageTracker;
import com.android.adblib.IsThreadSafe;
import com.android.adblib.NoopAdbUsageTracker;
import com.android.adblib.ProcessRunner;
import com.android.adblib.SystemNanoTimeProvider;
import com.android.adblib.impl.ProcessRunnerImpl;
import com.android.adblib.utils.JdkLoggerFactory;
import com.android.adblib.utils.SystemNanoTime;
import java.nio.channels.AsynchronousChannelGroup;
import java.time.Duration;
import java.time.Instant;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.EmptyCoroutineContext;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@IsThreadSafe
@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\b\u0017\u0018\u00002\u00060\u0001j\u0002`\u0002:\u0006:;<=>?B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J%\u00101\u001a\u0002H2\"\b\b\u0000\u00102*\u0002032\f\u00104\u001a\b\u0012\u0004\u0012\u0002H20\u0007H\u0016\u00a2\u0006\u0002\u00105J\b\u00106\u001a\u000207H\u0016J\u0012\u00108\u001a\u0004\u0018\u0001002\u0006\u00109\u001a\u000200H\u0014R\u0018\u0010\u0005\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\u0019X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u0004\u0018\u00010\u001dX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0014\u0010 \u001a\u00020!X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0014\u0010$\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020%8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010'R\u0014\u0010*\u001a\u00020+8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b*\u0010,\u00a8\u0006@"}, d2={"Lcom/android/adblib/AdbSessionHost;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "<init>", "()V", "loggingFilter", "Lcom/android/adblib/AdbSessionHost$OnlyOnceFilter;", "Lcom/android/adblib/AdbSessionHost$Property;", "timeProvider", "Lcom/android/adblib/SystemNanoTimeProvider;", "getTimeProvider", "()Lcom/android/adblib/SystemNanoTimeProvider;", "loggerFactory", "Lcom/android/adblib/AdbLoggerFactory;", "getLoggerFactory", "()Lcom/android/adblib/AdbLoggerFactory;", "usageTracker", "Lcom/android/adblib/AdbUsageTracker;", "getUsageTracker", "()Lcom/android/adblib/AdbUsageTracker;", "logger", "Lcom/android/adblib/AdbLogger;", "getLogger", "()Lcom/android/adblib/AdbLogger;", "processRunner", "Lcom/android/adblib/ProcessRunner;", "getProcessRunner", "()Lcom/android/adblib/ProcessRunner;", "asynchronousChannelGroup", "Ljava/nio/channels/AsynchronousChannelGroup;", "getAsynchronousChannelGroup", "()Ljava/nio/channels/AsynchronousChannelGroup;", "parentContext", "Lkotlin/coroutines/CoroutineContext;", "getParentContext", "()Lkotlin/coroutines/CoroutineContext;", "ioDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "getIoDispatcher", "()Lkotlinx/coroutines/CoroutineDispatcher;", "blockingIoDispatcher", "getBlockingIoDispatcher", "isEventDispatchThread", "", "()Z", "utcNow", "Ljava/time/Instant;", "generateUniqueUUID", "", "getPropertyValue", "T", "", "property", "(Lcom/android/adblib/AdbSessionHost$Property;)Ljava/lang/Object;", "close", "", "getSystemProperty", "name", "Property", "StringProperty", "IntProperty", "BooleanProperty", "DurationProperty", "OnlyOnceFilter", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nAdbSessionHost.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost\n+ 2 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost$OnlyOnceFilter\n*L\n1#1,265:1\n259#2,4:266\n*S KotlinDebug\n*F\n+ 1 AdbSessionHost.kt\ncom/android/adblib/AdbSessionHost\n*L\n139#1:266,4\n*E\n"})
public class AdbSessionHost
implements AutoCloseable {
    @NotNull
    private final OnlyOnceFilter<Property<?>> loggingFilter = new OnlyOnceFilter();
    @NotNull
    private final SystemNanoTimeProvider timeProvider = new SystemNanoTime();
    @NotNull
    private final AdbLoggerFactory loggerFactory = new JdkLoggerFactory();
    @NotNull
    private final AdbUsageTracker usageTracker = new NoopAdbUsageTracker();
    @NotNull
    private final ProcessRunner processRunner = new ProcessRunnerImpl(this);
    @Nullable
    private final AsynchronousChannelGroup asynchronousChannelGroup;
    @NotNull
    private final CoroutineContext parentContext = (CoroutineContext)EmptyCoroutineContext.INSTANCE;

    @NotNull
    public SystemNanoTimeProvider getTimeProvider() {
        return this.timeProvider;
    }

    @NotNull
    public AdbLoggerFactory getLoggerFactory() {
        return this.loggerFactory;
    }

    @NotNull
    public AdbUsageTracker getUsageTracker() {
        return this.usageTracker;
    }

    @NotNull
    public final AdbLogger getLogger() {
        return this.getLoggerFactory().getLogger();
    }

    @NotNull
    public ProcessRunner getProcessRunner() {
        return this.processRunner;
    }

    @Nullable
    public AsynchronousChannelGroup getAsynchronousChannelGroup() {
        return this.asynchronousChannelGroup;
    }

    @NotNull
    public CoroutineContext getParentContext() {
        return this.parentContext;
    }

    @NotNull
    public CoroutineDispatcher getIoDispatcher() {
        return Dispatchers.getDefault();
    }

    @NotNull
    public CoroutineDispatcher getBlockingIoDispatcher() {
        return Dispatchers.getIO();
    }

    public boolean isEventDispatchThread() {
        return SwingUtilities.isEventDispatchThread();
    }

    @NotNull
    public Instant utcNow() {
        Instant instant = Instant.now();
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"now(...)");
        return instant;
    }

    @NotNull
    public String generateUniqueUUID() {
        String string2 = UUID.randomUUID().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toString(...)");
        return string2;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public <T> T getPropertyValue(@NotNull Property<T> property) {
        T t;
        Intrinsics.checkNotNullParameter(property, (String)"property");
        String string2 = this.getSystemProperty(property.getName());
        if (string2 == null) {
            return property.getDefaultValue();
        }
        String propertyValue = string2;
        try {
            t = property.fromStringValue(propertyValue);
        }
        catch (Throwable t2) {
            void this_$iv;
            OnlyOnceFilter<Property<?>> onlyOnceFilter = this.loggingFilter;
            Property<T> key$iv = property;
            boolean $i$f$filter = false;
            if (((OnlyOnceFilter)this_$iv).seenKeys.add(key$iv)) {
                boolean bl = false;
                this.getLogger().warn(t2, "Invalid or unsupported value '" + propertyValue + "' for property '" + property.getName() + "', using default value '" + property.getDefaultValue() + "' instead");
            }
            t = property.getDefaultValue();
        }
        return t;
    }

    @Override
    public void close() throws Exception {
    }

    @Nullable
    protected String getSystemProperty(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return System.getProperty(name);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0015\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/android/adblib/AdbSessionHost$BooleanProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "", "defaultValue", "isVolatile", "<init>", "(Ljava/lang/String;ZZ)V", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Boolean;", "android.sdktools.adblib"})
    public static final class BooleanProperty
    extends Property<Boolean> {
        public BooleanProperty(@NotNull String name, boolean defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ BooleanProperty(String string2, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl2 = false;
            }
            this(string2, bl, bl2);
        }

        @Override
        @NotNull
        public Boolean fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Boolean.parseBoolean(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a8\u0006\f"}, d2={"Lcom/android/adblib/AdbSessionHost$DurationProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "Ljava/time/Duration;", "name", "", "defaultValue", "isVolatile", "", "<init>", "(Ljava/lang/String;Ljava/time/Duration;Z)V", "fromStringValue", "value", "android.sdktools.adblib"})
    public static final class DurationProperty
    extends Property<Duration> {
        public DurationProperty(@NotNull String name, @NotNull Duration defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ DurationProperty(String string2, Duration duration, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string2, duration, bl);
        }

        @Override
        @NotNull
        public Duration fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            Duration duration = Duration.parse(value);
            Intrinsics.checkNotNullExpressionValue((Object)duration, (String)"parse(...)");
            return duration;
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\n\u001a\u00020\u00022\u0006\u0010\u000b\u001a\u00020\u0004H\u0016\u00a2\u0006\u0002\u0010\f\u00a8\u0006\r"}, d2={"Lcom/android/adblib/AdbSessionHost$IntProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "", "defaultValue", "isVolatile", "", "<init>", "(Ljava/lang/String;IZ)V", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Integer;", "android.sdktools.adblib"})
    public static final class IntProperty
    extends Property<Integer> {
        public IntProperty(@NotNull String name, int defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ IntProperty(String string2, int n, boolean bl, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 4) != 0) {
                bl = false;
            }
            this(string2, n, bl);
        }

        @Override
        @NotNull
        public Integer fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return Integer.parseInt(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J'\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00028\u00002\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\n0\rH\u0086\b\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u000eRN\u0010\u0005\u001aB\u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b \u0007* \u0012\f\u0012\n \u0007*\u0004\u0018\u00018\u00008\u0000\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\b0\b\u0018\u00010\u00060\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0007\n\u0005\b\u009920\u0001\u00a8\u0006\u000f"}, d2={"Lcom/android/adblib/AdbSessionHost$OnlyOnceFilter;", "T", "", "<init>", "()V", "seenKeys", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "kotlin.jvm.PlatformType", "", "filter", "", "key", "block", "Lkotlin/Function0;", "(Ljava/lang/Object;Lkotlin/jvm/functions/Function0;)V", "android.sdktools.adblib"})
    private static final class OnlyOnceFilter<T> {
        private final ConcurrentHashMap.KeySetView<T, Boolean> seenKeys = ConcurrentHashMap.newKeySet();

        public final void filter(@NotNull T key, @NotNull Function0<Unit> block) {
            Intrinsics.checkNotNullParameter(key, (String)"key");
            Intrinsics.checkNotNullParameter(block, (String)"block");
            boolean $i$f$filter = false;
            if (this.seenKeys.add(key)) {
                block.invoke();
            }
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0006\b&\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002B!\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00028\u0000\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0010\u001a\u00028\u00002\u0006\u0010\u0011\u001a\u00020\u0004H&\u00a2\u0006\u0002\u0010\u0012J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\u0013\u0010\u0015\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0017\u001a\u00020\u0004H\u0016J\u0015\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010\u0019R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0005\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u000f\u00a8\u0006\u001a"}, d2={"Lcom/android/adblib/AdbSessionHost$Property;", "T", "", "name", "", "defaultValue", "isVolatile", "", "<init>", "(Ljava/lang/String;Ljava/lang/Object;Z)V", "getName", "()Ljava/lang/String;", "getDefaultValue", "()Ljava/lang/Object;", "Ljava/lang/Object;", "()Z", "fromStringValue", "value", "(Ljava/lang/String;)Ljava/lang/Object;", "hashCode", "", "equals", "other", "toString", "maybeQuoteValue", "(Ljava/lang/Object;)Ljava/lang/String;", "android.sdktools.adblib"})
    public static abstract class Property<T> {
        @NotNull
        private final String name;
        @NotNull
        private final T defaultValue;
        private final boolean isVolatile;

        public Property(@NotNull String name, @NotNull T defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(defaultValue, (String)"defaultValue");
            this.name = name;
            this.defaultValue = defaultValue;
            this.isVolatile = isVolatile;
        }

        public /* synthetic */ Property(String string2, Object object, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string2, object, bl);
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        @NotNull
        public final T getDefaultValue() {
            return this.defaultValue;
        }

        public final boolean isVolatile() {
            return this.isVolatile;
        }

        @NotNull
        public abstract T fromStringValue(@NotNull String var1);

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean equals(@Nullable Object other) {
            return this == other;
        }

        @NotNull
        public String toString() {
            return "Property(name=\"" + this.name + "\", type=" + this.defaultValue.getClass().getSimpleName() + ", defaultValue=" + this.maybeQuoteValue(this.defaultValue) + ")";
        }

        private final String maybeQuoteValue(T value) {
            return value instanceof String ? "\"" + value + "\"" : String.valueOf(value);
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B!\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u00022\u0006\u0010\n\u001a\u00020\u0002H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/adblib/AdbSessionHost$StringProperty;", "Lcom/android/adblib/AdbSessionHost$Property;", "", "name", "defaultValue", "isVolatile", "", "<init>", "(Ljava/lang/String;Ljava/lang/String;Z)V", "fromStringValue", "value", "android.sdktools.adblib"})
    public static final class StringProperty
    extends Property<String> {
        public StringProperty(@NotNull String name, @NotNull String defaultValue, boolean isVolatile) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter((Object)defaultValue, (String)"defaultValue");
            super(name, defaultValue, isVolatile);
        }

        public /* synthetic */ StringProperty(String string2, String string3, boolean bl, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            this(string2, string3, bl);
        }

        @Override
        @NotNull
        public String fromStringValue(@NotNull String value) {
            Intrinsics.checkNotNullParameter((Object)value, (String)"value");
            return value;
        }
    }
}

