/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbSession;
import com.android.adblib.ConnectedDevice;
import com.android.adblib.ConnectedDeviceKt;
import com.android.adblib.CoroutineScopeCache;
import com.android.adblib.DeviceInfo;
import com.android.adblib.DeviceState;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0017\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\b\u0010\u0017\u001a\u00020\u0018H\u0016J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\u000e\u0010\u001b\u001a\u00020\u00182\u0006\u0010\u0006\u001a\u00020\u0007R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00070\u0014X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/impl/ConnectedDeviceImpl;", "Lcom/android/adblib/ConnectedDevice;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "session", "Lcom/android/adblib/AdbSession;", "deviceInfo", "Lcom/android/adblib/DeviceInfo;", "<init>", "(Lcom/android/adblib/AdbSession;Lcom/android/adblib/DeviceInfo;)V", "getSession", "()Lcom/android/adblib/AdbSession;", "deviceInfoStateFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "cacheImpl", "Lcom/android/adblib/CoroutineScopeCache;", "cache", "getCache", "()Lcom/android/adblib/CoroutineScopeCache;", "deviceInfoFlow", "Lkotlinx/coroutines/flow/StateFlow;", "getDeviceInfoFlow", "()Lkotlinx/coroutines/flow/StateFlow;", "close", "", "toString", "", "updateDeviceInfo", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nConnectedDeviceImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ConnectedDeviceImpl.kt\ncom/android/adblib/impl/ConnectedDeviceImpl\n+ 2 StateFlow.kt\nkotlinx/coroutines/flow/StateFlowKt\n*L\n1#1,58:1\n226#2,5:59\n*S KotlinDebug\n*F\n+ 1 ConnectedDeviceImpl.kt\ncom/android/adblib/impl/ConnectedDeviceImpl\n*L\n45#1:59,5\n*E\n"})
public final class ConnectedDeviceImpl
implements ConnectedDevice,
AutoCloseable {
    @NotNull
    private final AdbSession session;
    @NotNull
    private final MutableStateFlow<DeviceInfo> deviceInfoStateFlow;
    @NotNull
    private final CoroutineScopeCache cacheImpl;
    @NotNull
    private final StateFlow<DeviceInfo> deviceInfoFlow;

    public ConnectedDeviceImpl(@NotNull AdbSession session2, @NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        this.session = session2;
        this.deviceInfoStateFlow = StateFlowKt.MutableStateFlow((Object)deviceInfo);
        this.cacheImpl = CoroutineScopeCache.Companion.create(this.getSession().getScope(), this.getSession() + " - device-serial='" + deviceInfo.getSerialNumber() + "'");
        this.deviceInfoFlow = FlowKt.asStateFlow(this.deviceInfoStateFlow);
    }

    @Override
    @NotNull
    public AdbSession getSession() {
        return this.session;
    }

    @Override
    @NotNull
    public CoroutineScopeCache getCache() {
        return this.cacheImpl;
    }

    @Override
    @NotNull
    public StateFlow<DeviceInfo> getDeviceInfoFlow() {
        return this.deviceInfoFlow;
    }

    @Override
    public void close() {
        DeviceInfo it;
        DeviceInfo nextValue$iv;
        Object prevValue$iv;
        MutableStateFlow<DeviceInfo> $this$update$iv = this.deviceInfoStateFlow;
        boolean $i$f$update = false;
        do {
            prevValue$iv = $this$update$iv.getValue();
            it = (DeviceInfo)prevValue$iv;
            boolean bl = false;
        } while (!$this$update$iv.compareAndSet(prevValue$iv, (Object)(nextValue$iv = DeviceInfo.copy$default(it, null, DeviceState.DISCONNECTED, null, null, null, null, null, null, null, null, 1021, null))));
        this.cacheImpl.close();
    }

    @NotNull
    public String toString() {
        return Reflection.getOrCreateKotlinClass(ConnectedDevice.class).getSimpleName() + "(serial='" + ConnectedDeviceKt.getDeviceInfo(this).getSerialNumber() + "')";
    }

    public final void updateDeviceInfo(@NotNull DeviceInfo deviceInfo) {
        Intrinsics.checkNotNullParameter((Object)deviceInfo, (String)"deviceInfo");
        boolean bl = Intrinsics.areEqual((Object)deviceInfo.getSerialNumber(), (Object)((DeviceInfo)this.deviceInfoStateFlow.getValue()).getSerialNumber());
        if (_Assertions.ENABLED && !bl) {
            String string2 = "Assertion failed";
            throw new AssertionError((Object)string2);
        }
        this.deviceInfoStateFlow.setValue((Object)deviceInfo);
    }
}

