/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.AdbInputChannel;
import com.android.adblib.AdbOutputChannel;
import com.android.adblib.AdbPipedInputChannel;
import com.android.adblib.AdbPipedOutputChannel;
import com.android.adblib.AdbSession;
import com.android.adblib.InputChannelShellOutput;
import java.nio.ByteBuffer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.FlowKt;
import kotlinx.coroutines.flow.MutableStateFlow;
import kotlinx.coroutines.flow.StateFlow;
import kotlinx.coroutines.flow.StateFlowKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u00012\u00060\u0002j\u0002`\u0003B\u0019\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0016\u0010!\u001a\u00020\"2\u0006\u0010\u0017\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010%\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020#H\u0086@\u00a2\u0006\u0002\u0010$J\u0016\u0010&\u001a\u00020\"2\u0006\u0010\u001d\u001a\u00020\u0007H\u0086@\u00a2\u0006\u0002\u0010'J\b\u0010(\u001a\u00020\"H\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0016\u0010\f\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0015\u001a\u00020\u00118BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0013R\u0014\u0010\u0017\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u00188VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u001c\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 \u00a8\u0006)"}, d2={"Lcom/android/adblib/impl/InputChannelShellOutputImpl;", "Lcom/android/adblib/InputChannelShellOutput;", "Ljava/lang/AutoCloseable;", "Lkotlin/AutoCloseable;", "session", "Lcom/android/adblib/AdbSession;", "bufferSize", "", "<init>", "(Lcom/android/adblib/AdbSession;I)V", "getSession", "()Lcom/android/adblib/AdbSession;", "exitCodeFlow", "Lkotlinx/coroutines/flow/MutableStateFlow;", "stdoutChannel", "Lcom/android/adblib/AdbPipedInputChannel;", "stdoutOutputPipe", "Lcom/android/adblib/AdbPipedOutputChannel;", "getStdoutOutputPipe", "()Lcom/android/adblib/AdbPipedOutputChannel;", "stderrChannel", "stderrOutputPipe", "getStderrOutputPipe", "stdout", "Lcom/android/adblib/AdbInputChannel;", "getStdout", "()Lcom/android/adblib/AdbInputChannel;", "stderr", "getStderr", "exitCode", "Lkotlinx/coroutines/flow/StateFlow;", "getExitCode", "()Lkotlinx/coroutines/flow/StateFlow;", "writeStdout", "", "Ljava/nio/ByteBuffer;", "(Ljava/nio/ByteBuffer;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "writeStderr", "end", "(ILkotlin/coroutines/Continuation;)Ljava/lang/Object;", "close", "android.sdktools.adblib"})
public final class InputChannelShellOutputImpl
implements InputChannelShellOutput,
AutoCloseable {
    @NotNull
    private final AdbSession session;
    @NotNull
    private final MutableStateFlow<Integer> exitCodeFlow;
    @NotNull
    private final AdbPipedInputChannel stdoutChannel;
    @NotNull
    private final AdbPipedInputChannel stderrChannel;
    @NotNull
    private final StateFlow<Integer> exitCode;

    public InputChannelShellOutputImpl(@NotNull AdbSession session2, int bufferSize) {
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        this.session = session2;
        this.exitCodeFlow = StateFlowKt.MutableStateFlow(null);
        this.stdoutChannel = this.session.getChannelFactory().createPipedChannel(bufferSize);
        this.stderrChannel = this.session.getChannelFactory().createPipedChannel(bufferSize);
        this.exitCode = FlowKt.asStateFlow(this.exitCodeFlow);
    }

    public /* synthetic */ InputChannelShellOutputImpl(AdbSession adbSession, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 8192;
        }
        this(adbSession, n);
    }

    @NotNull
    public final AdbSession getSession() {
        return this.session;
    }

    private final AdbPipedOutputChannel getStdoutOutputPipe() {
        return this.stdoutChannel.getPipeSource();
    }

    private final AdbPipedOutputChannel getStderrOutputPipe() {
        return this.stderrChannel.getPipeSource();
    }

    @Override
    @NotNull
    public AdbInputChannel getStdout() {
        return this.stdoutChannel;
    }

    @Override
    @NotNull
    public AdbInputChannel getStderr() {
        return this.stderrChannel;
    }

    @Override
    @NotNull
    public StateFlow<Integer> getExitCode() {
        return this.exitCode;
    }

    @Nullable
    public final Object writeStdout(@NotNull ByteBuffer stdout2, @NotNull Continuation<? super Unit> $completion) {
        Object object = AdbOutputChannel.writeExactly$default(this.getStdoutOutputPipe(), stdout2, 0L, null, $completion, 6, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object writeStderr(@NotNull ByteBuffer stderr2, @NotNull Continuation<? super Unit> $completion) {
        Object object = AdbOutputChannel.writeExactly$default(this.getStderrOutputPipe(), stderr2, 0L, null, $completion, 6, null);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Nullable
    public final Object end(int exitCode2, @NotNull Continuation<? super Unit> $completion) {
        this.getStdoutOutputPipe().close();
        this.getStderrOutputPipe().close();
        Object object = this.exitCodeFlow.emit((Object)Boxing.boxInt((int)exitCode2), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @Override
    public void close() {
        this.getStdoutOutputPipe().close();
        this.getStderrOutputPipe().close();
    }
}

