/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.impl;

import com.android.adblib.DeviceAddress;
import com.android.adblib.ErrorLine;
import com.android.adblib.ListWithErrors;
import com.android.adblib.MdnsServiceInfo;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\f\u0012\u0004\u0012\u00020\b0\u0007j\u0002`\t2\u0006\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/adblib/impl/MdnsServiceListParser;", "", "<init>", "()V", "lineRegex", "Lkotlin/text/Regex;", "parse", "Lcom/android/adblib/ListWithErrors;", "Lcom/android/adblib/MdnsServiceInfo;", "Lcom/android/adblib/MdnsServiceList;", "text", "", "android.sdktools.adblib"})
@SourceDebugExtension(value={"SMAP\nMdnsServiceListParser.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MdnsServiceListParser.kt\ncom/android/adblib/impl/MdnsServiceListParser\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,110:1\n1872#2,3:111\n*S KotlinDebug\n*F\n+ 1 MdnsServiceListParser.kt\ncom/android/adblib/impl/MdnsServiceListParser\n*L\n57#1:111,3\n*E\n"})
public final class MdnsServiceListParser {
    @NotNull
    private final Regex lineRegex = new Regex("([^\t]+)\\t([^\t]+)\\t([^\t]+)");

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final ListWithErrors<MdnsServiceInfo> parse(@NotNull CharSequence text) {
        void $this$forEachIndexed$iv;
        Intrinsics.checkNotNullParameter((Object)text, (String)"text");
        ListWithErrors.Builder<MdnsServiceInfo> builder = new ListWithErrors.Builder<MdnsServiceInfo>();
        Set dedupedMdnsServiceInfos = new LinkedHashSet();
        Object object = new String[]{"\n"};
        object = StringsKt.split$default((CharSequence)text, (String[])object, (boolean)false, (int)0, (int)6, null);
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            void line;
            int n;
            if ((n = index$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            String string2 = (String)item$iv;
            int lineIndex = n;
            boolean bl = false;
            if (StringsKt.isBlank((CharSequence)((Object)StringsKt.trim((CharSequence)((CharSequence)line))).toString())) continue;
            MatchResult matchResult = Regex.find$default((Regex)this.lineRegex, (CharSequence)((CharSequence)line), (int)0, (int)2, null);
            if (matchResult == null) {
                ErrorLine error = new ErrorLine("mDNS service entry format not recognized", lineIndex, (String)line);
                builder.addError(error);
                continue;
            }
            try {
                ErrorLine error;
                String instanceName = (String)matchResult.getGroupValues().get(1);
                String serviceName = (String)matchResult.getGroupValues().get(2);
                DeviceAddress deviceAddress = new DeviceAddress((String)matchResult.getGroupValues().get(3));
                MdnsServiceInfo mdnsServiceInfo = new MdnsServiceInfo(instanceName, serviceName, deviceAddress);
                if (StringsKt.startsWith$default((String)mdnsServiceInfo.getDeviceAddress().getAddress(), (String)"0.0.0.0:", (boolean)false, (int)2, null)) {
                    error = new ErrorLine("Invalid IP address `0.0.0.0` detected", lineIndex, (String)line);
                    builder.addError(error);
                    continue;
                }
                if (!dedupedMdnsServiceInfos.add(mdnsServiceInfo)) {
                    error = new ErrorLine("Duplicate mDNS service entry detected", lineIndex, (String)line);
                    builder.addError(error);
                    continue;
                }
                builder.addEntry(mdnsServiceInfo);
            }
            catch (Exception exception) {
                ErrorLine error = new ErrorLine("mDNS service entry ignored due do invalid characters", lineIndex, (String)line);
                builder.addError(error);
            }
        }
        return builder.build();
    }
}

