/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging;

import java.util.NoSuchElementException;
import java.util.Objects;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u0018*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0002:\u0002\u0017\u0018B\u0011\b\u0002\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000b\u0010\r\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u000eJ\u0006\u0010\u000f\u001a\u00020\u0010J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0013\u0010\u0013\u001a\u00020\b2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\b\u0010\u0015\u001a\u00020\u0010H\u0016J\b\u0010\u0016\u001a\u00020\u0010H\u0002R\u0010\u0010\u0003\u001a\u00028\u0000X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\nR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u0019"}, d2={"Lcom/android/adblib/tools/debugging/OptionalValue;", "T", "", "obj", "<init>", "(Ljava/lang/Object;)V", "Ljava/lang/Object;", "hasValue", "", "getHasValue", "()Z", "isEmpty", "isError", "getOrThrow", "()Ljava/lang/Object;", "getErrorMessageOrThrow", "", "hashCode", "", "equals", "other", "toString", "objToString", "Error", "Companion", "android.sdktools.adblib.tools"})
public final class OptionalValue<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final T obj;
    @NotNull
    private static final Object EMPTY_SINGLETON = new Object();
    @NotNull
    private static final OptionalValue<Object> emptyValue = new OptionalValue<Object>(EMPTY_SINGLETON);
    @NotNull
    private static final OptionalValue<String> emptyStringValue = new OptionalValue<String>("");
    @NotNull
    private static final OptionalValue<Integer> zeroIntValue = new OptionalValue<Integer>(0);
    @NotNull
    private static final OptionalValue<Boolean> trueValue = new OptionalValue<Boolean>(true);
    @NotNull
    private static final OptionalValue<Boolean> falseValue = new OptionalValue<Boolean>(false);

    private OptionalValue(T obj) {
        this.obj = obj;
    }

    public final boolean getHasValue() {
        return this.obj != EMPTY_SINGLETON && !this.isError();
    }

    public final boolean isEmpty() {
        return this.obj == EMPTY_SINGLETON;
    }

    public final boolean isError() {
        return this.obj instanceof Error;
    }

    @NotNull
    public final T getOrThrow() {
        if (!this.getHasValue()) {
            throw new NoSuchElementException("No value present");
        }
        return this.obj;
    }

    @NotNull
    public final String getErrorMessageOrThrow() {
        T t = this.obj;
        Object object = t instanceof Error ? (Error)t : null;
        if (object == null || (object = ((Error)object).getMessage()) == null) {
            throw new NoSuchElementException("No error present");
        }
        return object;
    }

    public int hashCode() {
        return Objects.hashCode(this.obj);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof OptionalValue && Objects.equals(this.obj, ((OptionalValue)other).obj);
    }

    @NotNull
    public String toString() {
        return this.obj == EMPTY_SINGLETON ? "OptionalValue.empty" : (this.obj instanceof Error ? "OptionalValue.error(\"" + ((Error)this.obj).getMessage() + "\")" : "OptionalValue(" + this.objToString() + ")");
    }

    private final String objToString() {
        return this.obj instanceof String ? "\"" + this.obj + "\"" : this.obj.toString();
    }

    public /* synthetic */ OptionalValue(Object obj, DefaultConstructorMarker $constructor_marker) {
        this(obj);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J#\u0010\u000e\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0006\"\b\b\u0001\u0010\u000f*\u00020\u00012\u0006\u0010\u0010\u001a\u0002H\u000f\u00a2\u0006\u0002\u0010\u0011J\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0006\"\b\b\u0001\u0010\u000f*\u00020\u00012\u0006\u0010\u0013\u001a\u00020\bJ\u0016\u0010\u0014\u001a\b\u0012\u0004\u0012\u0002H\u000f0\u0006\"\b\b\u0001\u0010\u000f*\u00020\u0001J$\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\b\u0002H\u000f0\u0006\"\u0004\b\u0001\u0010\u000f2\u0006\u0010\u0010\u001a\u0002H\u000f\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00010\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\b0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\f0\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u0004\n\u0002\b9\u00a8\u0006\u0016"}, d2={"Lcom/android/adblib/tools/debugging/OptionalValue$Companion;", "", "<init>", "()V", "EMPTY_SINGLETON", "emptyValue", "Lcom/android/adblib/tools/debugging/OptionalValue;", "emptyStringValue", "", "zeroIntValue", "", "trueValue", "", "falseValue", "of", "T", "value", "(Ljava/lang/Object;)Lcom/android/adblib/tools/debugging/OptionalValue;", "ofError", "message", "empty", "ofNullable", "android.sdktools.adblib.tools"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final <T> OptionalValue<T> of(@NotNull T value) {
            OptionalValue optionalValue;
            Intrinsics.checkNotNullParameter(value, (String)"value");
            T t = value;
            if (Intrinsics.areEqual(t, (Object)true)) {
                OptionalValue optionalValue2 = trueValue;
                optionalValue = optionalValue2;
                Intrinsics.checkNotNull((Object)optionalValue2, (String)"null cannot be cast to non-null type com.android.adblib.tools.debugging.OptionalValue<T of com.android.adblib.tools.debugging.OptionalValue.Companion.of>");
            } else if (Intrinsics.areEqual(t, (Object)false)) {
                OptionalValue optionalValue3 = falseValue;
                optionalValue = optionalValue3;
                Intrinsics.checkNotNull((Object)optionalValue3, (String)"null cannot be cast to non-null type com.android.adblib.tools.debugging.OptionalValue<T of com.android.adblib.tools.debugging.OptionalValue.Companion.of>");
            } else if (Intrinsics.areEqual(t, (Object)0)) {
                OptionalValue optionalValue4 = zeroIntValue;
                optionalValue = optionalValue4;
                Intrinsics.checkNotNull((Object)optionalValue4, (String)"null cannot be cast to non-null type com.android.adblib.tools.debugging.OptionalValue<T of com.android.adblib.tools.debugging.OptionalValue.Companion.of>");
            } else if (Intrinsics.areEqual(t, (Object)"")) {
                OptionalValue optionalValue5 = emptyStringValue;
                optionalValue = optionalValue5;
                Intrinsics.checkNotNull((Object)optionalValue5, (String)"null cannot be cast to non-null type com.android.adblib.tools.debugging.OptionalValue<T of com.android.adblib.tools.debugging.OptionalValue.Companion.of>");
            } else {
                optionalValue = new OptionalValue(value, null);
            }
            return optionalValue;
        }

        @NotNull
        public final <T> OptionalValue<T> ofError(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            Object obj = new Error(message);
            return new OptionalValue(obj, null);
        }

        @NotNull
        public final <T> OptionalValue<T> empty() {
            OptionalValue optionalValue = emptyValue;
            Intrinsics.checkNotNull((Object)optionalValue, (String)"null cannot be cast to non-null type com.android.adblib.tools.debugging.OptionalValue<T of com.android.adblib.tools.debugging.OptionalValue.Companion.empty>");
            return optionalValue;
        }

        @NotNull
        public final <T> OptionalValue<T> ofNullable(T value) {
            return value == null ? this.empty() : this.of(value);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\b\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\t\u0010\b\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\t\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\r\u001a\u00020\u000eH\u00d6\u0001J\t\u0010\u000f\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\u0010"}, d2={"Lcom/android/adblib/tools/debugging/OptionalValue$Error;", "", "message", "", "<init>", "(Ljava/lang/String;)V", "getMessage", "()Ljava/lang/String;", "component1", "copy", "equals", "", "other", "hashCode", "", "toString", "android.sdktools.adblib.tools"})
    @SourceDebugExtension(value={"SMAP\nOptionalValue.kt\nKotlin\n*S Kotlin\n*F\n+ 1 OptionalValue.kt\ncom/android/adblib/tools/debugging/OptionalValue$Error\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,203:1\n1#2:204\n*E\n"})
    private static final class Error {
        @NotNull
        private final String message;

        public Error(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.message = message;
            if (!(((CharSequence)this.message).length() > 0)) {
                boolean bl = false;
                String string2 = "Error message cannot be empty";
                throw new IllegalArgumentException(string2.toString());
            }
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.message;
        }

        @NotNull
        public final Error copy(@NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new Error(message);
        }

        public static /* synthetic */ Error copy$default(Error error, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string2 = error.message;
            }
            return error.copy(string2);
        }

        @NotNull
        public String toString() {
            return "Error(message=" + this.message + ")";
        }

        public int hashCode() {
            return this.message.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof Error)) {
                return false;
            }
            Error error = (Error)other;
            return Intrinsics.areEqual((Object)this.message, (Object)error.message);
        }
    }
}

