/*
 * Decompiled with CFR 0.152.
 */
package com.android.adblib.tools.debugging.utils;

import com.android.adblib.AdbLogger;
import com.android.adblib.AdbLoggerFactory;
import com.android.adblib.AdbSession;
import com.android.adblib.AdbSessionHost;
import com.android.adblib.ConnectedDeviceKt;
import com.android.adblib.tools.debugging.SharedJdwpSession;
import com.android.adblib.tools.debugging.SharedJdwpSessionFilter;
import com.android.adblib.tools.debugging.packets.JdwpPacketView;
import com.android.adblib.tools.debugging.packets.ddms.DdmsChunkUtilsKt;
import com.android.adblib.tools.debugging.utils.NoDdmsPacketFilterFactory;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.jvm.internal.Boxing;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0016\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\u0014H\u0096@\u00a2\u0006\u0002\u0010\u0015J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\nH\u0002J\b\u0010\u001b\u001a\u00020\u0012H\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000RN\u0010\b\u001aB\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f \u000b* \u0012\f\u0012\n \u000b*\u0004\u0018\u00010\n0\n\u0012\f\u0012\n \u000b*\u0004\u0018\u00010\f0\f\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001c"}, d2={"Lcom/android/adblib/tools/debugging/utils/NoDdmsPacketFilter;", "Lcom/android/adblib/tools/debugging/SharedJdwpSessionFilter;", "session", "Lcom/android/adblib/tools/debugging/SharedJdwpSession;", "<init>", "(Lcom/android/adblib/tools/debugging/SharedJdwpSession;)V", "logger", "Lcom/android/adblib/AdbLogger;", "activeDdmsCommands", "Ljava/util/concurrent/ConcurrentHashMap$KeySetView;", "", "kotlin.jvm.PlatformType", "", "id", "Lcom/android/adblib/tools/debugging/SharedJdwpSessionFilter$FilterId;", "getId", "()Lcom/android/adblib/tools/debugging/SharedJdwpSessionFilter$FilterId;", "beforeSendPacket", "", "packet", "Lcom/android/adblib/tools/debugging/packets/JdwpPacketView;", "(Lcom/android/adblib/tools/debugging/packets/JdwpPacketView;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "afterReceivePacket", "filter", "intToHex", "", "value", "close", "android.sdktools.adblib.tools"})
@SourceDebugExtension(value={"SMAP\nNoDdmsPacketFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NoDdmsPacketFilter.kt\ncom/android/adblib/tools/debugging/utils/NoDdmsPacketFilter\n+ 2 AdbLogger.kt\ncom/android/adblib/AdbLoggerKt\n+ 3 AdbLogger.kt\ncom/android/adblib/AdbLogger\n*L\n1#1,100:1\n134#2:101\n127#2:102\n120#2:103\n38#3:104\n26#3,14:105\n38#3:119\n26#3,14:120\n38#3:134\n26#3,14:135\n38#3:149\n26#3,14:150\n38#3:164\n26#3,14:165\n38#3:179\n26#3,14:180\n*S KotlinDebug\n*F\n+ 1 NoDdmsPacketFilter.kt\ncom/android/adblib/tools/debugging/utils/NoDdmsPacketFilter\n*L\n34#1:101\n34#1:102\n34#1:103\n48#1:104\n48#1:105,14\n57#1:119\n57#1:120,14\n66#1:134\n66#1:135,14\n72#1:149\n72#1:150,14\n76#1:164\n76#1:165,14\n85#1:179\n85#1:180,14\n*E\n"})
public final class NoDdmsPacketFilter
implements SharedJdwpSessionFilter {
    @NotNull
    private final AdbLogger logger;
    private final ConcurrentHashMap.KeySetView<Integer, Boolean> activeDdmsCommands;

    /*
     * WARNING - void declaration
     */
    public NoDdmsPacketFilter(@NotNull SharedJdwpSession session2) {
        void $this$adbLogger$iv$iv;
        void $this$adbLogger$iv;
        Intrinsics.checkNotNullParameter((Object)session2, (String)"session");
        NoDdmsPacketFilter noDdmsPacketFilter = this;
        AdbSession session$iv = session2.getDevice().getSession();
        boolean $i$f$adbLogger = false;
        void var5_5 = $this$adbLogger$iv;
        AdbSessionHost host$iv$iv = session$iv.getHost();
        boolean $i$f$adbLogger2 = false;
        void var8_8 = $this$adbLogger$iv$iv;
        AdbLoggerFactory loggerFactory$iv$iv$iv = host$iv$iv.getLoggerFactory();
        boolean $i$f$adbLogger3 = false;
        this.logger = ConnectedDeviceKt.withProcessPrefix(loggerFactory$iv$iv$iv.createLogger(NoDdmsPacketFilter.class), session2.getDevice(), session2.getPid());
        this.activeDdmsCommands = ConcurrentHashMap.newKeySet();
    }

    @Override
    @NotNull
    public SharedJdwpSessionFilter.FilterId getId() {
        return NoDdmsPacketFilterFactory.Companion.getFilterId();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object beforeSendPacket(@NotNull JdwpPacketView packet, @NotNull Continuation<? super Unit> $completion) {
        if (DdmsChunkUtilsKt.isDdmsCommand(packet)) {
            void this_$iv$iv;
            AdbLogger this_$iv = this.logger;
            boolean $i$f$verbose = false;
            AdbLogger adbLogger = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                void var9_9 = this_$iv$iv;
                boolean bl = false;
                String string2 = "Adding packet id=" + this.intToHex(packet.getId()) + " because it is a DDMS command to the device";
                var9_9.log(level, string2);
            }
            this.activeDdmsCommands.add(Boxing.boxInt((int)packet.getId()));
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object afterReceivePacket(@NotNull JdwpPacketView packet, @NotNull Continuation<? super Unit> $completion) {
        if (packet.isReply()) {
            ConcurrentHashMap.KeySetView<Integer, Boolean> keySetView = this.activeDdmsCommands;
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"activeDdmsCommands");
            if (!((Collection)keySetView).isEmpty()) {
                boolean bl;
                boolean removed = bl = this.activeDdmsCommands.remove(Boxing.boxInt((int)packet.getId()));
                boolean bl2 = false;
                if (removed) {
                    void this_$iv$iv;
                    AdbLogger this_$iv = this.logger;
                    boolean $i$f$verbose = false;
                    AdbLogger adbLogger = this_$iv;
                    AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                    boolean $i$f$logIf = false;
                    if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                        AdbLogger.Level level = level$iv$iv;
                        void var12_12 = this_$iv$iv;
                        boolean bl3 = false;
                        String string2 = "Removing packet id=" + this.intToHex(packet.getId()) + " because it is a reply to a previously seen DDMS command";
                        var12_12.log(level, string2);
                    }
                }
            }
        }
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Nullable
    public Object filter(@NotNull JdwpPacketView packet, @NotNull Continuation<? super Boolean> $completion) {
        if (packet.isReply()) {
            ConcurrentHashMap.KeySetView<Integer, Boolean> keySetView = this.activeDdmsCommands;
            Intrinsics.checkNotNullExpressionValue(keySetView, (String)"activeDdmsCommands");
            if (!((Collection)keySetView).isEmpty() && this.activeDdmsCommands.contains(Boxing.boxInt((int)packet.getId()))) {
                void this_$iv$iv;
                AdbLogger this_$iv = this.logger;
                boolean $i$f$verbose = false;
                AdbLogger adbLogger = this_$iv;
                AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
                boolean $i$f$logIf = false;
                if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                    AdbLogger.Level level = level$iv$iv;
                    void var9_21 = this_$iv$iv;
                    boolean bl = false;
                    String string2 = "Skipping packet id=" + this.intToHex(packet.getId()) + " because it is the reply to a DDMS command";
                    var9_21.log(level, string2);
                }
                return Boxing.boxBoolean((boolean)false);
            }
        }
        if (DdmsChunkUtilsKt.isDdmsCommand(packet)) {
            AdbLogger this_$iv = this.logger;
            boolean $i$f$verbose = false;
            AdbLogger this_$iv$iv = this_$iv;
            AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
            boolean $i$f$logIf = false;
            if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
                AdbLogger.Level level = level$iv$iv;
                AdbLogger adbLogger = this_$iv$iv;
                boolean bl = false;
                String string3 = "Skipping packet id=" + this.intToHex(packet.getId()) + " because it is a DDMS command from the device";
                adbLogger.log(level, string3);
            }
            return Boxing.boxBoolean((boolean)false);
        }
        AdbLogger this_$iv = this.logger;
        boolean $i$f$verbose = false;
        AdbLogger this_$iv$iv = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            AdbLogger adbLogger = this_$iv$iv;
            boolean bl = false;
            String string4 = "Keeping packet id=" + this.intToHex(packet.getId()) + " because it is not a DDMS command";
            adbLogger.log(level, string4);
        }
        return Boxing.boxBoolean((boolean)true);
    }

    private final String intToHex(int value) {
        String string2 = "0x%X";
        Object[] objectArray = new Object[]{value};
        String string3 = String.format(string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        return string3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() {
        void this_$iv$iv;
        AdbLogger this_$iv = this.logger;
        boolean $i$f$verbose = false;
        AdbLogger adbLogger = this_$iv;
        AdbLogger.Level level$iv$iv = AdbLogger.Level.VERBOSE;
        boolean $i$f$logIf = false;
        if (this_$iv$iv.getMinLevel().compareTo((Enum)level$iv$iv) <= 0) {
            AdbLogger.Level level = level$iv$iv;
            void var7_7 = this_$iv$iv;
            boolean bl = false;
            String string2 = "Closing with " + this.activeDdmsCommands.size() + " entries left";
            var7_7.log(level, string2);
        }
    }
}

