/*
 * Decompiled with CFR 0.152.
 */
package com.android.ddmlib.testrunner;

import com.android.commands.am.InstrumentationData;
import com.android.ddmlib.Log;
import com.android.ddmlib.testrunner.IInstrumentationResultParser;
import com.android.ddmlib.testrunner.ITestRunListener;
import com.android.ddmlib.testrunner.TestIdentifier;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import com.google.protobuf.InvalidProtocolBufferException;
import java.io.ByteArrayOutputStream;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class InstrumentationProtoResultParser
implements IInstrumentationResultParser {
    private static final String LOG_TAG = "InstrumentationProtoResultParser";
    private final String mRunName;
    private final Collection<ITestRunListener> mListeners;
    private InstrumentationProtoResultParserState mState = InstrumentationProtoResultParserState.NOT_STARTED;
    private ByteArrayOutputStream mPendingData = new ByteArrayOutputStream();
    private final LinkedHashMap<TestIdentifier, TestStatus> mTestStatuses = new LinkedHashMap();
    private final Pattern mTimePattern = Pattern.compile("Time: \\s*([\\d\\,]*[\\d\\.]+)");

    public InstrumentationProtoResultParser(String runName, Collection<ITestRunListener> listeners) {
        this.mRunName = runName;
        this.mListeners = listeners;
    }

    @Override
    public void addOutput(byte[] data, int offset, int length) {
        if (this.mState.isTerminalState()) {
            return;
        }
        this.mPendingData.write(data, offset, length);
        try {
            InstrumentationData.Session session2 = InstrumentationData.Session.parseFrom((byte[])this.mPendingData.toByteArray());
            this.mPendingData.reset();
            this.updateState(session2);
        }
        catch (InvalidProtocolBufferException invalidProtocolBufferException) {
            // empty catch block
        }
    }

    private void updateState(InstrumentationData.Session session2) {
        for (InstrumentationData.TestStatus status2 : session2.getTestStatusList()) {
            if (this.mState == InstrumentationProtoResultParserState.NOT_STARTED) {
                int numTests = status2.getResults().getEntriesList().stream().filter(entry -> entry.getKey().equals("numtests")).map(entry -> entry.getValueInt()).findFirst().orElse(0);
                if (numTests == 0) {
                    return;
                }
                this.mState = InstrumentationProtoResultParserState.RUNNING;
                for (ITestRunListener listener2 : this.mListeners) {
                    listener2.testRunStarted(this.mRunName, numTests);
                }
            }
            String testClassName = "";
            Object testMethodName = "";
            int currentTestIndex = -1;
            String stackTrace = "";
            LinkedHashMap<String, String> testMetrics = new LinkedHashMap<String, String>();
            block18: for (InstrumentationData.ResultsBundleEntry entry2 : status2.getResults().getEntriesList()) {
                switch (entry2.getKey()) {
                    case "class": {
                        testClassName = entry2.getValueString();
                        continue block18;
                    }
                    case "test": {
                        testMethodName = entry2.getValueString();
                        continue block18;
                    }
                    case "stack": {
                        stackTrace = entry2.getValueString();
                        continue block18;
                    }
                    case "current": {
                        currentTestIndex = entry2.getValueInt();
                        continue block18;
                    }
                }
                if (IInstrumentationResultParser.StatusKeys.KNOWN_KEYS.contains(entry2.getKey())) continue;
                testMetrics.put(entry2.getKey(), InstrumentationProtoResultParser.getResultsEntryBundleValueInString(entry2));
            }
            Optional<Integer> resultCodeOverride = Optional.empty();
            if (Strings.isNullOrEmpty((String)testClassName) && Strings.isNullOrEmpty((String)testMethodName)) {
                Optional previousTestStatus = this.mTestStatuses.entrySet().stream().reduce((first, second) -> second);
                if (previousTestStatus.isPresent()) {
                    testClassName = ((TestIdentifier)((Map.Entry)previousTestStatus.get()).getKey()).getClassName();
                    testMethodName = ((TestIdentifier)((Map.Entry)previousTestStatus.get()).getKey()).getTestName();
                    currentTestIndex = ((TestIdentifier)((Map.Entry)previousTestStatus.get()).getKey()).getTestIndex();
                    resultCodeOverride = Optional.of(((TestStatus)((Map.Entry)previousTestStatus.get()).getValue()).mTestResultCode);
                } else {
                    testClassName = "";
                    testMethodName = "";
                }
            }
            if (Strings.isNullOrEmpty((String)testClassName) || Strings.isNullOrEmpty((String)testMethodName)) continue;
            this.updateTestState(testClassName, (String)testMethodName, currentTestIndex, resultCodeOverride.orElse(status2.getResultCode()), status2.getLogcat(), stackTrace, testMetrics);
        }
        if (session2.hasSessionStatus()) {
            this.mState = InstrumentationProtoResultParserState.FINISHED;
            LinkedHashMap<String, String> testRunMetrics = new LinkedHashMap<String, String>();
            switch (session2.getSessionStatus().getStatusCode()) {
                case SESSION_ABORTED: {
                    Object errorMessage = session2.getSessionStatus().getErrorText();
                    Map.Entry lastTestCase = this.mTestStatuses.entrySet().stream().findFirst().orElse(null);
                    if (lastTestCase != null && !IInstrumentationResultParser.StatusCodes.isTerminalState(((TestStatus)lastTestCase.getValue()).getTestResultCode())) {
                        for (ITestRunListener listener3 : this.mListeners) {
                            listener3.testFailed((TestIdentifier)lastTestCase.getKey(), "");
                        }
                        ((TestStatus)lastTestCase.getValue()).putTestMetrics("com.android.ddmlib.testrunner.logcat", ((TestStatus)lastTestCase.getValue()).getLogcat());
                        for (ITestRunListener listener4 : this.mListeners) {
                            listener4.testEnded((TestIdentifier)lastTestCase.getKey(), ((TestStatus)lastTestCase.getValue()).getTestMetrics());
                        }
                    }
                    for (ITestRunListener listener5 : this.mListeners) {
                        listener5.testRunFailed((String)errorMessage);
                    }
                    break;
                }
                case SESSION_FINISHED: {
                    Object errorMessage;
                    if (session2.getSessionStatus().getResultCode() == 0) {
                        errorMessage = session2.getSessionStatus().getResults().getEntriesList().stream().filter(entry -> entry.getKey().equals("shortMsg")).map(entry -> entry.getValueString()).findFirst().orElse("");
                        for (ITestRunListener listener6 : this.mListeners) {
                            listener6.testRunFailed((String)errorMessage);
                        }
                    }
                    for (InstrumentationData.ResultsBundleEntry entry3 : session2.getSessionStatus().getResults().getEntriesList()) {
                        if (IInstrumentationResultParser.StatusKeys.KNOWN_KEYS.contains(entry3.getKey())) continue;
                        testRunMetrics.put(entry3.getKey(), InstrumentationProtoResultParser.getResultsEntryBundleValueInString(entry3));
                    }
                    break;
                }
            }
            long elapsedTime = this.findElapsedTime(session2.getSessionStatus()).orElse(0L);
            ImmutableMap immutableTestRunMetrics = ImmutableMap.copyOf(testRunMetrics);
            for (ITestRunListener listener7 : this.mListeners) {
                listener7.testRunEnded(elapsedTime, (Map<String, String>)immutableTestRunMetrics);
            }
        }
    }

    private static String getResultsEntryBundleValueInString(InstrumentationData.ResultsBundleEntry entry) {
        if (entry.hasValueString()) {
            return entry.getValueString();
        }
        if (entry.hasValueInt()) {
            return String.valueOf(entry.getValueInt());
        }
        if (entry.hasValueLong()) {
            return String.valueOf(entry.getValueLong());
        }
        if (entry.hasValueFloat()) {
            return String.valueOf(entry.getValueFloat());
        }
        if (entry.hasValueDouble()) {
            return String.valueOf(entry.getValueDouble());
        }
        if (entry.hasValueBytes()) {
            return entry.getValueBytes().toString();
        }
        if (entry.hasValueBundle()) {
            return entry.getValueBundle().toString();
        }
        return "";
    }

    private void updateTestState(String testClassName, String testMethodName, int currentTestIndex, int testResultCode, String logcat, String stackTrace, LinkedHashMap<String, String> testMetrics) {
        TestIdentifier testId = new TestIdentifier(testClassName, testMethodName, currentTestIndex);
        TestStatus status2 = this.mTestStatuses.computeIfAbsent(testId, id -> {
            for (ITestRunListener listener2 : this.mListeners) {
                listener2.testStarted(testId);
            }
            return new TestStatus(1);
        });
        status2.appendLogcat(logcat);
        status2.putAllTestMetrics(testMetrics);
        if (status2.getTestResultCode() == testResultCode) {
            return;
        }
        status2.setTestResultCode(testResultCode);
        switch (testResultCode) {
            case -4: {
                for (ITestRunListener listener2 : this.mListeners) {
                    listener2.testAssumptionFailure(testId, stackTrace);
                }
                break;
            }
            case -2: 
            case -1: {
                for (ITestRunListener listener2 : this.mListeners) {
                    listener2.testFailed(testId, stackTrace);
                }
                break;
            }
            case -3: {
                for (ITestRunListener listener2 : this.mListeners) {
                    listener2.testIgnored(testId);
                }
                status2.clearLogcat();
            }
        }
        if (IInstrumentationResultParser.StatusCodes.isTerminalState(testResultCode)) {
            status2.putTestMetrics("com.android.ddmlib.testrunner.logcat", status2.getLogcat());
            for (ITestRunListener listener2 : this.mListeners) {
                listener2.testEnded(testId, status2.getTestMetrics());
            }
        }
    }

    private Optional<Long> findElapsedTime(InstrumentationData.SessionStatus sessionStatus) {
        String sessionOutput = sessionStatus.getResults().getEntriesList().stream().filter(entry -> entry.getKey().equals("stream")).map(entry -> entry.getValueString()).findFirst().orElse(null);
        if (Strings.isNullOrEmpty((String)sessionOutput)) {
            return Optional.empty();
        }
        Matcher timeMatcher = this.mTimePattern.matcher(sessionOutput);
        if (timeMatcher.find()) {
            String timeString = timeMatcher.group(1);
            try {
                float timeSeconds = NumberFormat.getInstance().parse(timeString).floatValue();
                return Optional.of((long)(timeSeconds * 1000.0f));
            }
            catch (ParseException e) {
                Log.w(LOG_TAG, String.format("Unexpected time format %1$s", timeString));
            }
        }
        Log.w(LOG_TAG, String.format("Elapsed time is missing: %1$s", sessionOutput));
        return Optional.empty();
    }

    @Override
    public void handleTestRunFailed(String errorMsg) {
        if (this.mState.isTerminalState()) {
            return;
        }
        this.mState = InstrumentationProtoResultParserState.FINISHED;
        for (ITestRunListener listener2 : this.mListeners) {
            listener2.testRunFailed(errorMsg);
        }
        for (ITestRunListener listener2 : this.mListeners) {
            listener2.testRunEnded(0L, (Map<String, String>)ImmutableMap.of());
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public void cancel() {
        this.mState = InstrumentationProtoResultParserState.CANCELLED;
    }

    @Override
    public boolean isCancelled() {
        return this.mState == InstrumentationProtoResultParserState.CANCELLED;
    }

    private static enum InstrumentationProtoResultParserState {
        NOT_STARTED(false),
        RUNNING(false),
        FINISHED(true),
        CANCELLED(true);

        private final boolean mIsTerminalState;

        private InstrumentationProtoResultParserState(boolean isTerminalState) {
            this.mIsTerminalState = isTerminalState;
        }

        public boolean isTerminalState() {
            return this.mIsTerminalState;
        }
    }

    private static class TestStatus {
        private int mTestResultCode;
        private StringBuilder mLogcat = new StringBuilder();
        private static final int MAX_LOGCAT_LENGTH = 10000;
        private final LinkedHashMap<String, String> mTestMetrics = new LinkedHashMap();

        public TestStatus(int testResultCode) {
            this.mTestResultCode = testResultCode;
        }

        public void setTestResultCode(int testResultCode) {
            this.mTestResultCode = testResultCode;
        }

        public int getTestResultCode() {
            return this.mTestResultCode;
        }

        public void appendLogcat(String logcat) {
            if (this.mLogcat.length() >= 10000) {
                return;
            }
            if (this.mLogcat.length() + logcat.length() < 10000) {
                this.mLogcat.append(logcat);
            } else {
                this.mLogcat.append(logcat.subSequence(0, 10000 - this.mLogcat.length()));
            }
        }

        public void clearLogcat() {
            this.mLogcat = new StringBuilder();
        }

        public String getLogcat() {
            return this.mLogcat.toString();
        }

        public void putTestMetrics(String key, String value) {
            this.mTestMetrics.put(key, value);
        }

        public void putAllTestMetrics(Map<String, String> testMetrics) {
            this.mTestMetrics.putAll(testMetrics);
        }

        public Map<String, String> getTestMetrics() {
            return ImmutableMap.copyOf(this.mTestMetrics);
        }
    }
}

