/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwptracer.Cmd;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.PacketParser;
import java.util.HashMap;
import java.util.Map;

class CmdSet {
    private Map<Integer, Cmd> cmds = new HashMap<Integer, Cmd>();
    private final String name;
    protected final int id;

    protected CmdSet(int id, String name) {
        this.id = id;
        this.name = name;
    }

    int id() {
        return this.id;
    }

    String name() {
        return this.name;
    }

    String cmdName(int cmdID) {
        if (!this.cmds.containsKey(cmdID)) {
            return "UNKNOWN(" + cmdID + ")";
        }
        return this.cmds.get(cmdID).getName();
    }

    void add(int cmdID, String name, PacketParser cmdParser, PacketParser replyParser) {
        this.cmds.put(cmdID, new Cmd(cmdID, name, cmdParser, replyParser));
    }

    void add(int cmdID, String name) {
        if (this.cmds.containsKey(cmdID)) {
            throw new IllegalStateException("CmdSet " + this.id + " is already registered");
        }
        this.cmds.put(cmdID, new Cmd(cmdID, name, Message::defaultMessageParser, Message::defaultMessageParser));
    }

    Cmd getCmd(int cmdId) {
        if (!this.cmds.containsKey(cmdId)) {
            return new UnknownCommand(cmdId);
        }
        return this.cmds.get(cmdId);
    }

    public static class UnknownCommand
    extends Cmd {
        public UnknownCommand(int cmdID) {
            super(cmdID, "UNKNOWN", Message::defaultMessageParser, Message::defaultMessageParser);
        }
    }
}

