/*
 * Decompiled with CFR 0.152.
 */
package com.android.jdwptracer;

import com.android.jdwppacket.MessageReader;
import com.android.jdwptracer.CmdSet;
import com.android.jdwptracer.DDMChunkHandler;
import com.android.jdwptracer.DdmJDWPTiming;
import com.android.jdwptracer.Message;
import com.android.jdwptracer.Session;
import java.util.HashMap;
import java.util.Map;

class CmdSetDdm
extends CmdSet {
    private static Map<Integer, DDMChunkHandler> ddmHandlers = new HashMap<Integer, DDMChunkHandler>();
    private static final String ART_TIMING_CHUNK = "ARTT";
    static final String HELO_CHUNK = "HELO";
    static final String APNM_CHUNK = "APNM";
    private static final String STAG_CHUNK = "STAG";
    private static final DDMChunkHandler defaultDDMHandler = new DDMChunkHandler();
    static final String WARNING_ON_EMPTY = "Cannot trace empty DDM packet";

    private static void doNothing(MessageReader reader, Session session2, Message message) {
    }

    private static void parseStagCmd(MessageReader reader, Session session2, Message message) {
        message.setName("STAG:" + CmdSetDdm.typeToName(reader.getInt()));
    }

    protected CmdSetDdm() {
        super(199, "DDM");
        this.add(1, "Packet", this::parseDdmCmd, this::parseDdmReply);
    }

    Message parseDdmReply(MessageReader reader, Session session2) {
        Message msg = new Message(reader);
        if (reader.remaining() == 0) {
            return msg;
        }
        int type = reader.getInt();
        int length = reader.getInt();
        if (reader.remaining() == 0) {
            return msg;
        }
        if (ddmHandlers.containsKey(type)) {
            ddmHandlers.get(type).getReplyParser().parse(reader, session2, msg);
        }
        return msg;
    }

    Message parseDdmCmd(MessageReader reader, Session session2) {
        Message msg = new Message(reader);
        int type = reader.getInt();
        int length = reader.getInt();
        msg.setName(CmdSetDdm.typeToName(type));
        if (ddmHandlers.containsKey(type)) {
            ddmHandlers.get(type).getCmdParser().parse(reader, session2, msg);
        } else {
            msg.setName("UNKNOWN(" + CmdSetDdm.typeToName(type) + ")");
        }
        return msg;
    }

    private static void parseArtMetricsCmd(MessageReader reader, Session session2, Message msg) {
        int version2 = reader.getInt();
        int numTimings = reader.getInt();
        msg.addArg("numTimings", numTimings);
        HashMap<Integer, DdmJDWPTiming> timings = new HashMap<Integer, DdmJDWPTiming>();
        for (int i = 0; i < numTimings; ++i) {
            int id = reader.getInt();
            int cmdset = reader.getInt();
            int cmd = reader.getInt();
            long start_ns = reader.getLong();
            long duration_ns = reader.getLong();
            timings.put(id, new DdmJDWPTiming(id, cmdset, cmd, start_ns, duration_ns));
        }
        session2.addTimings(timings);
    }

    private static void parseHELOReply(MessageReader reader, Session session2, Message msg) {
        msg.addArg("version", reader.getInt());
        msg.addArg("pid", reader.getInt());
        int vmIdentLen = reader.getInt();
        int appNameLen = reader.getInt();
        msg.addArg("vmIdent", reader.getCharString(vmIdentLen));
        String processName = reader.getCharString(appNameLen);
        msg.addArg("processName", processName);
        session2.setName(processName);
        if (!reader.hasRemaining()) {
            return;
        }
        msg.addArg("userid", reader.getInt());
        if (!reader.hasRemaining()) {
            return;
        }
        int abiLength = reader.getInt();
        msg.addArg("abi", reader.getCharString(abiLength));
        if (!reader.hasRemaining()) {
            return;
        }
        int jvmFlagsLength = reader.getInt();
        msg.addArg("jvmFlags", reader.getCharString(jvmFlagsLength));
        if (!reader.hasRemaining()) {
            return;
        }
        byte nativeDebuggableByte = reader.getByte();
        msg.addArg("nativeDebuggable", nativeDebuggableByte);
        if (!reader.hasRemaining()) {
            return;
        }
        int packageNameLength = reader.getInt();
        String packageName = reader.getCharString(packageNameLength);
        msg.addArg("packageName", packageName);
        session2.setName(packageName);
        if (!reader.hasRemaining()) {
            return;
        }
        msg.addArg("Stage", CmdSetDdm.typeToName(reader.getInt()));
    }

    private static void parseAPNMCmd(MessageReader reader, Session session2, Message msg) {
        int processNameLength = reader.getInt();
        String processName = reader.getCharString(processNameLength);
        session2.setName(processName);
        msg.addArg("processName", processName);
        if (!reader.hasRemaining()) {
            return;
        }
        int userId = reader.getInt();
        msg.addArg("userID", userId);
        if (!reader.hasRemaining()) {
            return;
        }
        int packageNameLength = reader.getInt();
        String packageName = reader.getCharString(packageNameLength);
        msg.addArg("packageName", packageName);
        session2.setName(packageName);
    }

    static String typeToName(int type) {
        char[] ascii = new char[]{(char)(type >> 24 & 0xFF), (char)(type >> 16 & 0xFF), (char)(type >> 8 & 0xFF), (char)(type & 0xFF)};
        return new String(ascii);
    }

    static int typeFromName(String name) {
        if (name.length() != 4) {
            throw new RuntimeException("DDM Type name must be 4 letter long");
        }
        int val = 0;
        for (int i = 0; i < 4; ++i) {
            val <<= 8;
            val |= (byte)name.charAt(i);
        }
        return val;
    }

    static {
        ddmHandlers.put(CmdSetDdm.typeFromName(APNM_CHUNK), new DDMChunkHandler(CmdSetDdm::parseAPNMCmd, CmdSetDdm::doNothing));
        ddmHandlers.put(CmdSetDdm.typeFromName("EXIT"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName(HELO_CHUNK), new DDMChunkHandler(CmdSetDdm::doNothing, CmdSetDdm::parseHELOReply));
        ddmHandlers.put(CmdSetDdm.typeFromName("FEAT"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("TEST"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("WAIT"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("MPRS"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("MPSS"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("MPSE"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("MPRQ"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("SPSS"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("SPSE"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPIF"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPST"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPEN"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPSG"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPGC"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPDU"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("HPDS"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("REAE"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("REAQ"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName("REAL"), defaultDDMHandler);
        ddmHandlers.put(CmdSetDdm.typeFromName(ART_TIMING_CHUNK), new DDMChunkHandler(CmdSetDdm::parseArtMetricsCmd, CmdSetDdm::doNothing));
        ddmHandlers.put(CmdSetDdm.typeFromName(STAG_CHUNK), new DDMChunkHandler(CmdSetDdm::parseStagCmd, CmdSetDdm::doNothing));
    }
}

