/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.PathUtils;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public class ArchivePathEntry
extends ArchiveEntry {
    private long rawFileSize = -1L;
    private long downloadFileSize = -1L;
    private ZipEntryInfo.Alignment zipAlignment = ZipEntryInfo.Alignment.ALIGNMENT_NONE;
    private long loadAlignment = -1L;
    private boolean isCompressed = false;
    private boolean isElf = false;
    private boolean isSelfOrChild16kbIncompatible = false;

    public ArchivePathEntry(@NotNull Archive archive, @NotNull Path path, @NotNull String pathPrefix) {
        super(archive, path, pathPrefix);
    }

    @Override
    public void setRawFileSize(long rawFileSize) {
        this.rawFileSize = rawFileSize;
    }

    @Override
    public void setFileAlignment(ZipEntryInfo.Alignment alignment) {
        this.zipAlignment = alignment;
    }

    @Override
    public ZipEntryInfo.Alignment getFileAlignment() {
        return this.zipAlignment;
    }

    @Override
    public void setElfMinimumLoadSectionAlignment(long loadAlignment) {
        this.loadAlignment = loadAlignment;
    }

    @Override
    public long getElfMinimumLoadSectionAlignment() {
        return this.loadAlignment;
    }

    @Override
    public boolean getSelfOrChild16kbIncompatible() {
        return this.isSelfOrChild16kbIncompatible;
    }

    @Override
    public void setSelfOrChild16kbIncompatible(Boolean value) {
        this.isSelfOrChild16kbIncompatible = value;
    }

    @Override
    public void setIsElf(boolean isElf) {
        this.isElf = isElf;
    }

    @Override
    public boolean getIsElf() {
        return this.isElf;
    }

    @Override
    public void setIsFileCompressed(boolean isCompressed) {
        this.isCompressed = isCompressed;
    }

    @Override
    public boolean isFileCompressed() {
        return !Files.isDirectory(this.getPath(), new LinkOption[0]) && this.isCompressed;
    }

    @Override
    public long getRawFileSize() {
        return this.rawFileSize;
    }

    @Override
    public void setDownloadFileSize(long downloadFileSize) {
        this.downloadFileSize = downloadFileSize;
    }

    @Override
    public long getDownloadFileSize() {
        return this.downloadFileSize;
    }

    @Override
    @NotNull
    public String getNodeDisplayString() {
        Path base = this.getPath().getFileName();
        String name = base == null ? "" : base.toString();
        return ArchivePathEntry.trimEnd(name, "/");
    }

    @Override
    @NotNull
    public String getSummaryDisplayString() {
        return this.getPathPrefix() + PathUtils.pathWithTrailingSeparator(this.getPath());
    }

    @NotNull
    private static String trimEnd(@NotNull String s, @NotNull String suffix) {
        boolean endsWith = s.endsWith(suffix);
        if (endsWith) {
            return s.substring(0, s.length() - suffix.length());
        }
        return s;
    }
}

