/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer;

import com.android.tools.apk.analyzer.ApkSizeCalculator;
import com.android.tools.apk.analyzer.Archive;
import com.android.tools.apk.analyzer.ArchiveContext;
import com.android.tools.apk.analyzer.ArchiveEntry;
import com.android.tools.apk.analyzer.ArchiveErrorEntry;
import com.android.tools.apk.analyzer.ArchiveManager;
import com.android.tools.apk.analyzer.ArchiveNode;
import com.android.tools.apk.analyzer.ArchivePathEntry;
import com.android.tools.apk.analyzer.ArchiveTreeStream;
import com.android.tools.apk.analyzer.InnerArchiveEntry;
import com.android.tools.apk.analyzer.ZipEntryInfo;
import com.android.tools.apk.analyzer.internal.ArchiveTreeNode;
import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Map;
import java.util.Stack;
import java.util.zip.ZipError;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NotNull;

public class ArchiveTreeStructure {
    @NotNull
    public static ArchiveNode create(@NotNull ArchiveContext archiveContext) {
        return ArchiveTreeStructure.createWorker(archiveContext.getArchiveManager(), archiveContext.getArchive(), "");
    }

    @NotNull
    private static ArchiveNode createWorker(@NotNull ArchiveManager archiveManager, @NotNull Archive archive, @NotNull String pathPrefix) {
        Path contentRoot = archive.getContentRoot();
        ArchiveTreeNode rootNode = new ArchiveTreeNode(new ArchivePathEntry(archive, contentRoot, pathPrefix));
        Stack<ArchiveTreeNode> stack = new Stack<ArchiveTreeNode>();
        stack.push(rootNode);
        while (!stack.isEmpty()) {
            ArchiveTreeNode node = (ArchiveTreeNode)stack.pop();
            Path path = node.getData().getPath();
            try {
                DirectoryStream<Path> stream = Files.newDirectoryStream(path);
                try {
                    for (Path childPath : stream) {
                        ArchiveTreeNode childNode;
                        Archive innerArchive;
                        try {
                            innerArchive = archiveManager.openInnerArchive(archive, childPath);
                        }
                        catch (IOException | ZipError e) {
                            node.add(ArchiveTreeStructure.createErrorNode(archive, childPath, pathPrefix, e));
                            continue;
                        }
                        if (innerArchive != null) {
                            ArchiveTreeNode newArchiveNode = (ArchiveTreeNode)ArchiveTreeStructure.createWorker(archiveManager, innerArchive, pathPrefix + childPath.toString());
                            childNode = new ArchiveTreeNode(new InnerArchiveEntry(archive, childPath, pathPrefix, innerArchive));
                            for (ArchiveNode archiveNodeChild : newArchiveNode.getChildren()) {
                                childNode.add((MutableTreeNode)((Object)archiveNodeChild));
                            }
                        } else {
                            childNode = new ArchiveTreeNode(new ArchivePathEntry(archive, childPath, pathPrefix));
                            if (Files.isDirectory(childPath, new LinkOption[0])) {
                                stack.push(childNode);
                            }
                        }
                        node.add(childNode);
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                node.add(new ArchiveTreeNode(new ArchiveErrorEntry(archive, path, pathPrefix, e)));
            }
        }
        return rootNode;
    }

    @NotNull
    private static ArchiveTreeNode createErrorNode(@NotNull Archive archive, @NotNull Path childPath, @NotNull String pathPrefix, @NotNull Throwable error) {
        ArchiveTreeNode childNode = new ArchiveTreeNode(new ArchivePathEntry(archive, childPath, pathPrefix));
        childNode.add(new ArchiveTreeNode(new ArchiveErrorEntry(archive, childPath, pathPrefix, error)));
        return childNode;
    }

    public static void updateFileInfo(@NotNull ArchiveNode root2, @NotNull ApkSizeCalculator calculator) {
        Map<String, ZipEntryInfo> infos = root2.getData() instanceof InnerArchiveEntry ? calculator.getInfoPerFile(((InnerArchiveEntry)root2.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getInfoPerFile(root2.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStreamNoInnerArchiveExpansion(root2).forEach(node -> {
            ZipEntryInfo info;
            ArchiveEntry data = node.getData();
            if (node != root2 && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateFileInfo(node, calculator);
            }
            if ((info = (ZipEntryInfo)infos.get(data.getPath().toString())) != null) {
                data.setRawFileSize(info.size);
                data.setIsFileCompressed(info.isCompressed);
                data.setFileAlignment(info.zipAlignment);
                data.setIsElf(info.isElf);
                if (info.isElf) {
                    data.setElfMinimumLoadSectionAlignment(info.elfLoadSectionAlignment);
                }
            }
        });
        ArchiveTreeStream.postOrderStream(root2).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getRawFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getRawFileSize()).reduce(0L, Long::sum);
                data.setRawFileSize(sizeOfAllChildren);
            }
        });
        ArchiveTreeStream.postOrderStream(root2).forEach(node -> {
            ArchiveEntry data = node.getData();
            long loadSectionAlignment = data.getElfMinimumLoadSectionAlignment();
            if (loadSectionAlignment == -1L) {
                for (ArchiveNode childNode : node.getChildren()) {
                    ArchiveEntry childData = childNode.getData();
                    if (!childData.getSelfOrChild16kbIncompatible()) continue;
                    data.setSelfOrChild16kbIncompatible(true);
                }
                return;
            }
            if (loadSectionAlignment % 16384L != 0L) {
                data.setSelfOrChild16kbIncompatible(true);
            } else if (!data.isFileCompressed() && data.getFileAlignment() != ZipEntryInfo.Alignment.ALIGNMENT_16K) {
                data.setSelfOrChild16kbIncompatible(true);
            }
        });
    }

    public static void updateDownloadFileSizes(@NotNull ArchiveNode root2, @NotNull ApkSizeCalculator calculator) {
        Map<String, Long> downloadFileSizes = root2.getData() instanceof InnerArchiveEntry ? calculator.getDownloadSizePerFile(((InnerArchiveEntry)root2.getData()).asArchiveEntry().getArchive().getPath()) : calculator.getDownloadSizePerFile(root2.getData().getArchive().getPath());
        ArchiveTreeStream.preOrderStreamNoInnerArchiveExpansion(root2).forEach(node -> {
            Long downloadFileSize;
            ArchiveEntry data = node.getData();
            if (node != root2 && data.getPath().getFileName() != null && node.getData() instanceof InnerArchiveEntry) {
                ArchiveTreeStructure.updateDownloadFileSizes(node, calculator);
            }
            if ((downloadFileSize = (Long)downloadFileSizes.get(data.getPath().toString())) != null) {
                data.setDownloadFileSize(downloadFileSize);
            }
        });
        ArchiveTreeStream.postOrderStream(root2).forEach(node -> {
            ArchiveEntry data = node.getData();
            if (data.getDownloadFileSize() < 0L && node.getChildCount() > 0) {
                Long sizeOfAllChildren = node.getChildren().stream().map(n -> n.getData().getDownloadFileSize()).reduce(0L, Long::sum);
                data.setDownloadFileSize(sizeOfAllChildren);
            }
        });
    }

    public static void sort(@NotNull ArchiveNode root2, @NotNull Comparator<ArchiveNode> comparator) {
        assert (root2 instanceof ArchiveTreeNode);
        ArchiveTreeStructure.sort((ArchiveTreeNode)root2, comparator);
    }

    private static void sort(@NotNull ArchiveTreeNode root2, @NotNull Comparator<ArchiveNode> comparator) {
        ArrayList<ArchiveNode> children = new ArrayList<ArchiveNode>(root2.getChildren());
        children.sort(comparator);
        root2.removeAllChildren();
        for (ArchiveNode child : children) {
            root2.add((ArchiveTreeNode)child);
            ArchiveTreeStructure.sort(child, comparator);
        }
    }
}

