/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.apk.analyzer.dex;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.dexbacked.DexBackedDexFile;
import com.android.tools.smali.dexlib2.dexbacked.raw.HeaderItem;
import com.android.tools.smali.dexlib2.util.DexUtil;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import org.jetbrains.annotations.NotNull;

public final class DexFiles {
    public static final int MAX_SUPPORTED_DEX_VERSION = 38;
    private static final Opcodes DEFAULT_OPCODES = Opcodes.getDefault();

    private DexFiles() {
    }

    @NotNull
    public static DexBackedDexFile getDexFile(@NotNull Path p) throws IOException {
        return DexFiles.getDexFile(Files.readAllBytes(p));
    }

    @NotNull
    public static DexBackedDexFile getDexFile(@NotNull byte[] contents) {
        try {
            return new DexBackedDexFile(DEFAULT_OPCODES, contents);
        }
        catch (DexUtil.UnsupportedFile e) {
            if (HeaderItem.getVersion((byte[])contents, (int)0) > 38) {
                contents[4] = 48;
                contents[5] = 51;
                contents[6] = 56;
                return new DexBackedDexFile(DEFAULT_OPCODES, contents);
            }
            throw e;
        }
    }
}

