/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model;

import com.android.ide.common.build.GenericBuiltArtifact;
import com.android.ide.common.build.GenericBuiltArtifacts;
import com.android.ide.common.build.GenericBuiltArtifactsLoader;
import com.android.tools.deployer.model.Apk;
import com.android.tools.deployer.model.ApkParser;
import com.android.tools.deployer.model.App;
import com.android.tools.deployer.model.BaselineProfile;
import com.android.tools.deployer.model.DeploymentStrategy;
import com.android.tools.deployer.model.PackageManagerApk;
import com.android.tools.deployer.model.component.ApkParserException;
import com.android.utils.ILogger;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB?\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u0012\b\b\u0002\u0010\n\u001a\u00020\u0003\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0014\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\u00052\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00070\u0005H\u0007J\u0014\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00052\u0006\u0010\u001c\u001a\u00020\u0003R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\n\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0013R\u001d\u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000e\u00a8\u0006\u001e"}, d2={"Lcom/android/tools/deployer/model/App;", "", "appIdInput", "", "apks", "", "Lcom/android/tools/deployer/model/DeploymentStrategy;", "Lcom/android/tools/deployer/model/Apk;", "baselineProfiles", "Lcom/android/tools/deployer/model/BaselineProfile;", "appId", "<init>", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;Ljava/lang/String;)V", "getBaselineProfiles", "()Ljava/util/List;", "getAppId", "()Ljava/lang/String;", "isDebuggable", "", "()Z", "getBaselineProfile", "Ljava/nio/file/Path;", "api", "", "getApks", "allStrategies", "getAllStrategies", "getApksForPackageManager", "abi", "Companion", "android.sdktools.deployer"})
@SourceDebugExtension(value={"SMAP\nApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 App.kt\ncom/android/tools/deployer/model/App\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1557#2:148\n1628#2,3:149\n774#2:152\n865#2,2:153\n1557#2:155\n1628#2,3:156\n*S KotlinDebug\n*F\n+ 1 App.kt\ncom/android/tools/deployer/model/App\n*L\n50#1:148\n50#1:149,3\n58#1:152\n58#1:153,2\n58#1:155\n58#1:156,3\n*E\n"})
public final class App {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final List<DeploymentStrategy<Apk>> apks;
    @NotNull
    private final List<BaselineProfile> baselineProfiles;
    @NotNull
    private final String appId;

    public App(@Nullable String appIdInput, @NotNull List<? extends DeploymentStrategy<Apk>> apks, @NotNull List<? extends BaselineProfile> baselineProfiles, @NotNull String appId) {
        Intrinsics.checkNotNullParameter(apks, (String)"apks");
        Intrinsics.checkNotNullParameter(baselineProfiles, (String)"baselineProfiles");
        Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
        this.apks = apks;
        this.baselineProfiles = baselineProfiles;
        this.appId = appId;
    }

    public /* synthetic */ App(String string2, List list2, List list3, String string3, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            list3 = CollectionsKt.emptyList();
        }
        if ((n & 8) != 0) {
            String string4 = string2;
            if (string4 == null) {
                string4 = "<empty>";
            }
            string3 = string4;
        }
        this(string2, list2, list3, string3);
    }

    @NotNull
    public final List<BaselineProfile> getBaselineProfiles() {
        return this.baselineProfiles;
    }

    @NotNull
    public final String getAppId() {
        return this.appId;
    }

    public final boolean isDebuggable() {
        return this.apks.stream().anyMatch(arg_0 -> App._get_isDebuggable_$lambda$1(App::_get_isDebuggable_$lambda$0, arg_0));
    }

    @NotNull
    public final List<Path> getBaselineProfile(int api2) {
        for (BaselineProfile bp : this.baselineProfiles) {
            if (bp.getMinApi() > api2 || api2 > bp.getMaxApi()) continue;
            List<Path> list2 = bp.getPaths();
            Intrinsics.checkNotNullExpressionValue(list2, (String)"getPaths(...)");
            return list2;
        }
        return CollectionsKt.emptyList();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated(message="This method is to be removed. Caller should be retrieving the list of APKS by a strategy")
    @NotNull
    public final List<Apk> getApks() {
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = this.apks;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            DeploymentStrategy deploymentStrategy = (DeploymentStrategy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Apk)p0.getArtifact());
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final List<DeploymentStrategy<Apk>> getAllStrategies() {
        return this.apks;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<Apk> getApksForPackageManager(@NotNull String abi) {
        void $this$mapTo$iv$iv;
        DeploymentStrategy it;
        Iterable $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)abi, (String)"abi");
        Iterable $this$filter$iv = this.apks;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (DeploymentStrategy)element$iv$iv;
            boolean bl = false;
            if (!(it.shouldSendToPackageManager() && it.shouldTargetAbi(abi))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void p0;
            it = (DeploymentStrategy)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add((Apk)p0.getArtifact());
        }
        return (List)destination$iv$iv;
    }

    private static final boolean _get_isDebuggable_$lambda$0(DeploymentStrategy it) {
        return ((Apk)it.getArtifact()).debuggable;
    }

    private static final boolean _get_isDebuggable_$lambda$1(Function1 $tmp0, Object p0) {
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    @NotNull
    public static final App fromApks(@Nullable String appId, @NotNull List<? extends Apk> apks) {
        return Companion.fromApks(appId, apks);
    }

    @JvmStatic
    @NotNull
    public static final App fromApk(@Nullable String appId, @NotNull Apk apk) {
        return Companion.fromApk(appId, apk);
    }

    @JvmStatic
    @NotNull
    public static final App fromPaths(@Nullable String appId, @NotNull List<? extends Path> paths, @NotNull List<? extends BaselineProfile> baselineProfiles) throws ApkParserException {
        return Companion.fromPaths(appId, paths, baselineProfiles);
    }

    @JvmStatic
    @NotNull
    public static final App fromPaths(@Nullable String appId, @NotNull List<? extends Path> paths) throws ApkParserException {
        return Companion.fromPaths(appId, paths);
    }

    @JvmStatic
    @NotNull
    public static final App fromStrategy(@NotNull Path path, @NotNull ILogger logger) throws ApkParserException {
        return Companion.fromStrategy(path, logger);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0007J\u001a\u0010\u000b\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\nH\u0007J\u0018\u0010\r\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u0007J.\u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\t2\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00130\tH\u0007J \u0010\u000f\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0007J\u0016\u0010\u0014\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0011J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u0017\u001a\u00020\u0018H\u0007J\u001c\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\n0\t2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\tH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/deployer/model/App$Companion;", "", "<init>", "()V", "fromApks", "Lcom/android/tools/deployer/model/App;", "appId", "", "apks", "", "Lcom/android/tools/deployer/model/Apk;", "fromApk", "apk", "fromString", "apkPath", "fromPaths", "paths", "Ljava/nio/file/Path;", "baselineProfiles", "Lcom/android/tools/deployer/model/BaselineProfile;", "fromPath", "path", "fromStrategy", "logger", "Lcom/android/utils/ILogger;", "convert", "android.sdktools.deployer"})
    @SourceDebugExtension(value={"SMAP\nApp.kt\nKotlin\n*S Kotlin\n*F\n+ 1 App.kt\ncom/android/tools/deployer/model/App$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,147:1\n1557#2:148\n1628#2,3:149\n1557#2:152\n1628#2,3:153\n1557#2:156\n1628#2,3:157\n*S KotlinDebug\n*F\n+ 1 App.kt\ncom/android/tools/deployer/model/App$Companion\n*L\n65#1:148\n65#1:149,3\n84#1:152\n84#1:153,3\n123#1:156\n123#1:157,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final App fromApks(@Nullable String appId, @NotNull List<? extends Apk> apks) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(apks, (String)"apks");
            Iterable iterable = apks;
            String string2 = appId;
            boolean $i$f$map = false;
            void var5_6 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Apk apk = (Apk)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PackageManagerApk((Apk)it, null, 2, null));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 12;
            String string3 = null;
            List list2 = null;
            List list3 = (List)destination$iv$iv;
            String string4 = string2;
            return new App(string4, list3, list2, string3, n, defaultConstructorMarker);
        }

        @JvmStatic
        @NotNull
        public final App fromApk(@Nullable String appId, @NotNull Apk apk) {
            Intrinsics.checkNotNullParameter((Object)apk, (String)"apk");
            return new App(appId, CollectionsKt.listOf((Object)new PackageManagerApk(apk, null, 2, null)), null, null, 12, null);
        }

        @NotNull
        public final App fromString(@Nullable String appId, @NotNull String apkPath) throws ApkParserException {
            Intrinsics.checkNotNullParameter((Object)apkPath, (String)"apkPath");
            Apk apk = ApkParser.parse(apkPath);
            Intrinsics.checkNotNullExpressionValue((Object)apk, (String)"parse(...)");
            return new App(appId, CollectionsKt.listOf((Object)new PackageManagerApk(apk, null, 2, null)), null, null, 12, null);
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final App fromPaths(@Nullable String appId, @NotNull List<? extends Path> paths, @NotNull List<? extends BaselineProfile> baselineProfiles) throws ApkParserException {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            Intrinsics.checkNotNullParameter(baselineProfiles, (String)"baselineProfiles");
            Iterable iterable = this.convert(paths);
            String string2 = appId;
            boolean $i$f$map = false;
            void var6_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                Apk apk = (Apk)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(new PackageManagerApk((Apk)it, null, 2, null));
            }
            DefaultConstructorMarker defaultConstructorMarker = null;
            int n = 8;
            String string3 = null;
            List<? extends BaselineProfile> list2 = baselineProfiles;
            List list3 = (List)destination$iv$iv;
            String string4 = string2;
            return new App(string4, list3, list2, string3, n, defaultConstructorMarker);
        }

        @JvmStatic
        @NotNull
        public final App fromPaths(@Nullable String appId, @NotNull List<? extends Path> paths) throws ApkParserException {
            Intrinsics.checkNotNullParameter(paths, (String)"paths");
            List apks = new ArrayList();
            List baselineProfiles = new ArrayList();
            for (Path path : paths) {
                if (StringsKt.endsWith$default((String)((Object)path).toString(), (String)".apk", (boolean)false, (int)2, null)) {
                    apks.add(path);
                    continue;
                }
                if (StringsKt.endsWith$default((String)((Object)path).toString(), (String)".dm", (boolean)false, (int)2, null)) {
                    if (baselineProfiles.isEmpty()) {
                        baselineProfiles.add(new BaselineProfile(Integer.MIN_VALUE, Integer.MAX_VALUE, new ArrayList()));
                    }
                    ((BaselineProfile)baselineProfiles.get(0)).getPaths().add(path);
                    continue;
                }
                throw new IllegalStateException("Unknown path type (neither apk nor dm):" + path);
            }
            return this.fromPaths(appId, apks, baselineProfiles);
        }

        @NotNull
        public final App fromPath(@NotNull String appId, @NotNull Path path) throws ApkParserException {
            Intrinsics.checkNotNullParameter((Object)appId, (String)"appId");
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            return this.fromPaths(appId, CollectionsKt.listOf((Object)path));
        }

        /*
         * WARNING - void declaration
         */
        @JvmStatic
        @NotNull
        public final App fromStrategy(@NotNull Path path, @NotNull ILogger logger) throws ApkParserException {
            void $this$mapTo$iv$iv;
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
            GenericBuiltArtifacts genericBuiltArtifacts = GenericBuiltArtifactsLoader.loadFromFile((File)path.toFile(), (ILogger)logger);
            if (genericBuiltArtifacts == null) {
                String string2 = "Required value was null.";
                throw new IllegalStateException(string2.toString());
            }
            GenericBuiltArtifacts artifacts = genericBuiltArtifacts;
            String applicationId = artifacts.getApplicationId();
            Iterable $this$map$iv = artifacts.getElements();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Path apkPath;
                void artifact;
                GenericBuiltArtifact genericBuiltArtifact = (GenericBuiltArtifact)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)Paths.get(artifact.getOutputFile(), new String[0]), (String)"get(...)");
                Apk apk = ApkParser.parse(((Object)apkPath.toAbsolutePath()).toString());
                Map<String, String> filters2 = artifact.getFilters().stream().collect(Collectors.toMap(arg_0 -> Companion.fromStrategy$lambda$4$lambda$2((Function1)fromStrategy.strategies.1.filters.1.INSTANCE, arg_0), arg_0 -> Companion.fromStrategy$lambda$4$lambda$3((Function1)fromStrategy.strategies.1.filters.2.INSTANCE, arg_0)));
                Intrinsics.checkNotNull((Object)apk);
                Intrinsics.checkNotNull(filters2);
                collection.add(new PackageManagerApk(apk, filters2));
            }
            List strategies2 = (List)destination$iv$iv;
            return new App(applicationId, strategies2, null, null, 12, null);
        }

        private final List<Apk> convert(List<? extends Path> paths) throws ApkParserException {
            List apks = new ArrayList();
            for (Path path : paths) {
                Apk apk = ApkParser.parse(((Object)path.toAbsolutePath()).toString());
                Intrinsics.checkNotNullExpressionValue((Object)apk, (String)"parse(...)");
                apks.add(apk);
            }
            return apks;
        }

        private static final String fromStrategy$lambda$4$lambda$2(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        private static final String fromStrategy$lambda$4$lambda$3(Function1 $tmp0, Object p0) {
            return (String)$tmp0.invoke(p0);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

