/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.deployer.model.component;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.tools.deployer.DeployerException;
import com.android.tools.deployer.model.component.AppComponent;
import com.android.tools.deployer.model.component.WearComponent;
import com.android.tools.manifest.parser.components.ManifestServiceInfo;
import com.android.utils.ILogger;

public class WatchFace
extends WearComponent {
    public WatchFace(ManifestServiceInfo info, String appId, ILogger logger) {
        super(appId, info, logger);
    }

    @Override
    public void activate(String extraFlags, AppComponent.Mode activationMode, IShellOutputReceiver receiver, IDevice device2) throws DeployerException {
        this.validate(extraFlags);
        this.logger.info("Activating WatchFace '%s' %s", new Object[]{this.info.getQualifiedName(), activationMode.equals((Object)AppComponent.Mode.DEBUG) ? "for debug" : ""});
        if (activationMode.equals((Object)AppComponent.Mode.DEBUG)) {
            this.setUpAmDebugApp(device2);
        }
        String command = this.getStartWatchFaceCommand();
        this.runStartCommand(command, receiver, this.logger, device2);
    }

    private void validate(String extraFlags) throws DeployerException {
        if (!extraFlags.isEmpty()) {
            throw DeployerException.componentActivationException(String.format("Extra flags are not supported by Watch Face. Detected flags `%s`", extraFlags));
        }
    }

    private String getStartWatchFaceCommand() {
        return "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-watchface --ecn component " + this.getFQEscapedName();
    }

    public static class ShellCommand {
        public static final String SHOW_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SYSUI --es operation show-watchface";
        public static final String SET_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation set-watchface --ecn component ";
        public static final String UNSET_WATCH_FACE = "am broadcast -a com.google.android.wearable.app.DEBUG_SURFACE --es operation unset-watchface";
    }
}

