/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.resources.ResourceType;
import com.android.tools.lint.client.api.ResourceReference;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.Collections;
import java.util.List;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UastUtils;

public class CustomViewDetector
extends Detector
implements SourceCodeScanner {
    private static final Implementation IMPLEMENTATION = new Implementation(CustomViewDetector.class, Scope.JAVA_FILE_SCOPE);
    public static final Issue ISSUE = Issue.create("CustomViewStyleable", "Mismatched Styleable/Custom View Name", "The convention for custom views is to use a `declare-styleable` whose name matches the custom view class name. The IDE relies on this convention such that for example code completion can be offered for attributes in a custom view in layout XML resource files.\n\n(Similarly, layout parameter classes should use the suffix `_Layout`.)", Category.CORRECTNESS, 6, Severity.WARNING, IMPLEMENTATION).setAndroidSpecific(true);
    private static final String OBTAIN_STYLED_ATTRIBUTES = "obtainStyledAttributes";

    @Override
    public List<String> getApplicableMethodNames() {
        return Collections.singletonList(OBTAIN_STYLED_ATTRIBUTES);
    }

    @Override
    public void visitMethodCall(JavaContext context2, UCallExpression node, PsiMethod method) {
        List arguments;
        if (!context2.getEvaluator().isMemberInSubClassOf((PsiMember)method, "android.content.Context", false)) {
            return;
        }
        int size = (arguments = node.getValueArguments()).size();
        int parameterIndex = size == 1 ? 0 : 1;
        UExpression expression = (UExpression)arguments.get(parameterIndex);
        ResourceReference reference = ResourceReference.get((UElement)expression);
        if (reference == null || reference.getType() != ResourceType.STYLEABLE) {
            return;
        }
        UClass cls = (UClass)UastUtils.getParentOfType((UElement)node, UClass.class, (boolean)false);
        if (cls == null) {
            return;
        }
        String className = cls.getName();
        String styleableName = reference.getName();
        PsiClass psiClass = cls.getJavaPsi();
        if (context2.getEvaluator().extendsClass(psiClass, "android.view.View", false)) {
            if (!styleableName.equals(className)) {
                String message = String.format("By convention, the custom view (`%1$s`) and the declare-styleable (`%2$s`) should have the same name (various editor features rely on this convention)", className, styleableName);
                context2.report(ISSUE, (UElement)node, context2.getLocation((UElement)expression), message);
            }
        } else if (context2.getEvaluator().extendsClass(psiClass, "android.view.ViewGroup.LayoutParams", false)) {
            UClass outer = (UClass)UastUtils.getParentOfType((UElement)cls, UClass.class, (boolean)true);
            if (outer == null) {
                return;
            }
            String layoutClassName = outer.getName();
            String expectedName = layoutClassName + "_Layout";
            if (!styleableName.equals(expectedName)) {
                String message = String.format("By convention, the declare-styleable (`%1$s`) for a layout parameter class (`%2$s`) is expected to be the surrounding class (`%3$s`) plus \"`_Layout`\", e.g. `%4$s`. (Various editor features rely on this convention.)", styleableName, className, layoutClassName, expectedName);
                context2.report(ISSUE, (UElement)node, context2.getLocation((UElement)expression), message);
            }
        }
    }
}

