/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Constraints;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.XmlScanner;
import com.android.utils.DomExtensions;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.USimpleNameReferenceExpression;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u00022\u00020\u0003:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u000e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007H\u0016J\u0014\u0010\t\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\u0007H\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/ForegroundServiceTypesDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/XmlScanner;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "getApplicableUastTypes", "Ljava/lang/Class;", "Lorg/jetbrains/uast/USimpleNameReferenceExpression;", "manifestHasServiceTag", "", "manifest", "Lorg/w3c/dom/Element;", "manifestHasForegroundServiceType", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "call", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "Companion", "android.sdktools.lint-checks"})
public final class ForegroundServiceTypesDetector
extends Detector
implements XmlScanner,
SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String START_FOREGROUND = "startForeground";
    @NotNull
    private static final String CLASS_SERVICE_COMPAT = "androidx.core.app.ServiceCompat";
    @NotNull
    private static final Implementation IMPLEMENTATION;
    @NotNull
    private static final Issue ISSUE_TYPE;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        return CollectionsKt.listOf((Object)START_FOREGROUND);
    }

    @NotNull
    public List<Class<USimpleNameReferenceExpression>> getApplicableUastTypes() {
        return CollectionsKt.listOf(USimpleNameReferenceExpression.class);
    }

    private final boolean manifestHasServiceTag(Element manifest) {
        Element element = DomExtensions.subtag((Element)manifest, (String)"application");
        return (element != null ? DomExtensions.subtag((Element)element, (String)"service") : null) != null;
    }

    private final boolean manifestHasForegroundServiceType(Element manifest) {
        Element element = DomExtensions.subtag((Element)manifest, (String)"application");
        if (element == null) {
            return false;
        }
        Element applicationTag = element;
        Iterator iterator = DomExtensions.subtags((Element)applicationTag, (String)"service");
        while (iterator.hasNext()) {
            Element serviceTag = (Element)iterator.next();
            String string2 = serviceTag.getAttributeNS("http://schemas.android.com/apk/res/android", "foregroundServiceType");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getAttributeNS(...)");
            if (!(((CharSequence)string2).length() > 0)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression call2, @NotNull PsiMethod method) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)call2, (String)"call");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        if (!Intrinsics.areEqual((Object)START_FOREGROUND, (Object)method.getName())) {
            return;
        }
        JavaEvaluator evaluator = context2.getEvaluator();
        if (!evaluator.isMemberInSubClassOf((PsiMember)method, "android.app.Service", false) && !evaluator.isMemberInClass((PsiMember)method, CLASS_SERVICE_COMPAT)) {
            return;
        }
        Node node = context2.getProject().getManifestDom();
        if (node == null || (node = node.getDocumentElement()) == null) {
            return;
        }
        Node manifest = node;
        if (this.manifestHasServiceTag((Element)manifest) && !this.manifestHasForegroundServiceType((Element)manifest)) {
            Incident incident = new Incident(ISSUE_TYPE, call2, context2.getNameLocation((UElement)call2), "To call `Service.startForeground()`, the `<service>` element of manifest file must have the `foregroundServiceType` attribute specified");
            context2.report(incident, Constraints.targetSdkAtLeast(34));
        }
    }

    static {
        EnumSet[] enumSetArray = new EnumSet[]{Scope.MANIFEST_SCOPE, Scope.JAVA_FILE_SCOPE};
        IMPLEMENTATION = new Implementation(ForegroundServiceTypesDetector.class, EnumSet.of((Enum)Scope.MANIFEST, (Enum)Scope.JAVA_FILE), enumSetArray);
        ISSUE_TYPE = Issue.Companion.create("ForegroundServiceType", "Missing `foregroundServiceType` attribute in manifest", "\n              For `targetSdkVersion` >= 34, to call `Service.startForeground()`, the <service> element in the \\\n              manifest file must have the `foregroundServiceType` attribute specified.\n        ", Category.CORRECTNESS, 5, Severity.ERROR, IMPLEMENTATION);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/android/tools/lint/checks/ForegroundServiceTypesDetector$Companion;", "", "<init>", "()V", "START_FOREGROUND", "", "CLASS_SERVICE_COMPAT", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "getIMPLEMENTATION", "()Lcom/android/tools/lint/detector/api/Implementation;", "ISSUE_TYPE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE_TYPE", "()Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Implementation getIMPLEMENTATION() {
            return IMPLEMENTATION;
        }

        @NotNull
        public final Issue getISSUE_TYPE() {
            return ISSUE_TYPE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

