/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.client.api.JavaEvaluator;
import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.ConstantEvaluator;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.Location;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UField;
import org.jetbrains.uast.ULambdaExpression;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UThrowExpression;
import org.jetbrains.uast.UastUtils;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u00012\u00020\u0002:\u0001\u0019B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J \u0010\u0010\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J \u0010\u0011\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J(\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\r2\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J \u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0018\u0010\u0017\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "checkJavaToUpperLowerCase", "checkStringsKt", "checkFormat", "call", "stringIndex", "", "checkLocaleGetDefault", "isLoggingParameter", "", "Companion", "android.sdktools.lint-checks"})
public final class LocaleDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(LocaleDetector.class, Scope.JAVA_FILE_SCOPE);
    @NotNull
    public static final String TO_UPPER_CASE = "toUpperCase";
    @NotNull
    public static final String TO_LOWER_CASE = "toLowerCase";
    @NotNull
    public static final String GET_DEFAULT = "getDefault";
    @NotNull
    public static final String KOTLIN_STRINGS_KT = "kotlin.text.StringsKt";
    @NotNull
    public static final String KOTLIN_STRINGS_JVM_KT = "kotlin.text.StringsKt__StringsJVMKt";
    @NotNull
    public static final String CAPITALIZE = "capitalize";
    @NotNull
    public static final String DECAPITALIZE = "decapitalize";
    @JvmField
    @NotNull
    public static final Issue STRING_LOCALE;
    @JvmField
    @NotNull
    public static final Issue FINAL_LOCALE;

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{TO_LOWER_CASE, TO_UPPER_CASE, "format", GET_DEFAULT, CAPITALIZE, DECAPITALIZE};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        block31: {
            String methodName;
            String containingClass;
            block32: {
                block30: {
                    Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                    Intrinsics.checkNotNullParameter((Object)method, (String)"method");
                    PsiClass psiClass = method.getContainingClass();
                    containingClass = psiClass != null ? psiClass.getQualifiedName() : null;
                    String string2 = method.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
                    methodName = string2;
                    if (!Intrinsics.areEqual((Object)methodName, (Object)GET_DEFAULT)) break block30;
                    if (Intrinsics.areEqual((Object)containingClass, (Object)"java.util.Locale")) {
                        this.checkLocaleGetDefault(context2, method, node);
                    }
                    break block31;
                }
                if (!Intrinsics.areEqual((Object)containingClass, (Object)"java.lang.String")) break block32;
                switch (methodName) {
                    case "format": {
                        this.checkFormat(context2, method, node, 0);
                        break;
                    }
                    case "toLowerCase": 
                    case "toUpperCase": {
                        this.checkJavaToUpperLowerCase(context2, method, node);
                    }
                }
                break block31;
            }
            if (!Intrinsics.areEqual((Object)containingClass, (Object)KOTLIN_STRINGS_JVM_KT) && !Intrinsics.areEqual((Object)containingClass, (Object)KOTLIN_STRINGS_KT)) break block31;
            switch (methodName) {
                case "format": {
                    this.checkFormat(context2, method, node, 1);
                    break;
                }
                case "decapitalize": 
                case "capitalize": {
                    this.checkStringsKt(context2, method, node);
                    break;
                }
                case "toLowerCase": 
                case "toUpperCase": {
                    this.checkStringsKt(context2, method, node);
                }
            }
        }
    }

    private final void checkJavaToUpperLowerCase(JavaContext context2, PsiMethod method, UCallExpression node) {
        if (LintClient.Companion.isStudio()) {
            return;
        }
        if (method.getParameterList().getParametersCount() != 0) {
            return;
        }
        Location location = context2.getNameLocation((UElement)node);
        Locale locale = Locale.US;
        String string2 = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        Object[] objectArray = new Object[]{method.getName()};
        String string3 = String.format(locale, string2, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"format(...)");
        String message = string3;
        JavaContext.report$default(context2, STRING_LOCALE, (UElement)node, location, message, null, 16, null);
    }

    private final void checkStringsKt(JavaContext context2, PsiMethod method, UCallExpression node) {
        if (method.getParameterList().getParametersCount() > 1) {
            return;
        }
        Location location = context2.getNameLocation((UElement)node);
        Locale locale = Locale.US;
        Object object = "Implicitly using the default locale is a common source of bugs: Use `%1$s(Locale)` instead. For strings meant to be internal use `Locale.ROOT`, otherwise `Locale.getDefault()`.";
        Object[] objectArray = new Object[]{method.getName()};
        String string2 = String.format(locale, (String)object, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String message = string2;
        Location range = context2.getCallLocation(node, false, true);
        Object groupBuilder = object = this.fix().group();
        boolean bl = false;
        Object[] objectArray2 = new String[]{"ROOT", "getDefault()"};
        for (String localeName : CollectionsKt.listOf((Object[])objectArray2)) {
            ((LintFix.GroupBuilder)groupBuilder).add(this.fix().name("Replace with `" + method.getName() + "(Locale." + localeName + ")`").sharedName("Use explicit locale").replace().range(range).with(method.getName() + "(java.util.Locale." + localeName + ")").shortenNames().build());
        }
        LintFix quickfixData = ((LintFix.GroupBuilder)object).build();
        context2.report(STRING_LOCALE, (UElement)node, location, message, quickfixData);
    }

    private final void checkFormat(JavaContext context2, PsiMethod method, UCallExpression call2, int stringIndex) {
        if (method.getParameterList().getParametersCount() <= stringIndex || !context2.getEvaluator().parameterHasType(method, stringIndex, "java.lang.String")) {
            return;
        }
        List expressions = call2.getValueArguments();
        if (expressions.isEmpty()) {
            return;
        }
        UExpression first = (UExpression)expressions.get(0);
        Object object = ConstantEvaluator.evaluate(context2, (UElement)first);
        String string2 = object instanceof String ? (String)object : null;
        if (string2 == null) {
            return;
        }
        String value = string2;
        if (StringFormatDetector.Companion.isLocaleSpecific(value)) {
            if (this.isLoggingParameter(context2, call2)) {
                return;
            }
            if (UastUtils.getParentOfType((UElement)((UElement)call2), UThrowExpression.class, (boolean)true) != null) {
                return;
            }
            Location location = Intrinsics.areEqual((Object)"format", (Object)Lint.getMethodName(call2)) ? context2.getCallLocation(call2, true, true) : context2.getCallLocation(call2, false, true);
            String message = "Implicitly using the default locale is a common source of bugs: Use `String.format(Locale, ...)` instead";
            JavaContext.report$default(context2, STRING_LOCALE, (UElement)call2, location, message, null, 16, null);
        }
    }

    private final void checkLocaleGetDefault(JavaContext context2, PsiMethod method, UCallExpression node) {
        Class[] classArray = new Class[]{UMethod.class, ULambdaExpression.class};
        UField uField = (UField)UastUtils.getParentOfType((UElement)((UElement)node), UField.class, (boolean)true, (Class[])classArray);
        if (uField == null) {
            return;
        }
        UField field = uField;
        JavaEvaluator evaluator = context2.getEvaluator();
        if (evaluator.isStatic((PsiModifierListOwner)field) && evaluator.isFinal((PsiModifierListOwner)field)) {
            JavaContext.report$default(context2, FINAL_LOCALE, (UElement)node, context2.getLocation((UElement)node), "Assigning `Locale.getDefault()` to a final static field is suspicious; this code will not work correctly if the user changes locale while the app is running", null, 16, null);
        }
    }

    private final boolean isLoggingParameter(JavaContext context2, UCallExpression node) {
        String name;
        UCallExpression parentCall = (UCallExpression)UastUtils.getParentOfType((UElement)((UElement)node), UCallExpression.class, (boolean)true);
        if (parentCall != null && (name = Lint.getMethodName(parentCall)) != null && name.length() == 1) {
            PsiMethod method = parentCall.resolve();
            return context2.getEvaluator().isMemberInClass((PsiMember)method, "android.util.Log");
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.WARNING;
        Implementation implementation = IMPLEMENTATION;
        STRING_LOCALE = Issue.Companion.create$default(companion, "DefaultLocale", "Implied default locale in case conversion", "\n                Calling `String#toLowerCase()` or `#toUpperCase()` **without specifying an \\\n                explicit locale** is a common source of bugs. The reason for that is that \\\n                those methods will use the current locale on the user's device, and even \\\n                though the code appears to work correctly when you are developing the app, \\\n                it will fail in some locales. For example, in the Turkish locale, the \\\n                uppercase replacement for `i` is **not** `I`.\n\n                If you want the methods to just perform ASCII replacement, for example to \\\n                convert an enum name, call `String#toUpperCase(Locale.ROOT)` instead. If you \\\n                really want to use the current locale, call \\\n                `String#toUpperCase(Locale.getDefault())` instead.\n                ", implementation, "https://developer.android.com/reference/java/util/Locale.html#default_locale", category, 6, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.I18N;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        FINAL_LOCALE = Issue.Companion.create$default(companion, "ConstantLocale", "Constant Locale", "\n                Assigning `Locale.getDefault()` to a constant is suspicious, because \\\n                the locale can change while the app is running.", implementation, null, category, 6, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u00020\u000f8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/LocaleDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "TO_UPPER_CASE", "", "TO_LOWER_CASE", "GET_DEFAULT", "KOTLIN_STRINGS_KT", "KOTLIN_STRINGS_JVM_KT", "CAPITALIZE", "DECAPITALIZE", "STRING_LOCALE", "Lcom/android/tools/lint/detector/api/Issue;", "FINAL_LOCALE", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

