/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.rendering.api.ResourceNamespace;
import com.android.ide.common.resources.ResourceItem;
import com.android.ide.common.resources.ResourceRepository;
import com.android.ide.common.util.PathString;
import com.android.resources.ResourceType;
import com.android.resources.ResourceUrl;
import com.android.tools.lint.client.api.ResourceRepositoryScope;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Context;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.JavaContext;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.LintMap;
import com.android.tools.lint.detector.api.ResourceEvaluator;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.SourceCodeScanner;
import com.android.tools.lint.detector.api.UastLintUtilsKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.io.IOException;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UBlockExpression;
import org.jetbrains.uast.UCallExpression;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UExpression;
import org.jetbrains.uast.UIdentifier;
import org.jetbrains.uast.ULocalVariable;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.UastUtils;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 &2\u00020\u00012\u00020\u0002:\u0001&B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u000e\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0016J \u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J&\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00140\u00062\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J \u0010\u0016\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J(\u0010\u001b\u001a\u00020\u00182\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0007H\u0002J\u001a\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001f\u001a\u00020\rH\u0002J\u001a\u0010 \u001a\u0004\u0018\u00010\u001e2\u0006\u0010!\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0002J\"\u0010\"\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010%\u001a\u00020\u0007H\u0002\u00a8\u0006'"}, d2={"Lcom/android/tools/lint/checks/MissingInflatedIdDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/SourceCodeScanner;", "<init>", "()V", "getApplicableMethodNames", "", "", "visitMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/JavaContext;", "node", "Lorg/jetbrains/uast/UCallExpression;", "method", "Lcom/intellij/psi/PsiMethod;", "layoutMissingId", "", "Lcom/android/tools/lint/detector/api/Context;", "layouts", "Lcom/android/ide/common/resources/ResourceItem;", "id", "filterIncident", "incident", "Lcom/android/tools/lint/detector/api/Incident;", "map", "Lcom/android/tools/lint/detector/api/LintMap;", "createIncident", "layout", "findLayout", "Lcom/android/resources/ResourceUrl;", "call", "getFirstArgAsResource", "setContentView", "definesId", "file", "Lcom/android/ide/common/util/PathString;", "targetId", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nMissingInflatedIdDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MissingInflatedIdDetector.kt\ncom/android/tools/lint/checks/MissingInflatedIdDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 UastUtils.kt\norg/jetbrains/uast/UastUtils__UastUtilsKt\n*L\n1#1,244:1\n2632#2,3:245\n18#3:248\n*S KotlinDebug\n*F\n+ 1 MissingInflatedIdDetector.kt\ncom/android/tools/lint/checks/MissingInflatedIdDetector\n*L\n116#1:245,3\n155#1:248\n*E\n"})
public final class MissingInflatedIdDetector
extends Detector
implements SourceCodeScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;
    @NotNull
    private static final String KEY_LAYOUT = "layout";
    @NotNull
    private static final String KEY_ID = "id";

    @Override
    @NotNull
    public List<String> getApplicableMethodNames() {
        Object[] objectArray = new String[]{"findViewById", "requireViewById"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    public void visitMethodCall(@NotNull JavaContext context2, @NotNull UCallExpression node, @NotNull PsiMethod method) {
        LintMap lintMap;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Object object = this.findLayout(context2, node);
        if (object == null || (object = object.name) == null) {
            return;
        }
        Object layout = object;
        Object object2 = this.getFirstArgAsResource(node, context2);
        if (object2 == null || (object2 = object2.name) == null) {
            return;
        }
        Object id = object2;
        boolean globalAnalysis = context2.isGlobalAnalysis();
        ResourceRepository resources = globalAnalysis ? context2.getClient().getResources(context2.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES) : context2.getClient().getResources(context2.getProject(), ResourceRepositoryScope.PROJECT_ONLY);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, (String)layout);
        Intrinsics.checkNotNull((Object)items);
        if (!((Collection)items).isEmpty()) {
            if (this.layoutMissingId(context2, items, (String)id)) {
                Incident incident = this.createIncident(context2, node, (String)layout, (String)id);
                context2.report(incident);
            }
            return;
        }
        if (globalAnalysis) {
            return;
        }
        if (context2.getDriver().isSuppressed(context2, ISSUE, (UElement)node)) {
            return;
        }
        LintMap $this$visitMethodCall_u24lambda_u240 = lintMap = this.map();
        boolean bl = false;
        $this$visitMethodCall_u24lambda_u240.put(KEY_LAYOUT, (String)layout);
        $this$visitMethodCall_u24lambda_u240.put(KEY_ID, (String)id);
        LintMap map2 = lintMap;
        context2.report(this.createIncident(context2, node, (String)layout, (String)id), map2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean layoutMissingId(Context context2, List<? extends ResourceItem> layouts, String id) {
        ResourceItem it;
        if (((Collection)layouts).isEmpty()) return false;
        boolean bl = true;
        if (!bl) return false;
        Iterable $this$none$iv = layouts;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            return true;
        }
        Iterator iterator = $this$none$iv.iterator();
        do {
            if (!iterator.hasNext()) return true;
            Object element$iv = iterator.next();
            it = (ResourceItem)element$iv;
            boolean bl2 = false;
        } while (!this.definesId(context2, it.getSource(), id));
        return false;
    }

    @Override
    public boolean filterIncident(@NotNull Context context2, @NotNull Incident incident, @NotNull LintMap map2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)incident, (String)"incident");
        Intrinsics.checkNotNullParameter((Object)map2, (String)"map");
        String string2 = map2.get(KEY_LAYOUT);
        if (string2 == null) {
            return false;
        }
        String layout = string2;
        String string3 = map2.get(KEY_ID);
        if (string3 == null) {
            return false;
        }
        String id = string3;
        ResourceRepository resources = context2.getClient().getResources(context2.getMainProject(), ResourceRepositoryScope.LOCAL_DEPENDENCIES);
        List items = resources.getResources(ResourceNamespace.TODO(), ResourceType.LAYOUT, layout);
        Intrinsics.checkNotNull((Object)items);
        return this.layoutMissingId(context2, items, id);
    }

    private final Incident createIncident(JavaContext context2, UCallExpression node, String layout, String id) {
        String message = "`@layout/" + layout + "` does not contain a declaration with id `" + id + "`";
        UExpression idArgument = (UExpression)CollectionsKt.first((List)node.getValueArguments());
        Incident incident = new Incident(ISSUE, idArgument, context2.getLocation((UElement)idArgument), message);
        return incident;
    }

    /*
     * WARNING - void declaration
     */
    private final ResourceUrl findLayout(JavaContext context2, UCallExpression call2) {
        void $this$getParentOfType$iv;
        UExpression receiver;
        UExpression uExpression = call2.getReceiver();
        Object object = receiver = uExpression != null ? UastUtils.skipParenthesizedExprDown((UExpression)uExpression) : null;
        if (receiver != null) {
            PsiElement psiElement = UastUtils.tryResolve((UElement)((UElement)receiver));
            UElement uElement = psiElement != null ? UastContextKt.toUElement((PsiElement)psiElement) : null;
            ULocalVariable uLocalVariable = uElement instanceof ULocalVariable ? (ULocalVariable)uElement : null;
            if (uLocalVariable == null) {
                return null;
            }
            ULocalVariable variable = uLocalVariable;
            UExpression uExpression2 = variable.getUastInitializer();
            UElement uElement2 = uExpression2 != null ? UastLintUtilsKt.findSelector((UElement)uExpression2) : null;
            UCallExpression uCallExpression = uElement2 instanceof UCallExpression ? (UCallExpression)uElement2 : null;
            if (uCallExpression == null) {
                return null;
            }
            UCallExpression inflation = uCallExpression;
            if (!Intrinsics.areEqual((Object)inflation.getMethodName(), (Object)"inflate")) {
                return null;
            }
            return this.getFirstArgAsResource(inflation, context2);
        }
        UElement uElement = (UElement)call2;
        boolean strict$iv = true;
        boolean $i$f$getParentOfType = false;
        UBlockExpression uBlockExpression = (UBlockExpression)UastUtils.getParentOfType((UElement)$this$getParentOfType$iv, UBlockExpression.class, (boolean)strict$iv);
        if (uBlockExpression == null) {
            return null;
        }
        UBlockExpression block = uBlockExpression;
        for (UExpression expression : block.getExpressions()) {
            UCallExpression setContentView;
            UExpression uExpression3 = UastUtils.skipParenthesizedExprDown((UExpression)expression);
            if ((uExpression3 instanceof UCallExpression ? (UCallExpression)uExpression3 : null) == null) continue;
            setContentView = setContentView;
            UIdentifier uIdentifier = setContentView.getMethodIdentifier();
            if (!Intrinsics.areEqual((Object)(uIdentifier != null ? uIdentifier.getName() : null), (Object)"setContentView")) continue;
            return this.getFirstArgAsResource(setContentView, context2);
        }
        return null;
    }

    private final ResourceUrl getFirstArgAsResource(UCallExpression setContentView, JavaContext context2) {
        UExpression uExpression = (UExpression)CollectionsKt.firstOrNull((List)setContentView.getValueArguments());
        if (uExpression == null || (uExpression = UastUtils.skipParenthesizedExprDown((UExpression)uExpression)) == null) {
            return null;
        }
        UExpression resourceArgument = uExpression;
        ResourceUrl resourceUrl = ResourceEvaluator.getResource(context2.getEvaluator(), (UElement)resourceArgument);
        if (resourceUrl == null) {
            return null;
        }
        ResourceUrl url = resourceUrl;
        return !url.isFramework() ? url : null;
    }

    private final boolean definesId(Context context2, PathString file, String targetId) {
        XmlPullParser xmlPullParser;
        if (file == null) {
            return true;
        }
        try {
            XmlPullParser xmlPullParser2 = context2.getClient().createXmlPullParser(file);
            if (xmlPullParser2 == null) {
                return true;
            }
            xmlPullParser = xmlPullParser2;
        }
        catch (IOException ignore) {
            return true;
        }
        XmlPullParser parser2 = xmlPullParser;
        try {
            block8: while (true) {
                int event = parser2.next();
                switch (event) {
                    case 2: {
                        if (Intrinsics.areEqual((Object)parser2.getName(), (Object)"include")) {
                            return true;
                        }
                        String id = parser2.getAttributeValue("http://schemas.android.com/apk/res/android", KEY_ID);
                        if (id == null || !StringsKt.endsWith$default((String)id, (String)targetId, (boolean)false, (int)2, null) || !Intrinsics.areEqual((Object)Lint.stripIdPrefix(id), (Object)targetId)) continue block8;
                        return true;
                    }
                    case 1: {
                        return false;
                    }
                }
            }
        }
        catch (XmlPullParserException ignore) {
            return true;
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.CORRECTNESS;
        Severity severity = Severity.ERROR;
        EnumSet[] enumSetArray = new EnumSet[]{Scope.JAVA_FILE_SCOPE};
        Implementation implementation = new Implementation(MissingInflatedIdDetector.class, EnumSet.of((Enum)Scope.ALL_RESOURCE_FILES, (Enum)Scope.ALL_JAVA_FILES), enumSetArray);
        ISSUE = Issue.Companion.create$default(companion, "MissingInflatedId", "ID not found in inflated resource", "\n          Checks calls to layout inflation and makes sure that the referenced ids \\\n          are found in the corresponding layout (or at least one of them, if the \\\n          layout has multiple configurations.)\n          ", implementation, null, category, 5, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lcom/android/tools/lint/checks/MissingInflatedIdDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "KEY_LAYOUT", "", "KEY_ID", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

