/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.ide.common.resources.configuration.LocaleQualifier;
import com.android.resources.ResourceFolderType;
import com.android.tools.lint.checks.PluralExample;
import com.android.tools.lint.checks.PluralExamplesLookup;
import com.android.tools.lint.checks.PluralsDatabase;
import com.android.tools.lint.checks.StringFormatDetector;
import com.android.tools.lint.checks.TranslationDetector;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Lint;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u000e\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tH\u0016J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/android/tools/lint/checks/PluralsDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "appliesTo", "", "folderType", "Lcom/android/resources/ResourceFolderType;", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nPluralsDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PluralsDetector.kt\ncom/android/tools/lint/checks/PluralsDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,293:1\n1557#2:294\n1628#2,3:295\n1734#2,3:298\n*S KotlinDebug\n*F\n+ 1 PluralsDetector.kt\ncom/android/tools/lint/checks/PluralsDetector\n*L\n128#1:294\n128#1:295,3\n145#1:298,3\n*E\n"})
public final class PluralsDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Implementation IMPLEMENTATION = new Implementation(PluralsDetector.class, Scope.RESOURCE_FILE_SCOPE);
    @JvmField
    @NotNull
    public static final Issue MISSING;
    @JvmField
    @NotNull
    public static final Issue EXTRA;
    @JvmField
    @NotNull
    public static final Issue IMPLIED_QUANTITY;

    @Override
    public boolean appliesTo(@NotNull ResourceFolderType folderType) {
        Intrinsics.checkNotNullParameter((Object)folderType, (String)"folderType");
        return folderType == ResourceFolderType.VALUES;
    }

    @NotNull
    public List<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"plurals");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        Object append;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        int count = Lint.getChildCount(element);
        if (count == 0) {
            XmlContext.report$default(context2, MISSING, element, context2.getLocation(element), "There should be at least one quantity string in this `<plural>` definition", null, 16, null);
            return;
        }
        LocaleQualifier locale = Lint.getLocale(context2);
        if (locale == null || !locale.hasLanguage()) {
            return;
        }
        String string2 = locale.getLanguage();
        Intrinsics.checkNotNull((Object)string2);
        String language = string2;
        PluralsDatabase plurals = PluralsDatabase.Companion.get(context2.getProject().getTargetSdk());
        EnumSet<PluralsDatabase.Quantity> enumSet = plurals.getRelevant(language);
        if (enumSet == null) {
            return;
        }
        EnumSet<PluralsDatabase.Quantity> relevant = enumSet;
        EnumSet<PluralsDatabase.Quantity> defined = EnumSet.noneOf(PluralsDatabase.Quantity.class);
        NodeList children = element.getChildNodes();
        int i = 0;
        int n = children.getLength();
        while (i < n) {
            Node node = children.item(i);
            if (node.getNodeType() != 1) {
                ++i;
                continue;
            }
            Intrinsics.checkNotNull((Object)node, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
            Element child = (Element)node;
            if (!Intrinsics.areEqual((Object)"item", (Object)child.getTagName())) {
                ++i;
                continue;
            }
            String quantityString = child.getAttribute("quantity");
            Intrinsics.checkNotNull((Object)quantityString);
            if (((CharSequence)quantityString).length() == 0) {
                ++i;
                continue;
            }
            PluralsDatabase.Quantity quantity = PluralsDatabase.Quantity.Companion.get(quantityString);
            if (quantity == null || quantity == PluralsDatabase.Quantity.other) {
                ++i;
                continue;
            }
            defined.add(quantity);
            if (plurals.hasMultipleValuesForQuantity(language, quantity) && !PluralsDetector.Companion.haveFormattingParameter(child) && context2.isEnabled(IMPLIED_QUANTITY)) {
                String example = plurals.findIntegerExamples(language, quantity);
                append = example == null ? "" : " (" + example + ")";
                String message = StringsKt.trimIndent((String)("\n                    The quantity `'" + quantity + "'` matches more than one specific number in this locale" + (String)append + ", but the message did not \\\n                    include a formatting argument (such as `%d`). This is usually an internationalization error. See full issue \\\n                    explanation for more.\n                    "));
                XmlContext.report$default(context2, IMPLIED_QUANTITY, child, context2.getLocation(child), message, null, 16, null);
            }
            ++i;
        }
        if (Intrinsics.areEqual(relevant, defined)) {
            return;
        }
        Object object = relevant.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"clone(...)");
        Object missing = object;
        Intrinsics.checkNotNull(defined);
        ((AbstractSet)missing).removeAll((Collection)defined);
        if (!((AbstractCollection)missing).isEmpty()) {
            void $this$mapTo$iv$iv;
            PluralExamplesLookup examplesLookup = PluralExamplesLookup.Companion.getInstance();
            Iterable $this$map$iv = (Iterable)missing;
            boolean $i$f$map = false;
            append = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                String example;
                void form;
                PluralsDatabase.Quantity quantity = (PluralsDatabase.Quantity)((Object)item$iv$iv);
                Collection collection = destination$iv$iv;
                boolean bl = false;
                PluralExample pluralExample = examplesLookup.findExample(language, form.name());
                String string3 = example = pluralExample != null ? pluralExample.formattedWithNumber() : null;
                collection.add(example != null ? "`" + form.name() + "` (e.g. \"" + example + "\")" : "`" + form.name() + "`");
            }
            List withExamples = (List)destination$iv$iv;
            String languageDescription = TranslationDetector.Companion.getLanguageDescription(language);
            String message = withExamples.size() == 1 ? "For locale " + languageDescription + " the following quantity should also be defined: " + CollectionsKt.single((List)withExamples) : "For locale " + languageDescription + " the following quantities should also be defined: " + CollectionsKt.joinToString$default((Iterable)withExamples, (CharSequence)", ", null, null, (int)0, null, null, (int)62, null);
            Incident incident = new Incident(MISSING, element, context2.getLocation(element), message);
            EnumSet<PluralsDatabase.Quantity> baselineDatabase = PluralsDatabase.Companion.getOLDEST().getRelevant(language);
            if (baselineDatabase != null) {
                boolean bl;
                block18: {
                    Iterable $this$all$iv = (Iterable)missing;
                    boolean $i$f$all = false;
                    if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                        bl = true;
                    } else {
                        for (Object element$iv : $this$all$iv) {
                            PluralsDatabase.Quantity it = (PluralsDatabase.Quantity)((Object)element$iv);
                            boolean bl2 = false;
                            if (!baselineDatabase.contains((Object)it)) continue;
                            bl = false;
                            break block18;
                        }
                        bl = true;
                    }
                }
                if (bl) {
                    incident.overrideSeverity(Severity.WARNING);
                }
            }
            context2.report(incident);
        }
        Object object2 = defined.clone();
        Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"clone(...)");
        Object extra = object2;
        ((AbstractSet)extra).removeAll((Collection)relevant);
        if (!((Collection)extra).isEmpty()) {
            String string4 = "For language %1$s the following quantities are not relevant: %2$s";
            Object[] objectArray = new Object[]{TranslationDetector.Companion.getLanguageDescription(language), PluralsDatabase.Quantity.Companion.formatSet((EnumSet<PluralsDatabase.Quantity>)extra)};
            String string5 = String.format(string4, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"format(...)");
            String message = string5;
            XmlContext.report$default(context2, EXTRA, element, context2.getLocation(element), message, null, 16, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.MESSAGES;
        Severity severity = Severity.ERROR;
        Implementation implementation = IMPLEMENTATION;
        MISSING = Issue.Companion.create$default(companion, "MissingQuantity", "Missing quantity translation", "\n                Different languages have different rules for grammatical agreement with quantity. In English, for example, the quantity 1 \\\n                is a special case. We write \"1 book\", but for any other quantity we'd write \"n books\". This distinction between singular \\\n                and plural is very common, but other languages make finer distinctions.\n\n                This lint check looks at each translation of a `<plural>` and makes sure that all the quantity strings considered by the \\\n                given language are provided by this translation.\n\n                For example, an English translation must provide a string for `quantity=\"one\"`. Similarly, a Czech translation must \\\n                provide a string for `quantity=\"few\"`.\n            ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 8, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.MESSAGES;
        severity = Severity.WARNING;
        implementation = IMPLEMENTATION;
        EXTRA = Issue.Companion.create$default(companion, "UnusedQuantity", "Unused quantity translations", "\n                Android defines a number of different quantity strings, such as `zero`, `one`, `few` and `many`. However, many languages \\\n                do not distinguish grammatically between all these different quantities.\n\n                This lint check looks at the quantity strings defined for each translation and flags any quantity strings that are unused \\\n                (because the language does not make that quantity distinction, and Android will therefore not look it up).\n\n                For example, in Chinese, only the `other` quantity is used, so even if you provide translations for `zero` and `one`, \\\n                these strings will **not** be returned when `getQuantityString()` is called, even with `0` or `1`.\n            ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 3, severity, false, null, null, null, 3840, null);
        companion = Issue.Companion;
        category = Category.MESSAGES;
        severity = Severity.ERROR;
        implementation = IMPLEMENTATION;
        IMPLIED_QUANTITY = Issue.Companion.create$default(companion, "ImpliedQuantity", "Implied Quantities", "\n                Plural strings should generally include a `%s` or `%d` formatting argument. In locales like English, the `one` quantity \\\n                only applies to a single value, 1, but that's not true everywhere. For example, in Slovene, the `one` quantity will apply \\\n                to 1, 101, 201, 301, and so on. Similarly, there are locales where multiple values match the `zero` and `two` quantities.\n\n                In these locales, it is usually an error to have a message which does not include a formatting argument (such as '%d'), \\\n                since it will not be clear from the grammar what quantity the quantity string is describing.\n                ", implementation, "https://developer.android.com/guide/topics/resources/string-resource.html#Plurals", category, 5, severity, false, null, null, null, 3840, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0010\u0010\u000e\u001a\u00020\u000b2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0006\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u00020\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/PluralsDetector$Companion;", "", "<init>", "()V", "IMPLEMENTATION", "Lcom/android/tools/lint/detector/api/Implementation;", "MISSING", "Lcom/android/tools/lint/detector/api/Issue;", "EXTRA", "IMPLIED_QUANTITY", "haveFormattingParameter", "", "element", "Lorg/w3c/dom/Element;", "containsExpandTemplate", "text", "", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        private final boolean haveFormattingParameter(Element element) {
            NodeList children = element.getChildNodes();
            int i = 0;
            int n = children.getLength();
            while (i < n) {
                Node child = children.item(i);
                short nodeType = child.getNodeType();
                if (nodeType == 1) {
                    Intrinsics.checkNotNull((Object)child, (String)"null cannot be cast to non-null type org.w3c.dom.Element");
                    if (this.haveFormattingParameter((Element)child)) {
                        return true;
                    }
                } else if (nodeType == 3 || nodeType == 4) {
                    String text = child.getNodeValue();
                    Intrinsics.checkNotNull((Object)text);
                    if (this.containsExpandTemplate(text)) {
                        return true;
                    }
                    if (StringsKt.indexOf$default((CharSequence)text, (char)'%', (int)0, (boolean)false, (int)6, null) == -1) {
                        ++i;
                        continue;
                    }
                    if (StringFormatDetector.Companion.getFormatArgumentCount(text, null) >= 1) {
                        return true;
                    }
                }
                ++i;
            }
            return false;
        }

        private final boolean containsExpandTemplate(String text) {
            int index2 = 0;
            while ((index2 = StringsKt.indexOf$default((CharSequence)text, (char)'^', (int)index2, (boolean)false, (int)4, null)) != -1 && index2 != text.length() - 1) {
                if (Character.isDigit(text.charAt(index2 + 1))) {
                    return true;
                }
                ++index2;
            }
            return false;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

