/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.client.api.LintClient;
import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Detector;
import com.android.tools.lint.detector.api.GradleContext;
import com.android.tools.lint.detector.api.GradleScanner;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Incident;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010$\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\u0018\u0000 \u00132\u00020\u00012\u00020\u0002:\u0001\u0013B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004JV\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\n2\b\u0010\f\u001a\u0004\u0018\u00010\n2\u0012\u0010\r\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/lint/checks/ProguardAndroidTxtDetector;", "Lcom/android/tools/lint/detector/api/Detector;", "Lcom/android/tools/lint/detector/api/GradleScanner;", "<init>", "()V", "checkMethodCall", "", "context", "Lcom/android/tools/lint/detector/api/GradleContext;", "statement", "", "parent", "parentParent", "namedArguments", "", "unnamedArguments", "", "cookie", "", "Companion", "android.sdktools.lint-checks"})
@SourceDebugExtension(value={"SMAP\nProguardAndroidTxtDetector.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ProguardAndroidTxtDetector.kt\ncom/android/tools/lint/checks/ProguardAndroidTxtDetector\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,85:1\n1755#2,3:86\n1755#2,3:89\n*S KotlinDebug\n*F\n+ 1 ProguardAndroidTxtDetector.kt\ncom/android/tools/lint/checks/ProguardAndroidTxtDetector\n*L\n44#1:86,3\n45#1:89,3\n*E\n"})
public final class ProguardAndroidTxtDetector
extends Detector
implements GradleScanner {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Issue ISSUE;

    @Override
    public void checkMethodCall(@NotNull GradleContext context2, @NotNull String statement, @Nullable String parent, @Nullable String parentParent, @NotNull Map<String, String> namedArguments, @NotNull List<String> unnamedArguments, @NotNull Object cookie) {
        block13: {
            block14: {
                boolean bl;
                block12: {
                    String it;
                    boolean bl2;
                    boolean $i$f$any;
                    Iterable $this$any$iv;
                    block11: {
                        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
                        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
                        Intrinsics.checkNotNullParameter(namedArguments, (String)"namedArguments");
                        Intrinsics.checkNotNullParameter(unnamedArguments, (String)"unnamedArguments");
                        Intrinsics.checkNotNullParameter((Object)cookie, (String)"cookie");
                        if (context2.getProject().isLibrary()) {
                            return;
                        }
                        if (!Intrinsics.areEqual((Object)statement, (Object)"getDefaultProguardFile")) break block13;
                        $this$any$iv = unnamedArguments;
                        $i$f$any = false;
                        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                            bl2 = false;
                        } else {
                            for (Object element$iv : $this$any$iv) {
                                it = (String)element$iv;
                                boolean bl3 = false;
                                if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"proguard-android.txt", (boolean)false, (int)2, null)) continue;
                                bl2 = true;
                                break block11;
                            }
                            bl2 = false;
                        }
                    }
                    if (bl2) break block14;
                    $this$any$iv = namedArguments.values();
                    $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            it = (String)element$iv;
                            boolean bl4 = false;
                            if (!StringsKt.contains$default((CharSequence)it, (CharSequence)"proguard-android.txt", (boolean)false, (int)2, null)) continue;
                            bl = true;
                            break block12;
                        }
                        bl = false;
                    }
                }
                if (!bl) break block13;
            }
            Incident incident = new Incident(ISSUE, cookie, context2.getLocation(cookie), "Avoid `getDefaultProguardFile('proguard-android.txt')`", this.fix().replace().pattern("proguard-android.txt").with("proguard-android-optimize.txt").build());
            LintClient.report$default(context2.getClient(), context2, incident, null, 4, null);
        }
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.PERFORMANCE;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(ProguardAndroidTxtDetector.class, Scope.GRADLE_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "ProguardAndroidTxtUsage", "Use proguard-android-optimize.txt to enable optimizations", "Support for `getDefaultProguardFile('proguard-android.txt')` will be removed in AGP 9.0 since it includes `-dontoptimize`, which prevents R8 from performing many optimizations. Instead use `getDefaultProguardFile('proguard-android-optimize.txt)`, and if needed, temporarily use `-dontoptimize` in a custom keep rule file while fixing breakages.", implementation, "https://developer.android.com/topic/performance/app-optimization/enable-app-optimization", category, 2, severity, false, true, null, null, 3328, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/android/tools/lint/checks/ProguardAndroidTxtDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "getISSUE", "()Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Issue getISSUE() {
            return ISSUE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

