/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.lint.checks;

import com.android.tools.lint.detector.api.Category;
import com.android.tools.lint.detector.api.Implementation;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.LintFix;
import com.android.tools.lint.detector.api.ResourceXmlDetector;
import com.android.tools.lint.detector.api.Scope;
import com.android.tools.lint.detector.api.Severity;
import com.android.tools.lint.detector.api.XmlContext;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006H\u0002\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/lint/checks/RequiredFeatureDetector;", "Lcom/android/tools/lint/detector/api/ResourceXmlDetector;", "<init>", "()V", "getApplicableElements", "", "", "visitElement", "", "context", "Lcom/android/tools/lint/detector/api/XmlContext;", "element", "Lorg/w3c/dom/Element;", "isUnnecessaryRequiredFeature", "", "feature", "Companion", "android.sdktools.lint-checks"})
public final class RequiredFeatureDetector
extends ResourceXmlDetector {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Issue ISSUE;

    @Override
    @NotNull
    public Collection<String> getApplicableElements() {
        return CollectionsKt.listOf((Object)"uses-feature");
    }

    @Override
    public void visitElement(@NotNull XmlContext context2, @NotNull Element element) {
        boolean notRequired;
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        boolean bl = notRequired = !Intrinsics.areEqual((Object)element.getAttributeNS("http://schemas.android.com/apk/res/android", "required"), (Object)"false");
        if (!notRequired) {
            return;
        }
        Attr attr = element.getAttributeNodeNS("http://schemas.android.com/apk/res/android", "name");
        if (attr == null) {
            return;
        }
        Attr featureNode = attr;
        String feature = featureNode.getValue();
        Intrinsics.checkNotNull((Object)feature);
        if (this.isUnnecessaryRequiredFeature(feature)) {
            String message = "Consider whether this feature (`" + feature + "`) really is required for the app to function; you can set `android:required=\"false\"` to indicate that the feature is used but not required";
            LintFix fix2 = this.fix().set("http://schemas.android.com/apk/res/android", "required", "false").build();
            context2.report(ISSUE, featureNode, context2.getValueLocation(featureNode), message, fix2);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isUnnecessaryRequiredFeature(String feature) {
        String string2 = feature;
        switch (string2.hashCode()) {
            case 1565001464: {
                if (string2.equals("android.hardware.location.gps")) return true;
                return false;
            }
            case -933933689: {
                if (string2.equals("android.hardware.camera.autofocus")) return true;
                return false;
            }
            case 1712611232: {
                if (string2.equals("android.hardware.nfc.hce")) return true;
                return false;
            }
            case -1654552700: {
                if (string2.equals("android.hardware.touchscreen")) return true;
                return false;
            }
            case -271579786: {
                if (string2.equals("android.hardware.screen.portrait")) return true;
                return false;
            }
            case -1635327408: {
                if (string2.equals("android.hardware.touchscreen.multitouch")) return true;
                return false;
            }
            case -219257404: {
                if (string2.equals("android.hardware.nfc")) return true;
                return false;
            }
            case 2124036465: {
                if (string2.equals("android.hardware.telephony")) return true;
                return false;
            }
            case -381435922: {
                if (!string2.equals("android.hardware.camera.flash")) return false;
                return true;
            }
        }
        return false;
    }

    static {
        Issue.Companion companion = Issue.Companion;
        Category category = Category.USABILITY;
        Severity severity = Severity.WARNING;
        Implementation implementation = new Implementation(RequiredFeatureDetector.class, Scope.MANIFEST_SCOPE);
        ISSUE = Issue.Companion.create$default(companion, "UnnecessaryRequiredFeature", "Potentially unnecessary required feature", "\n          Avoid unnecessarily requiring features that may exclude your app from being served onto \\\n          devices it might otherwise support.\n\n          Consider whether your application can function adequately without restrictive feature \\\n          requirements by setting these to `android:required=\"false\"`. By doing so, you can increase \\\n          the availability of your app to a broader set of devices, including tablets, laptops and cars.\n          ", implementation, null, category, 2, severity, false, true, null, null, 3344, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/lint/checks/RequiredFeatureDetector$Companion;", "", "<init>", "()V", "ISSUE", "Lcom/android/tools/lint/detector/api/Issue;", "android.sdktools.lint-checks"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

