/*
 * Decompiled with CFR 0.152.
 */
package kexter;

import java.util.List;
import kexter.DexBytecode;
import kexter.DexDebuggerHelperKt;
import kexter.Instruction;
import kexter.Opcode;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\t\u001a\u00020\nH\u0002J\b\u0010\u000b\u001a\u00020\nH\u0002J\b\u0010\f\u001a\u00020\nH\u0002J\u0006\u0010\r\u001a\u00020\nJ\u0006\u0010\u000e\u001a\u00020\nR\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lkexter/DexDebuggerHelper;", "", "bytes", "", "<init>", "([B)V", "instructions", "", "Lkexter/Instruction;", "isSimpleMemberVariableGetter", "", "isSimpleStaticVariableGetter", "isJVMStaticVariableGetter", "isSimpleGetter", "hasStaticInvocations", "android.sdktools.kexter"})
@SourceDebugExtension(value={"SMAP\nDexDebuggerHelper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DexDebuggerHelper.kt\nkexter/DexDebuggerHelper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,93:1\n1863#2,2:94\n*S KotlinDebug\n*F\n+ 1 DexDebuggerHelper.kt\nkexter/DexDebuggerHelper\n*L\n85#1:94,2\n*E\n"})
public final class DexDebuggerHelper {
    @NotNull
    private final List<Instruction> instructions;

    public DexDebuggerHelper(@NotNull byte[] bytes) {
        Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
        this.instructions = DexBytecode.Companion.fromBytes$default(DexBytecode.Companion, bytes, null, null, 6, null).getInstructions();
    }

    private final boolean isSimpleMemberVariableGetter() {
        if (this.instructions.size() != 2) {
            return false;
        }
        return DexDebuggerHelperKt.isGetter(this.instructions.get(0).getOpcode()) && DexDebuggerHelperKt.isReturnValue(this.instructions.get(1).getOpcode());
    }

    private final boolean isSimpleStaticVariableGetter() {
        if (this.instructions.size() != 2) {
            return false;
        }
        return DexDebuggerHelperKt.isStaticGetter(this.instructions.get(0).getOpcode()) && DexDebuggerHelperKt.isReturnValue(this.instructions.get(1).getOpcode());
    }

    private final boolean isJVMStaticVariableGetter() {
        return false;
    }

    public final boolean isSimpleGetter() {
        return this.isSimpleMemberVariableGetter() || this.isSimpleStaticVariableGetter();
    }

    public final boolean hasStaticInvocations() {
        Iterable $this$forEach$iv = this.instructions;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Instruction instr = (Instruction)element$iv;
            boolean bl = false;
            if (instr.getOpcode() != Opcode.INVOKE_STATIC && instr.getOpcode() != Opcode.INVOKE_STATIC_RANGE) continue;
            return true;
        }
        return false;
    }
}

