/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon.clang;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.Stack;
import java.io.File;
import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public class OCClangMessagesParser {
    private static final Logger LOG = Logger.getInstance(OCClangMessagesParser.class);
    private File myClangDir;
    private String myFileName;
    private MessagesBuilder myBuilder;
    private StreamTokenizer myTokenizer;
    private Stack<String> myCategories;
    private Set<String> mySupportedIDs;
    private Map<String, String> myDiagnosticGroups;
    private Map<String, String> myTextSubstitutions;
    private Map<String, List<Object>> myClasses;
    private static final boolean VERIFY_IDS_MODE = false;
    private static final boolean ONLY_OUTPUT_SUPPORTED_MESSAGES = Boolean.parseBoolean(System.getProperty("only_supported"));
    private static final boolean CREATE_INDIVIDUAL_FILES = false;
    private static final String PREFIX = ONLY_OUTPUT_SUPPORTED_MESSAGES ? "supported" : "all";
    private static final String MESSAGES_FILE = PREFIX + "-messages.txt";
    private static final String INDIVIDUAL_MESSAGES_DIR = PREFIX + "-messages";
    private static final String SUPPORTED_IDS_FILE = "supported-ids.txt";

    public void setBuilder(MessagesBuilder builder) {
        this.myBuilder = builder;
    }

    public void parse(String text) throws IOException {
        if (ONLY_OUTPUT_SUPPORTED_MESSAGES && this.mySupportedIDs == null) {
            this.mySupportedIDs = new HashSet<String>();
            String supp = FileUtil.loadFile((File)new File(this.myClangDir, SUPPORTED_IDS_FILE));
            for (String id : StringUtil.split((String)supp, (String)"\n")) {
                if (id.startsWith("//") || id.isEmpty()) continue;
                this.mySupportedIDs.add(id.trim());
            }
        }
        if (this.myDiagnosticGroups == null) {
            this.myDiagnosticGroups = new HashMap<String, String>();
        }
        if (this.myTextSubstitutions == null) {
            this.myTextSubstitutions = new HashMap<String, String>();
        }
        if (this.myClasses == null) {
            this.myClasses = new HashMap<String, List<Object>>();
        }
        this.myTokenizer = new StreamTokenizer(new StringReader(text));
        this.myTokenizer.wordChars(95, 95);
        this.myTokenizer.ordinaryChars(48, 57);
        this.myTokenizer.wordChars(48, 57);
        this.myCategories = new Stack();
        this.myCategories.push((Object)"Empty Category");
        this.myTokenizer.nextToken();
        while (this.myTokenizer.ttype != -1) {
            if (this.parseLet() || this.parseDef() || this.parseClass()) continue;
            this.error("Let, def, or class expected");
        }
    }

    private boolean parseLet() throws IOException {
        if (!"let".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String key = this.skipWord();
        this.expectToken('=');
        String value = this.skipQuotedWord();
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            key = this.skipWord();
            this.expectToken('=');
            value = this.skipQuotedWord();
        }
        this.expectWord("in");
        this.expectToken('{');
        boolean isCategoryName = "CategoryName".equals(key);
        if (isCategoryName) {
            this.myCategories.push((Object)value);
        }
        while (this.parseLet() || this.parseDef() || this.parseClass()) {
        }
        if (isCategoryName) {
            this.myCategories.pop();
        }
        this.expectToken('}');
        return true;
    }

    private boolean parseClass() throws IOException {
        if (!"class".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String className = this.skipWord();
        this.expectToken(':');
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(this.parseOption());
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            options.add(this.parseOption());
        }
        this.expectToken(';');
        this.myClasses.put(className, options);
        return true;
    }

    private boolean parseDef() throws IOException {
        if (!"def".equals(this.getCurWord())) {
            return false;
        }
        this.skipWord();
        String id = null;
        if (this.myTokenizer.ttype != 58) {
            id = this.skipWord();
        }
        this.expectToken(':');
        String kind = null;
        String message = null;
        Object kindOption = this.parseOption();
        while (id != null) {
            if (kindOption instanceof Pair) {
                Pair kindOptionPair = (Pair)kindOption;
                if (!(kindOptionPair.first instanceof String)) {
                    this.error(id + " has no value for message kind");
                }
                if (!(kindOptionPair.second instanceof String)) {
                    this.error(id + " has no value for message text");
                }
                kind = (String)kindOptionPair.first;
                message = (String)kindOptionPair.second;
                break;
            }
            kind = (String)kindOption;
            List classDefinition = this.myClasses.getOrDefault(kind, null);
            if (classDefinition != null && !classDefinition.isEmpty() && (kindOption = classDefinition.get(0)) != null) continue;
            this.warn(id + " has no message text");
            break;
        }
        String group = "Empty Group";
        while (this.myTokenizer.ttype == 44) {
            this.expectToken(',');
            Object option = this.parseOption();
            if (id == null || !(option instanceof Pair) || !"InGroup".equals(((Pair)option).first)) continue;
            Object value = ((Pair)option).second;
            if (value instanceof String) {
                if (this.myDiagnosticGroups.containsKey((String)value)) {
                    group = this.myDiagnosticGroups.get((String)value);
                    continue;
                }
                this.error(id + " has no value for diagnostic group " + value);
                continue;
            }
            if (value instanceof Pair && "DiagGroup".equals(((Pair)value).first)) {
                value = ((Pair)value).second;
                if (value instanceof String) {
                    group = (String)value;
                    continue;
                }
                this.error(id + " has no value for option InGroup");
                continue;
            }
            this.error(id + " has no value for option InGroup");
        }
        if (this.myTokenizer.ttype == 123) {
            this.expectToken('{');
            this.parseGroupBody();
            this.expectToken('}');
        } else {
            this.expectToken(';');
        }
        if (id != null && message != null) {
            if ("DiagGroup".equals(kind)) {
                this.myDiagnosticGroups.put(id, message);
            } else if ("TextSubstitution".equals(kind)) {
                this.myTextSubstitutions.put(id, message);
            } else if (!ONLY_OUTPUT_SUPPORTED_MESSAGES || this.mySupportedIDs.contains(id)) {
                this.processMessageType(id, kind, (String)this.myCategories.peek(), group, message);
            }
        }
        return true;
    }

    private void parseGroupBody() throws IOException {
        this.expectWord("code");
        this.expectWord("Documentation");
        this.expectToken('=');
        this.parseMultilineString();
        this.expectToken(';');
    }

    private void parseMultilineString() throws IOException {
        int ttype;
        this.expectToken('[');
        this.expectToken('{');
        do {
            ttype = this.myTokenizer.ttype;
            this.myTokenizer.nextToken();
        } while (ttype != 125 || this.myTokenizer.ttype != 93);
        this.myTokenizer.nextToken();
    }

    @Nullable
    private Object parseOption() throws IOException {
        String option;
        Object optionValue = null;
        if (this.myTokenizer.ttype == 34) {
            StringBuilder message = new StringBuilder();
            while (this.myTokenizer.ttype == 34 || this.myTokenizer.ttype == -3) {
                message.append(this.myTokenizer.sval);
                this.myTokenizer.nextToken();
            }
            option = message.toString();
        } else {
            option = this.skipWord();
        }
        if (this.myTokenizer.ttype == 60) {
            this.expectToken('<');
            optionValue = this.parseOption();
            if (this.myTokenizer.ttype == 44) {
                this.expectToken(',');
                this.expectToken('[');
                this.skipWord();
                while (this.myTokenizer.ttype == 44) {
                    this.expectToken(',');
                    if (this.trySkipWord() != null) continue;
                }
                this.expectToken(']');
            }
            this.expectToken('>');
        }
        if (optionValue != null) {
            return Pair.create((Object)option, optionValue);
        }
        return option;
    }

    private void processMessageType(String id, String kind, String category, String group, String message) throws IOException {
        Message m = new Message(id, kind, category, group, message);
        this.myBuilder.addMessage(m);
    }

    private String convertPattern(String rawMessage) {
        return new Parser(rawMessage, this.myTextSubstitutions).parse();
    }

    @TestOnly
    public static String convertPatternRaw(String rawMessage) {
        return new Parser(rawMessage, Collections.emptyMap()).parse();
    }

    private int getCurLineNo() {
        return this.myTokenizer != null ? this.myTokenizer.lineno() : -1;
    }

    private String getCurWord() {
        if (this.myTokenizer.ttype == -3) {
            return this.myTokenizer.sval;
        }
        return "";
    }

    private String skipWord() throws IOException {
        String word = this.trySkipWord();
        if (word == null) {
            this.error("Expected word");
        }
        return word;
    }

    private String trySkipWord() throws IOException {
        if (this.myTokenizer.ttype == -3) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        return null;
    }

    private String skipQuotedWord() throws IOException {
        if (this.myTokenizer.ttype == 34 || this.myTokenizer.ttype == -3) {
            String sval = this.myTokenizer.sval;
            this.myTokenizer.nextToken();
            return sval;
        }
        this.error("Expected quoted word");
        return null;
    }

    private void expectWord(String wordText) throws IOException {
        if (this.myTokenizer.ttype == -3 && wordText.equals(this.myTokenizer.sval)) {
            this.myTokenizer.nextToken();
        } else {
            this.error("Expected '" + wordText + "'");
        }
    }

    private void expectToken(char token) throws IOException {
        if (this.myTokenizer.ttype == token) {
            this.myTokenizer.nextToken();
        } else {
            this.error("Expected '" + token + "'");
        }
    }

    @Contract(value="_ -> fail")
    private void error(@NotNull String message) {
        if (message == null) {
            OCClangMessagesParser.$$$reportNull$$$0(0);
        }
        LOG.error(message + " at " + this.myFileName + ":" + this.getCurLineNo());
    }

    private void warn(@NotNull String message) {
        if (message == null) {
            OCClangMessagesParser.$$$reportNull$$$0(1);
        }
        LOG.warn(message + " at " + this.myFileName + ":" + this.getCurLineNo());
    }

    private void generatePatterns(File clangDirOrFile) throws IOException {
        this.myBuilder = new MessagesBuilder();
        Object[] files = clangDirOrFile.listFiles();
        if (files != null) {
            Arrays.sort(files);
            this.myClangDir = clangDirOrFile;
            File groupsFile = new File(clangDirOrFile, "DiagnosticGroups.td");
            if (groupsFile.exists()) {
                String messages = FileUtil.loadFile((File)groupsFile);
                this.myFileName = groupsFile.getName();
                this.parse(messages);
            }
            for (Object file : files) {
                if (!((File)file).getName().endsWith("Kinds.td")) continue;
                String messages = FileUtil.loadFile((File)file);
                this.myFileName = ((File)file).getName();
                this.parse(messages);
            }
        } else if (clangDirOrFile.getName().endsWith("td")) {
            this.myClangDir = clangDirOrFile.getParentFile();
            String messages = FileUtil.loadFile((File)clangDirOrFile);
            this.myFileName = clangDirOrFile.getName();
            this.parse(messages);
        }
        File outputFile = new File(this.myClangDir, MESSAGES_FILE);
        if (ONLY_OUTPUT_SUPPORTED_MESSAGES) {
            this.myBuilder.sort();
        }
        FileUtil.writeToFile((File)outputFile, (String)this.myBuilder.toString());
    }

    public static void main(String[] args) throws IOException {
        if (args.length >= 1) {
            for (String arg : args) {
                File clangDir = new File(arg);
                System.out.println("== " + clangDir.getName() + " ==");
                if (!clangDir.exists()) {
                    System.err.println(clangDir.getPath() + " does not exist");
                    return;
                }
                new OCClangMessagesParser().generatePatterns(clangDir);
            }
        } else {
            System.err.println("Usage: <path to .td file or directory with .td files> ...");
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "message";
        objectArray2[1] = "com/jetbrains/cidr/lang/daemon/clang/OCClangMessagesParser";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "error";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "warn";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static class MessagesBuilder {
        List<Message> messages = new ArrayList<Message>();

        public void addMessage(Message message) {
            this.messages.add(message);
        }

        public void sort() {
            this.messages.sort(Comparator.comparing(m -> m.myId));
        }

        public String toString() {
            StringJoiner joiner = new StringJoiner("\n");
            for (Message message : this.messages) {
                joiner.add(message.toString());
            }
            joiner.add("");
            return joiner.toString();
        }
    }

    public class Message {
        public final String myId;
        public final String myKind;
        public final String myCategory;
        public final String myGroup;
        public final String myMessage;

        public Message(String id, String kind, String category, String group, String message) {
            this.myId = id;
            this.myKind = kind;
            this.myCategory = category;
            this.myGroup = group;
            this.myMessage = message;
        }

        public String toString() {
            return String.join((CharSequence)"\n", this.myId, this.myKind, this.myCategory, this.myGroup, OCClangMessagesParser.this.convertPattern(this.myMessage));
        }
    }

    private static class Parser {
        private final String myMessage;
        private final int myLength;
        private final Map<String, String> myTextSubstitutions;
        private int myIndex;
        private final StringBuilder myResult = new StringBuilder();

        Parser(String message, Map<String, String> textSubstitutions) {
            this.myMessage = message;
            this.myLength = message.length();
            this.myTextSubstitutions = textSubstitutions;
        }

        public String parse() {
            while (this.myIndex < this.myLength) {
                char c;
                if ((c = this.myMessage.charAt(this.myIndex++)) == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                this.appendChar(c);
            }
            return this.myResult.toString();
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private void parseOperatorStart() {
            String operator;
            boolean isDigit;
            char c = this.myMessage.charAt(this.myIndex);
            if (this.myIndex < this.myLength && !Character.isLetterOrDigit(c)) {
                ++this.myIndex;
                this.appendChar(c);
                return;
            }
            StringBuilder name = new StringBuilder();
            for (boolean seenDigit = false; (isDigit = Character.isDigit(c)) || !seenDigit && Character.isLetter(c); seenDigit |= isDigit) {
                name.append(c);
                if (++this.myIndex >= this.myLength) break;
                c = this.myMessage.charAt(this.myIndex);
            }
            if ((operator = name.toString()).equals("sub")) {
                assert (this.myIndex < this.myLength);
                assert (this.myMessage.charAt(this.myIndex) == '{');
                ++this.myIndex;
                String substitutionId = this.parseSubstitutionId();
                if (!this.myTextSubstitutions.containsKey(substitutionId)) throw new AssertionError((Object)("No substitution found for " + substitutionId));
                this.myResult.append(new Parser(this.myTextSubstitutions.get(substitutionId), this.myTextSubstitutions).parse());
                return;
            } else if (operator.equals("select") || operator.equals("diff") || operator.equals("plural")) {
                assert (this.myIndex < this.myLength);
                assert (this.myMessage.charAt(this.myIndex) == '{');
                ++this.myIndex;
                this.myResult.append("(");
                this.parseOperator(operator.equals("plural"));
                return;
            } else {
                if (operator.length() != 1 && !operator.chars().anyMatch(Character::isDigit)) throw new AssertionError((Object)("Unknown operator: " + operator));
                this.myResult.append(".*");
            }
        }

        private String parseSubstitutionId() {
            StringBuilder result = new StringBuilder();
            while (this.myIndex < this.myLength) {
                char c;
                if ((c = this.myMessage.charAt(this.myIndex++)) == '}') {
                    this.skipOperatorArguments();
                    return result.toString();
                }
                result.append(c);
            }
            return result.toString();
        }

        private void parseOperator(boolean plural) {
            boolean startPart = plural;
            while (this.myIndex < this.myLength) {
                char c = this.myMessage.charAt(this.myIndex++);
                if (startPart) {
                    if (Character.isDigit(c) || c == ':') continue;
                    startPart = false;
                }
                if (c == '%') {
                    this.parseOperatorStart();
                    continue;
                }
                if (c == '}') {
                    this.parseOperatorEnd();
                    return;
                }
                if (c == '|') {
                    this.myResult.append("|");
                    startPart = plural;
                    continue;
                }
                this.appendChar(c);
            }
            assert (false);
        }

        private void parseOperatorEnd() {
            this.skipOperatorArguments();
            this.myResult.append(")");
        }

        private void skipOperatorArguments() {
            char c;
            while (this.myIndex < this.myLength && (Character.isDigit(c = this.myMessage.charAt(this.myIndex)) || c == ',')) {
                ++this.myIndex;
            }
        }

        private void appendChar(char c) {
            if (c == '$') {
                this.myResult.append(".*");
            } else if (c == '(' || c == ')' || c == '+' || c == '*' || c == '?' || c == '.' || c == '[' || c == ']' || c == '{' || c == '}' || c == '|' || c == '\\' || c == '\"') {
                this.myResult.append("\\").append(c);
            } else {
                this.myResult.append(c);
            }
        }
    }
}

