/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.util.OCParenthesesUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class OCControlFlowGraph {
    private final PsiElement myCodeFragment;
    private final List<OCNode> myNodes;
    private OCNode myStartNode;
    private final Set<OCNode> myExitNodes;
    private final Set<OCNode> myReturnNodes;
    private final OCControlFlowGraph myParentGraph;
    private int myForbidSplitNodesDepth;
    private int myNextNodeId;
    private final LinkedHashMap<OCSymbol, MultiMap<OCInstruction.InstructionKind, OCInstruction>> myInstructions;
    private final LinkedHashMap<PsiElement, OCInstruction> myReadInstructions;
    private final Set<OCInstruction> myAllInstructions;
    private final LinkedHashMap<OCSymbol, OCInstruction> myDeclarators;
    private final LinkedHashMap<OCSymbol, OCControlFlowGraph> myClosureVariables;

    public OCControlFlowGraph(@NotNull PsiElement codeFragment, @Nullable OCControlFlowGraph parentGraph) {
        if (codeFragment == null) {
            OCControlFlowGraph.$$$reportNull$$$0(0);
        }
        this.myNodes = new ArrayList<OCNode>();
        this.myExitNodes = new LinkedHashSet<OCNode>();
        this.myReturnNodes = new LinkedHashSet<OCNode>();
        this.myInstructions = new LinkedHashMap();
        this.myReadInstructions = new LinkedHashMap();
        this.myAllInstructions = new LinkedHashSet<OCInstruction>();
        this.myDeclarators = new LinkedHashMap();
        this.myClosureVariables = new LinkedHashMap();
        this.myCodeFragment = codeFragment;
        this.myParentGraph = parentGraph;
    }

    @NotNull
    public List<OCNode> getNodes() {
        List<OCNode> list = this.myNodes;
        if (list == null) {
            OCControlFlowGraph.$$$reportNull$$$0(1);
        }
        return list;
    }

    public int getNumOfNodes() {
        return this.myNodes.size();
    }

    public int getNextNodeId() {
        return this.myNextNodeId++;
    }

    @NotNull
    public OCNode addNode() {
        OCNode oCNode = this.addNode(false);
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(2);
        }
        return oCNode;
    }

    @NotNull
    public OCNode addNode(boolean isFake) {
        if (this.isSplitNodesAllowed() || isFake) {
            OCNode node = new OCNode(this, this.myNodes.size(), this.myNextNodeId++, isFake);
            this.myNodes.add(node);
            OCNode oCNode = node;
            if (oCNode == null) {
                OCControlFlowGraph.$$$reportNull$$$0(3);
            }
            return oCNode;
        }
        OCNode oCNode = this.getLastAddedNode();
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(4);
        }
        return oCNode;
    }

    public void forbidSplittingNodes() {
        ++this.myForbidSplitNodesDepth;
    }

    public void allowSplittingNodes() {
        --this.myForbidSplitNodesDepth;
    }

    public boolean isSplitNodesAllowed() {
        return this.myForbidSplitNodesDepth == 0;
    }

    public void removeNode(@NotNull OCNode node, boolean isFake) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(5);
        }
        if (this.isSplitNodesAllowed() || isFake) {
            assert (this.getLastAddedNode() == node && (node.isEmpty() || node.isFake()));
            this.myNodes.remove(this.getNumOfNodes() - 1);
        }
    }

    public void setStartNode(@NotNull OCNode startNode) {
        if (startNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(6);
        }
        this.myStartNode = startNode;
    }

    @NotNull
    public OCNode getStartNode() {
        OCNode oCNode = this.myStartNode;
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(7);
        }
        return oCNode;
    }

    public void addReturnNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(8);
        }
        this.myExitNodes.add(node);
        this.myReturnNodes.add(node);
    }

    public void addExitNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(9);
        }
        this.myExitNodes.add(node);
    }

    @NotNull
    public Set<OCNode> getExitNodes() {
        Set<OCNode> set = this.myExitNodes;
        if (set == null) {
            OCControlFlowGraph.$$$reportNull$$$0(10);
        }
        return set;
    }

    @NotNull
    public Set<OCNode> getReturnNodes() {
        Set<OCNode> set = this.myReturnNodes;
        if (set == null) {
            OCControlFlowGraph.$$$reportNull$$$0(11);
        }
        return set;
    }

    @Nullable
    public OCNode getPreviousNonEmptyNode(@NotNull OCNode node) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(12);
        }
        for (int index = node.getIndex() - 1; index >= 0; --index) {
            if (this.myNodes.get(index).getRange() == null) continue;
            return this.myNodes.get(index);
        }
        return null;
    }

    @NotNull
    public OCNode getLastAddedNode() {
        OCNode oCNode = this.myNodes.get(this.getNumOfNodes() - 1);
        if (oCNode == null) {
            OCControlFlowGraph.$$$reportNull$$$0(13);
        }
        return oCNode;
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(14);
        }
        return this.addInstruction(this.getLastAddedNode(), kind, null, rValue, symbol);
    }

    @Nullable
    public OCInstruction addInstruction(@NotNull OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(15);
        }
        return this.addInstruction(this.getLastAddedNode(), kind, lValue, rValue, symbol);
    }

    @Nullable
    private OCInstruction addInstruction(@NotNull OCNode node, OCInstruction.InstructionKind kind, @Nullable PsiElement lValue, @Nullable PsiElement rValue, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(16);
        }
        if (symbol == null) {
            return null;
        }
        OCInstruction instruction = new OCInstruction(kind, node, lValue, rValue, symbol);
        if (kind == OCInstruction.InstructionKind.WRITE) {
            OCInstruction read = this.myReadInstructions.get(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue));
            if (read != null && read.getKind() == OCInstruction.InstructionKind.READ) {
                read.setAssociatedInstruction(instruction);
                instruction.setAssociatedInstruction(read);
            }
        } else if (kind == OCInstruction.InstructionKind.READ) {
            this.myReadInstructions.put(OCParenthesesUtils.diveIntoParenthesesAndCasts(rValue), instruction);
        }
        if (kind == OCInstruction.InstructionKind.DECLARATOR) {
            this.myDeclarators.put(symbol, instruction);
        } else if (!this.myDeclarators.containsKey(symbol)) {
            OCControlFlowGraph parent = this.myParentGraph;
            while (parent != null && !parent.myDeclarators.containsKey(symbol)) {
                parent = parent.myParentGraph;
            }
            if (parent != null) {
                this.myClosureVariables.put(symbol, parent);
            }
        }
        MultiMap multiMap = this.myInstructions.computeIfAbsent(symbol, k -> MultiMap.createLinked());
        multiMap.putValue((Object)kind, (Object)instruction);
        this.myAllInstructions.add(instruction);
        node.addInstruction(instruction);
        return instruction;
    }

    public void addInstructions(@NotNull OCNode node, @NotNull OCInstruction.InstructionKind kind, @NotNull Collection<OCInstruction> instructions) {
        if (node == null) {
            OCControlFlowGraph.$$$reportNull$$$0(17);
        }
        if (kind == null) {
            OCControlFlowGraph.$$$reportNull$$$0(18);
        }
        if (instructions == null) {
            OCControlFlowGraph.$$$reportNull$$$0(19);
        }
        for (OCInstruction instruction : instructions) {
            OCInstruction newInstruction = this.addInstruction(node, kind, instruction.getLValue(), instruction.getRValue(), instruction.getSymbol());
            if (newInstruction == null) continue;
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            newInstruction.setAssociatedInstruction(associatedInstruction != null ? associatedInstruction : instruction);
        }
    }

    @Nullable
    public MultiMap<OCInstruction.InstructionKind, OCInstruction> getInstructions(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(20);
        }
        return this.myInstructions.get(symbol);
    }

    public Set<OCInstruction> getAllInstructions() {
        return this.myAllInstructions;
    }

    public OCInstruction getDeclaratorInstruction(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(21);
        }
        return this.myDeclarators.get(symbol);
    }

    public Set<OCSymbol> getLocalSymbols() {
        return this.myDeclarators.keySet();
    }

    public Set<OCSymbol> getClosureSymbols() {
        return this.myClosureVariables.keySet();
    }

    public OCControlFlowGraph getClosureVariableDeclaratorGraph(@NotNull OCSymbol symbol) {
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(22);
        }
        return this.myClosureVariables.get(symbol);
    }

    @NotNull
    public PsiElement getCodeFragment() {
        PsiElement psiElement = this.myCodeFragment;
        if (psiElement == null) {
            OCControlFlowGraph.$$$reportNull$$$0(23);
        }
        return psiElement;
    }

    @Nullable
    public OCControlFlowGraph getParentGraph() {
        return this.myParentGraph;
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("<CFG>\n");
        String fileText = this.myCodeFragment.getContainingFile().getText();
        for (OCNode node : this.myNodes) {
            String nodeName = "node";
            if (node == this.myStartNode) {
                nodeName = "start-node";
            } else if (this.myExitNodes.contains(node)) {
                nodeName = "exit-node";
            }
            result.append("  <").append(nodeName).append(" id=\"").append(node.getIndex()).append("\">\n");
            OCElementsRange range = node.getRange();
            if (range != null) {
                TextRange textRange = range.getTextRange();
                result.append(textRange.substring(fileText).trim()).append("\n");
            }
            if (node.getJumpTargets() != null) {
                for (OCNode target : node.getJumpTargets()) {
                    result.append("    <target node-id=\"").append(target.getIndex()).append("\"/>\n");
                }
            }
            result.append("  </").append(nodeName).append(">\n");
        }
        result.append("</CFG>\n");
        return result.toString();
    }

    public boolean hasInstructionsInParentGraph(@NotNull OCSymbol symbol, OCInstruction.InstructionKind ... kinds) {
        OCControlFlowGraph parentCfg;
        if (symbol == null) {
            OCControlFlowGraph.$$$reportNull$$$0(24);
        }
        if ((parentCfg = this.getClosureVariableDeclaratorGraph(symbol)) == null) {
            return false;
        }
        MultiMap<OCInstruction.InstructionKind, OCInstruction> instructions = parentCfg.getInstructions(symbol);
        if (instructions == null) {
            return false;
        }
        for (OCInstruction.InstructionKind kind : kinds) {
            for (OCInstruction instruction : instructions.get((Object)kind)) {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getNode().getGraph() == this) continue;
                return true;
            }
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 7, 10, 11, 13, 23 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "codeFragment";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph";
                break;
            }
            case 5: 
            case 8: 
            case 9: 
            case 12: 
            case 16: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "startNode";
                break;
            }
            case 14: 
            case 15: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "kind";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instructions";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "symbol";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCControlFlowGraph";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getNodes";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "addNode";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getStartNode";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getExitNodes";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnNodes";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getLastAddedNode";
                break;
            }
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "getCodeFragment";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 10: 
            case 11: 
            case 13: 
            case 23: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "removeNode";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "setStartNode";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "addReturnNode";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addExitNode";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getPreviousNonEmptyNode";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "addInstruction";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "addInstructions";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getInstructions";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDeclaratorInstruction";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getClosureVariableDeclaratorGraph";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "hasInstructionsInParentGraph";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 7, 10, 11, 13, 23 -> new IllegalStateException(string);
        };
    }
}

