/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.dfa;

import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.Stack;
import com.jetbrains.cidr.lang.dfa.OCControlFlowGraph;
import com.jetbrains.cidr.lang.dfa.OCDataFlowAlgorithm;
import com.jetbrains.cidr.lang.dfa.OCInstruction;
import com.jetbrains.cidr.lang.dfa.OCNode;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCMultiSymbolAlgorithm
extends OCDataFlowAlgorithm {
    private final Map<OCSymbol, boolean[]> myVisitedNodes = new HashMap<OCSymbol, boolean[]>();
    private final Stack<OCInstruction> myStack = new Stack();
    private final Set<OCInstruction> myGoodReads = new HashSet<OCInstruction>();
    private final Set<OCSymbol> myReferencedSymbols = new HashSet<OCSymbol>();

    protected OCMultiSymbolAlgorithm(OCControlFlowGraph cfg) {
        super(cfg);
    }

    @Override
    public void process() {
        this.myStack.addAll(this.getStartInstructions());
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                if (!this.myCfg.hasInstructionsInParentGraph(symbol, OCInstruction.InstructionKind.WRITE, OCInstruction.InstructionKind.WRITE_IN_BLOCK, OCInstruction.InstructionKind.REFERENCE)) continue;
                this.traverseFromStart(symbol);
            }
        }
        while (!this.myStack.isEmpty()) {
            OCInstruction instruction = (OCInstruction)this.myStack.pop();
            this.traverse(instruction, instruction.getSymbol(), true);
        }
    }

    @Override
    protected boolean acceptsInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(0);
        }
        if (this.myReferencedSymbols.contains(instruction.getSymbol())) {
            return true;
        }
        return switch (instruction.getKind()) {
            case OCInstruction.InstructionKind.KILL -> false;
            case OCInstruction.InstructionKind.WRITE -> this.isStartInstruction(instruction);
            default -> true;
        };
    }

    @Override
    protected boolean isStartInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(1);
        }
        return switch (instruction.getKind()) {
            case OCInstruction.InstructionKind.REFERENCE, OCInstruction.InstructionKind.WRITE_IN_BLOCK -> this.treatReferencesAsStartInstructions();
            case OCInstruction.InstructionKind.WRITE -> {
                OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
                if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.READ) {
                    yield this.isGoodRead(associatedInstruction);
                }
                yield this.isGoodWrite(instruction.getRValue());
            }
            default -> false;
        };
    }

    protected boolean isGoodRead(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(2);
        }
        return this.myGoodReads.contains(instruction);
    }

    @Override
    protected boolean isEndInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(3);
        }
        return instruction.getKind() == OCInstruction.InstructionKind.READ;
    }

    protected boolean treatReferencesAsStartInstructions() {
        return true;
    }

    @Override
    protected boolean processInstruction(@NotNull OCInstruction instruction) {
        if (instruction == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(4);
        }
        if (instruction.getKind() == OCInstruction.InstructionKind.READ) {
            OCInstruction associatedInstruction = instruction.getAssociatedInstruction();
            if (associatedInstruction != null && associatedInstruction.getKind() == OCInstruction.InstructionKind.WRITE) {
                this.myGoodReads.add(instruction);
                this.myStack.push((Object)associatedInstruction);
            }
        } else if (instruction.getKind() == OCInstruction.InstructionKind.WRITE_IN_BLOCK || instruction.getKind() == OCInstruction.InstructionKind.REFERENCE) {
            this.myReferencedSymbols.add(instruction.getSymbol());
        }
        return this.acceptsInstruction(instruction);
    }

    protected boolean processClosureSymbols() {
        return true;
    }

    @Override
    protected boolean isNodeProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(5);
        }
        boolean[] set = symbol != null ? this.myVisitedNodes.get(symbol) : null;
        return set != null && set[node.getIndex()];
    }

    @Override
    protected void markNodeAsProcessed(@NotNull OCNode node, @Nullable OCSymbol symbol) {
        if (node == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(6);
        }
        if (symbol != null) {
            boolean[] set = this.myVisitedNodes.computeIfAbsent(symbol, k -> new boolean[this.myCfg.getNumOfNodes()]);
            set[node.getIndex()] = true;
        }
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements(boolean nonReachable) {
        ArrayList<Pair<OCSymbol, PsiElement>> result = new ArrayList<Pair<OCSymbol, PsiElement>>();
        for (OCSymbol symbol : this.myCfg.getLocalSymbols()) {
            for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                result.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
            }
        }
        if (this.processClosureSymbols()) {
            for (OCSymbol symbol : this.myCfg.getClosureSymbols()) {
                for (PsiElement element : this.getReachableElements(true, symbol, nonReachable)) {
                    result.add((Pair<OCSymbol, PsiElement>)Pair.create((Object)symbol, (Object)element));
                }
            }
        }
        ArrayList<Pair<OCSymbol, PsiElement>> arrayList = result;
        if (arrayList == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(7);
        }
        return arrayList;
    }

    @NotNull
    protected List<Pair<OCSymbol, PsiElement>> getReachableElements() {
        List<Pair<OCSymbol, PsiElement>> list = this.getReachableElements(false);
        if (list == null) {
            OCMultiSymbolAlgorithm.$$$reportNull$$$0(8);
        }
        return list;
    }

    protected abstract boolean isGoodWrite(@Nullable PsiElement var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/cidr/lang/dfa/OCMultiSymbolAlgorithm";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getReachableElements";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptsInstruction";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "isStartInstruction";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isGoodRead";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEndInstruction";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processInstruction";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "isNodeProcessed";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "markNodeAsProcessed";
                break;
            }
            case 7: 
            case 8: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8 -> new IllegalStateException(string);
        };
    }
}

